/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.dev;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherTextboxRecord;
import ai2.org.apache.poi.hslf.record.EscherTextboxWrapper;
import ai2.org.apache.poi.hslf.record.HSLFEscherRecordFactory;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.StyleTextPropAtom;
import ai2.org.apache.poi.hslf.record.TextBytesAtom;
import ai2.org.apache.poi.hslf.record.TextCharsAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import ai2.org.apache.poi.util.HexDump;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;

public final class SlideShowRecordDumper {
    private boolean optVerbose;
    private boolean optEscher;
    private HSLFSlideShowImpl doc;

    public static void main(String[] stringArray) throws IOException {
        int n;
        String string = "";
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < stringArray.length && stringArray[n].substring(0, 1).equals("-"); ++n) {
            if (stringArray[n].equals("-escher")) {
                bl2 = true;
                continue;
            }
            if (stringArray[n].equals("-verbose")) {
                bl = true;
                continue;
            }
            SlideShowRecordDumper.printUsage();
            return;
        }
        if (n != stringArray.length - 1) {
            SlideShowRecordDumper.printUsage();
            return;
        }
        string = stringArray[n];
        SlideShowRecordDumper slideShowRecordDumper = new SlideShowRecordDumper(string, bl, bl2);
        slideShowRecordDumper.printDump();
    }

    public static void printUsage() {
        System.err.println("Usage: SlideShowRecordDumper [-escher] [-verbose] <filename>");
        System.err.println("Valid Options:");
        System.err.println("-escher\t\t: dump contents of escher records");
        System.err.println("-verbose\t: dump binary contents of each record");
    }

    public SlideShowRecordDumper(String string, boolean bl, boolean bl2) throws IOException {
        this.optVerbose = bl;
        this.optEscher = bl2;
        this.doc = new HSLFSlideShowImpl(string);
    }

    public void printDump() throws IOException {
        this.walkTree(0, 0, this.doc.getRecords());
    }

    public String makeHex(int n, int n2) {
        String string = Integer.toHexString(n).toUpperCase(Locale.ROOT);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public String reverseHex(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() / 2 * 2 != string.length()) {
            string = "0" + string;
        }
        char[] cArray = string.toCharArray();
        for (int i = cArray.length; i > 0; i -= 2) {
            stringBuffer.append(cArray[i - 2]);
            stringBuffer.append(cArray[i - 1]);
            if (i == 2) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public int getDiskLen(Record record) throws IOException {
        if (record == null) {
            return 0;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        record.writeOut(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray.length;
    }

    public String getPrintableRecordContents(Record record) throws IOException {
        if (record == null) {
            return "<<null>>";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        record.writeOut(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return HexDump.dump(byArray, 0L, 0);
    }

    public String printEscherRecord(EscherRecord escherRecord) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        if (escherRecord instanceof EscherContainerRecord) {
            stringBuffer.append(this.printEscherContainerRecord((EscherContainerRecord)escherRecord));
        } else if (escherRecord instanceof EscherTextboxRecord) {
            stringBuffer.append("EscherTextboxRecord:" + string);
            EscherTextboxWrapper escherTextboxWrapper = new EscherTextboxWrapper((EscherTextboxRecord)escherRecord);
            Record[] recordArray = escherTextboxWrapper.getChildRecords();
            for (int i = 0; i < recordArray.length; ++i) {
                if (recordArray[i] instanceof StyleTextPropAtom) {
                    if (i > 0 && (recordArray[i - 1] instanceof TextCharsAtom || recordArray[i - 1] instanceof TextBytesAtom)) {
                        int n = recordArray[i - 1] instanceof TextCharsAtom ? ((TextCharsAtom)recordArray[i - 1]).getText().length() : ((TextBytesAtom)recordArray[i - 1]).getText().length();
                        StyleTextPropAtom styleTextPropAtom = (StyleTextPropAtom)recordArray[i];
                        styleTextPropAtom.setParentTextSize(n);
                    } else {
                        stringBuffer.append("Error! Couldn't find preceding TextAtom for style\n");
                    }
                    stringBuffer.append(recordArray[i].toString() + string);
                    continue;
                }
                stringBuffer.append(recordArray[i].toString() + string);
            }
        } else {
            stringBuffer.append(escherRecord.toString());
        }
        return stringBuffer.toString();
    }

    public String printEscherContainerRecord(EscherContainerRecord escherContainerRecord) {
        String string = "";
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Iterator<EscherRecord> iterator = escherContainerRecord.getChildIterator();
        while (iterator.hasNext()) {
            if (n < 1) {
                stringBuffer.append("  children: " + string2);
            }
            String string3 = "   ";
            EscherRecord escherRecord = iterator.next();
            stringBuffer.append(string3 + "Child " + n + ":" + string2);
            stringBuffer.append(this.printEscherRecord(escherRecord));
            ++n;
        }
        return string + escherContainerRecord.getClass().getName() + " (" + escherContainerRecord.getRecordName() + "):" + string2 + string + "  isContainer: " + escherContainerRecord.isContainerRecord() + string2 + string + "  options: 0x" + HexDump.toHex(escherContainerRecord.getOptions()) + string2 + string + "  recordId: 0x" + HexDump.toHex(escherContainerRecord.getRecordId()) + string2 + string + "  numchildren: " + escherContainerRecord.getChildRecords().size() + string2 + string + stringBuffer.toString();
    }

    public void walkTree(int n, int n2, Record[] recordArray) throws IOException {
        int n3;
        int n4 = n;
        String string = "";
        for (n3 = 0; n3 < n4; ++n3) {
            string = string + " ";
        }
        for (n3 = 0; n3 < recordArray.length; ++n3) {
            Object object;
            Record record = recordArray[n3];
            if (record == null) {
                System.out.println(string + "At position " + n2 + " (" + this.makeHex(n2, 6) + "):");
                System.out.println(string + "Warning! Null record found.");
                continue;
            }
            int n5 = this.getDiskLen(record);
            String string2 = this.makeHex((int)record.getRecordType(), 4);
            String string3 = this.reverseHex(string2);
            Class<?> clazz = record.getClass();
            String string4 = clazz.toString();
            if (string4.startsWith("class ")) {
                string4 = string4.substring(6);
            }
            if (string4.startsWith("ai2.org.apache.poi.hslf.record.")) {
                string4 = string4.substring(27);
            }
            System.out.println(string + "At position " + n2 + " (" + this.makeHex(n2, 6) + "):");
            System.out.println(string + " Record is of type " + string4);
            System.out.println(string + " Type is " + record.getRecordType() + " (" + string2 + " -> " + string3 + " )");
            System.out.println(string + " Len is " + (n5 - 8) + " (" + this.makeHex(n5 - 8, 8) + "), on disk len is " + n5);
            if (this.optEscher && string4.equals("PPDrawing")) {
                object = new HSLFEscherRecordFactory();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                record.writeOut(byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                EscherRecord escherRecord = ((DefaultEscherRecordFactory)object).createRecord(byArray, 0);
                escherRecord.fillFields(byArray, 0, (EscherRecordFactory)object);
                System.out.println(this.printEscherRecord(escherRecord));
            } else if (this.optVerbose && record.getChildRecords() == null) {
                object = this.getPrintableRecordContents(record);
                System.out.println(string + (String)object);
            }
            System.out.println();
            if (record.getChildRecords() != null) {
                this.walkTree(n + 3, n2 + 8, record.getChildRecords());
            }
            n2 += n5;
        }
    }
}

