/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.dev;

import ai2.org.apache.poi.hslf.record.Document;
import ai2.org.apache.poi.hslf.record.Notes;
import ai2.org.apache.poi.hslf.record.NotesAtom;
import ai2.org.apache.poi.hslf.record.PersistPtrHolder;
import ai2.org.apache.poi.hslf.record.PositionDependentRecord;
import ai2.org.apache.poi.hslf.record.PositionDependentRecordContainer;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.Slide;
import ai2.org.apache.poi.hslf.record.SlideAtom;
import ai2.org.apache.poi.hslf.record.SlideListWithText;
import ai2.org.apache.poi.hslf.record.SlidePersistAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShow;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public final class SlideIdListing {
    private static byte[] fileContents;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        int n;
        if (stringArray.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShowImpl hSLFSlideShowImpl = new HSLFSlideShowImpl(stringArray[0]);
        HSLFSlideShow hSLFSlideShow = new HSLFSlideShow(hSLFSlideShowImpl);
        fileContents = hSLFSlideShowImpl.getUnderlyingBytes();
        Record[] recordArray = hSLFSlideShowImpl.getRecords();
        Record[] recordArray2 = hSLFSlideShow.getMostRecentCoreRecords();
        Document document = null;
        for (int i = 0; i < recordArray2.length; ++i) {
            if (!(recordArray2[i] instanceof Document)) continue;
            document = (Document)recordArray2[i];
        }
        System.out.println("");
        SlideListWithText[] slideListWithTextArray = document.getSlideListWithTexts();
        for (n = 0; n < slideListWithTextArray.length; ++n) {
            object2 = slideListWithTextArray[n].getChildRecords();
            for (int i = 0; i < ((Record[])object2).length; ++i) {
                if (!(object2[i] instanceof SlidePersistAtom)) continue;
                object = (SlidePersistAtom)object2[i];
                System.out.println("SlidePersistAtom knows about slide:");
                System.out.println("\t" + ((SlidePersistAtom)object).getRefID());
                System.out.println("\t" + ((SlidePersistAtom)object).getSlideIdentifier());
            }
        }
        System.out.println("");
        for (n = 0; n < recordArray2.length; ++n) {
            if (!(recordArray2[n] instanceof Slide)) continue;
            object2 = (Slide)recordArray2[n];
            SlideAtom slideAtom = ((Slide)object2).getSlideAtom();
            System.out.println("Found the latest version of a slide record:");
            System.out.println("\tCore ID is " + ((PositionDependentRecordContainer)object2).getSheetId());
            System.out.println("\t(Core Records count is " + n + ")");
            System.out.println("\tDisk Position is " + ((PositionDependentRecordContainer)object2).getLastOnDiskOffset());
            System.out.println("\tMaster ID is " + slideAtom.getMasterID());
            System.out.println("\tNotes ID is " + slideAtom.getNotesID());
        }
        System.out.println("");
        for (n = 0; n < recordArray2.length; ++n) {
            if (!(recordArray2[n] instanceof Notes)) continue;
            object2 = (Notes)recordArray2[n];
            NotesAtom notesAtom = ((Notes)object2).getNotesAtom();
            System.out.println("Found the latest version of a notes record:");
            System.out.println("\tCore ID is " + ((PositionDependentRecordContainer)object2).getSheetId());
            System.out.println("\t(Core Records count is " + n + ")");
            System.out.println("\tDisk Position is " + ((PositionDependentRecordContainer)object2).getLastOnDiskOffset());
            System.out.println("\tMatching slide is " + notesAtom.getSlideID());
        }
        System.out.println("");
        n = 0;
        for (int i = 0; i < recordArray.length; ++i) {
            Record record = recordArray[i];
            if (record.getRecordType() == 6001L) {
                System.out.println("Found PersistPtrFullBlock at " + n + " (" + Integer.toHexString(n) + ")");
            }
            if (record.getRecordType() == 6002L) {
                System.out.println("Found PersistPtrIncrementalBlock at " + n + " (" + Integer.toHexString(n) + ")");
                object = (PersistPtrHolder)record;
                int[] nArray = ((PersistPtrHolder)object).getKnownSlideIDs();
                Hashtable<Integer, Integer> hashtable = ((PersistPtrHolder)object).getSlideLocationsLookup();
                for (int j = 0; j < nArray.length; ++j) {
                    Integer n2 = nArray[j];
                    Integer n3 = (Integer)hashtable.get(n2);
                    System.out.println("  Knows about sheet " + n2);
                    System.out.println("    That sheet lives at " + n3);
                    Record record2 = SlideIdListing.findRecordAtPos(n3);
                    System.out.println("    The record at that pos is of type " + record2.getRecordType());
                    System.out.println("    The record at that pos has class " + record2.getClass().getName());
                    if (record2 instanceof PositionDependentRecord) continue;
                    System.out.println("    ** The record class isn't position aware! **");
                }
            }
            object = new ByteArrayOutputStream();
            record.writeOut((OutputStream)object);
            n += ((ByteArrayOutputStream)object).size();
        }
        System.out.println("");
    }

    public static Record findRecordAtPos(int n) {
        long l = LittleEndian.getUShort(fileContents, n + 2);
        long l2 = LittleEndian.getUInt(fileContents, n + 4);
        Record record = Record.createRecordForType(l, fileContents, n, (int)l2 + 8);
        return record;
    }
}

