/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.dev;

import ai2.org.apache.poi.hslf.record.Document;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.SlideListWithText;
import ai2.org.apache.poi.hslf.record.SlidePersistAtom;
import ai2.org.apache.poi.hslf.record.TextBytesAtom;
import ai2.org.apache.poi.hslf.record.TextCharsAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;

public final class SLWTTextListing {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShowImpl hSLFSlideShowImpl = new HSLFSlideShowImpl(stringArray[0]);
        Record[] recordArray = hSLFSlideShowImpl.getRecords();
        for (int i = 0; i < recordArray.length; ++i) {
            if (!(recordArray[i] instanceof Document)) continue;
            Record record = recordArray[i];
            Record[] recordArray2 = record.getChildRecords();
            for (int j = 0; j < recordArray2.length; ++j) {
                if (!(recordArray2[j] instanceof SlideListWithText)) continue;
                System.out.println("Found SLWT at pos " + j + " in the Document at " + i);
                System.out.println("  Has " + recordArray2[j].getChildRecords().length + " children");
                SlideListWithText slideListWithText = (SlideListWithText)recordArray2[j];
                SlideListWithText.SlideAtomsSet[] slideAtomsSetArray = slideListWithText.getSlideAtomsSets();
                System.out.println("  Has " + slideAtomsSetArray.length + " AtomSets in it");
                for (int k = 0; k < slideAtomsSetArray.length; ++k) {
                    SlidePersistAtom slidePersistAtom = slideAtomsSetArray[k].getSlidePersistAtom();
                    System.out.println("    " + k + " has slide id " + slidePersistAtom.getSlideIdentifier());
                    System.out.println("    " + k + " has ref id " + slidePersistAtom.getRefID());
                    Record[] recordArray3 = slideAtomsSetArray[k].getSlideRecords();
                    for (int i2 = 0; i2 < recordArray3.length; ++i2) {
                        RecordAtom recordAtom;
                        String string = null;
                        if (recordArray3[i2] instanceof TextBytesAtom) {
                            recordAtom = (TextBytesAtom)recordArray3[i2];
                            string = ((TextBytesAtom)recordAtom).getText();
                        }
                        if (recordArray3[i2] instanceof TextCharsAtom) {
                            recordAtom = (TextCharsAtom)recordArray3[i2];
                            string = ((TextCharsAtom)recordAtom).getText();
                        }
                        if (string == null) continue;
                        string = string.replace('\r', '\n');
                        System.out.println("        ''" + string + "''");
                    }
                }
            }
        }
    }
}

