/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.dev;

import ai2.org.apache.poi.hslf.record.Document;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.record.SlideListWithText;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;

public final class SLWTListing {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShowImpl hSLFSlideShowImpl = new HSLFSlideShowImpl(stringArray[0]);
        Record[] recordArray = hSLFSlideShowImpl.getRecords();
        for (int i = 0; i < recordArray.length; ++i) {
            if (!(recordArray[i] instanceof Document)) continue;
            Document document = (Document)recordArray[i];
            SlideListWithText[] slideListWithTextArray = document.getSlideListWithTexts();
            System.out.println("Document at " + i + " had " + slideListWithTextArray.length + " SlideListWithTexts");
            if (slideListWithTextArray.length == 0) {
                System.err.println("** Warning: Should have had at least 1! **");
            }
            if (slideListWithTextArray.length > 3) {
                System.err.println("** Warning: Shouldn't have more than 3!");
            }
            for (int j = 0; j < slideListWithTextArray.length; ++j) {
                SlideListWithText slideListWithText = slideListWithTextArray[j];
                Record[] recordArray2 = slideListWithText.getChildRecords();
                System.out.println(" - SLWT at " + j + " had " + recordArray2.length + " children:");
                int n = slideListWithText.getSlideAtomsSets().length;
                if (j == 1) {
                    if (n == 0) {
                        System.err.println("  ** 2nd SLWT didn't have any SlideAtomSets!");
                    } else {
                        System.out.println("  - Contains " + n + " SlideAtomSets");
                    }
                } else if (n > 0) {
                    System.err.println("  ** SLWT " + j + " had " + n + " SlideAtomSets! (expected 0)");
                }
                int n2 = 5;
                if (recordArray2.length < 5) {
                    n2 = recordArray2.length;
                }
                for (int k = 0; k < n2; ++k) {
                    Record record = recordArray2[k];
                    int n3 = (int)record.getRecordType();
                    String string = RecordTypes.recordName(n3);
                    System.out.println("   - " + n3 + " (" + string + ")");
                }
            }
        }
    }
}

