/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.dev;

import ai2.org.apache.poi.hslf.record.EscherTextboxWrapper;
import ai2.org.apache.poi.hslf.record.PPDrawing;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.TextBytesAtom;
import ai2.org.apache.poi.hslf.record.TextCharsAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;

public final class PPDrawingTextListing {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShowImpl hSLFSlideShowImpl = new HSLFSlideShowImpl(stringArray[0]);
        Record[] recordArray = hSLFSlideShowImpl.getRecords();
        for (int i = 0; i < recordArray.length; ++i) {
            Record[] recordArray2 = recordArray[i].getChildRecords();
            if (recordArray2 == null || recordArray2.length == 0) continue;
            for (int j = 0; j < recordArray2.length; ++j) {
                if (!(recordArray2[j] instanceof PPDrawing)) continue;
                System.out.println("Found PPDrawing at " + j + " in top level record " + i + " (" + recordArray[i].getRecordType() + ")");
                PPDrawing pPDrawing = (PPDrawing)recordArray2[j];
                EscherTextboxWrapper[] escherTextboxWrapperArray = pPDrawing.getTextboxWrappers();
                System.out.println("  Has " + escherTextboxWrapperArray.length + " textbox wrappers within");
                for (int k = 0; k < escherTextboxWrapperArray.length; ++k) {
                    EscherTextboxWrapper escherTextboxWrapper = escherTextboxWrapperArray[k];
                    System.out.println("    " + k + " has " + escherTextboxWrapper.getChildRecords().length + " PPT atoms within");
                    Record[] recordArray3 = escherTextboxWrapper.getChildRecords();
                    for (int i2 = 0; i2 < recordArray3.length; ++i2) {
                        RecordAtom recordAtom;
                        String string = null;
                        if (recordArray3[i2] instanceof TextBytesAtom) {
                            recordAtom = (TextBytesAtom)recordArray3[i2];
                            string = ((TextBytesAtom)recordAtom).getText();
                        }
                        if (recordArray3[i2] instanceof TextCharsAtom) {
                            recordAtom = (TextCharsAtom)recordArray3[i2];
                            string = ((TextCharsAtom)recordAtom).getText();
                        }
                        if (string == null) continue;
                        string = string.replace('\r', '\n');
                        System.out.println("        ''" + string + "''");
                    }
                }
            }
        }
    }
}

