/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.blip;

import ai2.org.apache.poi.hslf.usermodel.HSLFPictureData;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.Units;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public abstract class Metafile
extends HSLFPictureData {
    protected static byte[] compress(byte[] byArray, int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        deflaterOutputStream.write(byArray, n, n2);
        deflaterOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public Dimension getImageDimension() {
        int n = 16 * this.uidInstanceCount;
        Header header = new Header();
        header.read(this.getRawData(), n);
        return new Dimension((int)Math.round(Units.toPoints((long)header.size.getWidth())), (int)Math.round(Units.toPoints((long)header.size.getHeight())));
    }

    public static class Header {
        public int wmfsize;
        public Rectangle bounds;
        public Dimension size;
        public int zipsize;
        public int compression;
        public int filter = 254;

        public void read(byte[] byArray, int n) {
            int n2 = n;
            this.wmfsize = LittleEndian.getInt(byArray, n2);
            int n3 = LittleEndian.getInt(byArray, n2 += 4);
            int n4 = LittleEndian.getInt(byArray, n2 += 4);
            int n5 = LittleEndian.getInt(byArray, n2 += 4);
            int n6 = LittleEndian.getInt(byArray, n2 += 4);
            this.bounds = new Rectangle(n3, n4, n5 - n3, n6 - n4);
            int n7 = LittleEndian.getInt(byArray, n2 += 4);
            int n8 = LittleEndian.getInt(byArray, n2 += 4);
            this.size = new Dimension(n7, n8);
            this.zipsize = LittleEndian.getInt(byArray, n2 += 4);
            this.compression = LittleEndian.getUByte(byArray, n2 += 4);
            this.filter = LittleEndian.getUByte(byArray, ++n2);
            ++n2;
        }

        public void write(OutputStream outputStream) throws IOException {
            byte[] byArray = new byte[34];
            int n = 0;
            LittleEndian.putInt(byArray, n, this.wmfsize);
            LittleEndian.putInt(byArray, n += 4, this.bounds.x);
            LittleEndian.putInt(byArray, n += 4, this.bounds.y);
            LittleEndian.putInt(byArray, n += 4, this.bounds.x + this.bounds.width);
            LittleEndian.putInt(byArray, n += 4, this.bounds.y + this.bounds.height);
            LittleEndian.putInt(byArray, n += 4, this.size.width);
            LittleEndian.putInt(byArray, n += 4, this.size.height);
            LittleEndian.putInt(byArray, n += 4, this.zipsize);
            byArray[n += 4] = 0;
            byArray[++n] = (byte)this.filter;
            ++n;
            outputStream.write(byArray);
        }

        public int getSize() {
            return 34;
        }
    }
}

