/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.blip;

import ai2.org.apache.poi.hslf.blip.Metafile;
import ai2.org.apache.poi.hslf.exceptions.HSLFException;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.util.Units;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public final class EMF
extends Metafile {
    public byte[] getData() {
        try {
            int n;
            byte[] byArray = this.getRawData();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Metafile.Header header = new Metafile.Header();
            header.read(byArray, 16);
            ((InputStream)byteArrayInputStream).skip(header.getSize() + 16);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
            byte[] byArray2 = new byte[4096];
            while ((n = inflaterInputStream.read(byArray2)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            inflaterInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new HSLFException(iOException);
        }
    }

    public void setData(byte[] byArray) throws IOException {
        byte[] byArray2 = EMF.compress(byArray, 0, byArray.length);
        NativeHeader nativeHeader = new NativeHeader(byArray, 0);
        Metafile.Header header = new Metafile.Header();
        header.wmfsize = byArray.length;
        header.bounds = nativeHeader.deviceBounds;
        Dimension dimension = nativeHeader.getSize();
        header.size = new Dimension(Units.toEMU(dimension.getWidth()), Units.toEMU(dimension.getHeight()));
        header.zipsize = byArray2.length;
        byte[] byArray3 = EMF.getChecksum(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray3);
        if (this.uidInstanceCount == 2) {
            byteArrayOutputStream.write(byArray3);
        }
        header.write(byteArrayOutputStream);
        byteArrayOutputStream.write(byArray2);
        this.setRawData(byteArrayOutputStream.toByteArray());
    }

    public PictureData.PictureType getType() {
        return PictureData.PictureType.EMF;
    }

    public int getSignature() {
        return this.uidInstanceCount == 1 ? 15680 : 15696;
    }

    public void setSignature(int n) {
        switch (n) {
            case 15680: {
                this.uidInstanceCount = 1;
                break;
            }
            case 15696: {
                this.uidInstanceCount = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a valid instance/signature value for EMF");
            }
        }
    }

    public static class NativeHeader {
        private final Rectangle deviceBounds;
        private static final String EMF_SIGNATURE = " EMF";

        public NativeHeader(byte[] byArray, int n) {
            int n2 = (int)LittleEndian.getUInt(byArray, n);
            n += 4;
            if (n2 != 1) {
                throw new HSLFException("Invalid EMF picture");
            }
            int n3 = LittleEndian.getInt(byArray, n += 4);
            int n4 = LittleEndian.getInt(byArray, n += 4);
            int n5 = LittleEndian.getInt(byArray, n += 4);
            int n6 = LittleEndian.getInt(byArray, n += 4);
            n += 4;
            this.deviceBounds = new Rectangle(n3, n4, n5 - n3, n6 - n4);
            String string = new String(byArray, n += 16, EMF_SIGNATURE.length(), LocaleUtil.CHARSET_1252);
            if (!EMF_SIGNATURE.equals(string)) {
                throw new HSLFException("Invalid EMF picture");
            }
        }

        public Dimension getSize() {
            return this.deviceBounds.getSize();
        }
    }
}

