/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.blip;

import ai2.org.apache.poi.hslf.usermodel.HSLFPictureData;
import ai2.org.apache.poi.util.Units;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public abstract class Bitmap
extends HSLFPictureData {
    public byte[] getData() {
        byte[] byArray = this.getRawData();
        int n = 16 * this.uidInstanceCount + 1;
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public void setData(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < this.uidInstanceCount; ++i) {
            byte[] byArray2 = Bitmap.getChecksum(byArray);
            byteArrayOutputStream.write(byArray2);
        }
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(byArray);
        this.setRawData(byteArrayOutputStream.toByteArray());
    }

    public Dimension getImageDimension() {
        try {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(this.getData()));
            return new Dimension((int)Units.pixelToPoints(bufferedImage.getWidth()), (int)Units.pixelToPoints(bufferedImage.getHeight()));
        }
        catch (IOException iOException) {
            return new Dimension(200, 200);
        }
    }
}

