/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpsf.extractor;

import ai2.org.apache.poi.POIDocument;
import ai2.org.apache.poi.POIOLE2TextExtractor;
import ai2.org.apache.poi.POITextExtractor;
import ai2.org.apache.poi.hpsf.CustomProperties;
import ai2.org.apache.poi.hpsf.DocumentSummaryInformation;
import ai2.org.apache.poi.hpsf.HPSFPropertiesOnlyDocument;
import ai2.org.apache.poi.hpsf.MutablePropertySet;
import ai2.org.apache.poi.hpsf.Property;
import ai2.org.apache.poi.hpsf.SpecialPropertySet;
import ai2.org.apache.poi.hpsf.SummaryInformation;
import ai2.org.apache.poi.hpsf.wellknown.PropertyIDMap;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class HPSFPropertiesExtractor
extends POIOLE2TextExtractor {
    private Closeable toClose;

    public HPSFPropertiesExtractor(POIOLE2TextExtractor pOIOLE2TextExtractor) {
        super(pOIOLE2TextExtractor);
    }

    public HPSFPropertiesExtractor(POIDocument pOIDocument) {
        super(pOIDocument);
    }

    public HPSFPropertiesExtractor(POIFSFileSystem pOIFSFileSystem) {
        super(new HPSFPropertiesOnlyDocument(pOIFSFileSystem));
    }

    public HPSFPropertiesExtractor(NPOIFSFileSystem nPOIFSFileSystem) {
        super(new HPSFPropertiesOnlyDocument(nPOIFSFileSystem));
        this.toClose = nPOIFSFileSystem;
    }

    public String getDocumentSummaryInformationText() {
        CustomProperties customProperties;
        if (this.document == null) {
            return "";
        }
        DocumentSummaryInformation documentSummaryInformation = this.document.getDocumentSummaryInformation();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(HPSFPropertiesExtractor.getPropertiesText(documentSummaryInformation));
        CustomProperties customProperties2 = customProperties = documentSummaryInformation == null ? null : documentSummaryInformation.getCustomProperties();
        if (customProperties != null) {
            for (String string : customProperties.nameSet()) {
                String string2 = HelperPropertySet.getPropertyValueText(customProperties.get(string));
                stringBuffer.append(string + " = " + string2 + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String getSummaryInformationText() {
        if (this.document == null) {
            return "";
        }
        SummaryInformation summaryInformation = this.document.getSummaryInformation();
        return HPSFPropertiesExtractor.getPropertiesText(summaryInformation);
    }

    private static String getPropertiesText(SpecialPropertySet specialPropertySet) {
        if (specialPropertySet == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        PropertyIDMap propertyIDMap = specialPropertySet.getPropertySetIDMap();
        Property[] propertyArray = specialPropertySet.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            String string = Long.toString(propertyArray[i].getID());
            Object object = propertyIDMap.get(propertyArray[i].getID());
            if (object != null) {
                string = object.toString();
            }
            String string2 = HelperPropertySet.getPropertyValueText(propertyArray[i].getValue());
            stringBuffer.append(string + " = " + string2 + "\n");
        }
        return stringBuffer.toString();
    }

    public String getText() {
        return this.getSummaryInformationText() + this.getDocumentSummaryInformationText();
    }

    public POITextExtractor getMetadataTextExtractor() {
        throw new IllegalStateException("You already have the Metadata Text Extractor, not recursing!");
    }

    public void close() throws IOException {
        super.close();
        if (this.toClose != null) {
            this.toClose.close();
            this.toClose = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        for (String string : stringArray) {
            HPSFPropertiesExtractor hPSFPropertiesExtractor = new HPSFPropertiesExtractor(new NPOIFSFileSystem(new File(string)));
            try {
                System.out.println(hPSFPropertiesExtractor.getText());
            }
            finally {
                hPSFPropertiesExtractor.close();
            }
        }
    }

    private static abstract class HelperPropertySet
    extends SpecialPropertySet {
        public HelperPropertySet() {
            super((MutablePropertySet)null);
        }

        public static String getPropertyValueText(Object object) {
            if (object == null) {
                return "(not set)";
            }
            return SpecialPropertySet.getPropertyStringValue(object);
        }
    }
}

