/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpsf;

import ai2.org.apache.poi.hpsf.HPSFException;
import ai2.org.apache.poi.util.LittleEndian;

public final class Thumbnail {
    public static final int OFFSET_CFTAG = 4;
    public static final int OFFSET_CF = 8;
    public static final int OFFSET_WMFDATA = 20;
    public static final int CFTAG_WINDOWS = -1;
    public static final int CFTAG_MACINTOSH = -2;
    public static final int CFTAG_FMTID = -3;
    public static final int CFTAG_NODATA = 0;
    public static final int CF_METAFILEPICT = 3;
    public static final int CF_DIB = 8;
    public static final int CF_ENHMETAFILE = 14;
    public static final int CF_BITMAP = 2;
    private byte[] _thumbnailData = null;

    public Thumbnail() {
    }

    public Thumbnail(byte[] byArray) {
        this._thumbnailData = byArray;
    }

    public byte[] getThumbnail() {
        return this._thumbnailData;
    }

    public void setThumbnail(byte[] byArray) {
        this._thumbnailData = byArray;
    }

    public long getClipboardFormatTag() {
        long l = LittleEndian.getInt(this.getThumbnail(), 4);
        return l;
    }

    public long getClipboardFormat() throws HPSFException {
        if (this.getClipboardFormatTag() != -1L) {
            throw new HPSFException("Clipboard Format Tag of Thumbnail must be CFTAG_WINDOWS.");
        }
        return LittleEndian.getInt(this.getThumbnail(), 8);
    }

    public byte[] getThumbnailAsWMF() throws HPSFException {
        if (this.getClipboardFormatTag() != -1L) {
            throw new HPSFException("Clipboard Format Tag of Thumbnail must be CFTAG_WINDOWS.");
        }
        if (this.getClipboardFormat() != 3L) {
            throw new HPSFException("Clipboard Format of Thumbnail must be CF_METAFILEPICT.");
        }
        byte[] byArray = this.getThumbnail();
        int n = byArray.length - 20;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 20, byArray2, 0, n);
        return byArray2;
    }
}

