/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpsf;

import ai2.org.apache.poi.hpsf.DocumentSummaryInformation;
import ai2.org.apache.poi.hpsf.HPSFRuntimeException;
import ai2.org.apache.poi.hpsf.MarkUnsupportedException;
import ai2.org.apache.poi.hpsf.MutablePropertySet;
import ai2.org.apache.poi.hpsf.MutableSection;
import ai2.org.apache.poi.hpsf.NoPropertySetStreamException;
import ai2.org.apache.poi.hpsf.PropertySet;
import ai2.org.apache.poi.hpsf.SummaryInformation;
import ai2.org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import ai2.org.apache.poi.hpsf.wellknown.SectionIDMap;
import ai2.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class PropertySetFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertySet create(DirectoryEntry directoryEntry, String string) throws FileNotFoundException, NoPropertySetStreamException, IOException, UnsupportedEncodingException {
        InputStream inputStream = null;
        try {
            DocumentEntry documentEntry = (DocumentEntry)directoryEntry.getEntry(string);
            inputStream = new DocumentInputStream(documentEntry);
            try {
                PropertySet propertySet = PropertySetFactory.create(inputStream);
                return propertySet;
            }
            catch (MarkUnsupportedException markUnsupportedException) {
                PropertySet propertySet;
                block7: {
                    propertySet = null;
                    if (inputStream == null) break block7;
                    inputStream.close();
                }
                return propertySet;
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static PropertySet create(InputStream inputStream) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        PropertySet propertySet = new PropertySet(inputStream);
        try {
            if (propertySet.isSummaryInformation()) {
                return new SummaryInformation(propertySet);
            }
            if (propertySet.isDocumentSummaryInformation()) {
                return new DocumentSummaryInformation(propertySet);
            }
            return propertySet;
        }
        catch (UnexpectedPropertySetTypeException unexpectedPropertySetTypeException) {
            throw new IllegalStateException(unexpectedPropertySetTypeException);
        }
    }

    public static SummaryInformation newSummaryInformation() {
        MutablePropertySet mutablePropertySet = new MutablePropertySet();
        MutableSection mutableSection = (MutableSection)mutablePropertySet.getFirstSection();
        mutableSection.setFormatID(SectionIDMap.SUMMARY_INFORMATION_ID);
        try {
            return new SummaryInformation((PropertySet)mutablePropertySet);
        }
        catch (UnexpectedPropertySetTypeException unexpectedPropertySetTypeException) {
            throw new HPSFRuntimeException(unexpectedPropertySetTypeException);
        }
    }

    public static DocumentSummaryInformation newDocumentSummaryInformation() {
        MutablePropertySet mutablePropertySet = new MutablePropertySet();
        MutableSection mutableSection = (MutableSection)mutablePropertySet.getFirstSection();
        mutableSection.setFormatID(SectionIDMap.DOCUMENT_SUMMARY_INFORMATION_ID[0]);
        try {
            return new DocumentSummaryInformation((PropertySet)mutablePropertySet);
        }
        catch (UnexpectedPropertySetTypeException unexpectedPropertySetTypeException) {
            throw new HPSFRuntimeException(unexpectedPropertySetTypeException);
        }
    }
}

