/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpsf;

import ai2.org.apache.poi.hpsf.CustomProperties;
import ai2.org.apache.poi.hpsf.CustomProperty;
import ai2.org.apache.poi.hpsf.HPSFRuntimeException;
import ai2.org.apache.poi.hpsf.MutableSection;
import ai2.org.apache.poi.hpsf.Property;
import ai2.org.apache.poi.hpsf.PropertySet;
import ai2.org.apache.poi.hpsf.Section;
import ai2.org.apache.poi.hpsf.SpecialPropertySet;
import ai2.org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import ai2.org.apache.poi.hpsf.wellknown.PropertyIDMap;
import ai2.org.apache.poi.hpsf.wellknown.SectionIDMap;
import java.util.Map;

public class DocumentSummaryInformation
extends SpecialPropertySet {
    public static final String DEFAULT_STREAM_NAME = "\u0005DocumentSummaryInformation";

    public PropertyIDMap getPropertySetIDMap() {
        return PropertyIDMap.getDocumentSummaryInformationProperties();
    }

    public DocumentSummaryInformation(PropertySet propertySet) throws UnexpectedPropertySetTypeException {
        super(propertySet);
        if (!this.isDocumentSummaryInformation()) {
            throw new UnexpectedPropertySetTypeException("Not a " + this.getClass().getName());
        }
    }

    public String getCategory() {
        return this.getPropertyStringValue(2);
    }

    public void setCategory(String string) {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.setProperty(2, string);
    }

    public void removeCategory() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(2L);
    }

    public String getPresentationFormat() {
        return this.getPropertyStringValue(3);
    }

    public void setPresentationFormat(String string) {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.setProperty(3, string);
    }

    public void removePresentationFormat() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(3L);
    }

    public int getByteCount() {
        return this.getPropertyIntValue(4);
    }

    public void setByteCount(int n) {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.setProperty(4, n);
    }

    public void removeByteCount() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(4L);
    }

    public int getLineCount() {
        return this.getPropertyIntValue(5);
    }

    public void setLineCount(int n) {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.setProperty(5, n);
    }

    public void removeLineCount() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(5L);
    }

    public int getParCount() {
        return this.getPropertyIntValue(6);
    }

    public void setParCount(int n) {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.setProperty(6, n);
    }

    public void removeParCount() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(6L);
    }

    public int getSlideCount() {
        return this.getPropertyIntValue(7);
    }

    public void setSlideCount(int n) {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.setProperty(7, n);
    }

    public void removeSlideCount() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(7L);
    }

    public int getNoteCount() {
        return this.getPropertyIntValue(8);
    }

    public void setNoteCount(int n) {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.setProperty(8, n);
    }

    public void removeNoteCount() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(8L);
    }

    public int getHiddenCount() {
        return this.getPropertyIntValue(9);
    }

    public void setHiddenCount(int n) {
        MutableSection mutableSection = (MutableSection)this.getSections().get(0);
        mutableSection.setProperty(9, n);
    }

    public void removeHiddenCount() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(9L);
    }

    public int getMMClipCount() {
        return this.getPropertyIntValue(10);
    }

    public void setMMClipCount(int n) {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.setProperty(10, n);
    }

    public void removeMMClipCount() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(10L);
    }

    public boolean getScale() {
        return this.getPropertyBooleanValue(11);
    }

    public void setScale(boolean bl) {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.setProperty(11, bl);
    }

    public void removeScale() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(11L);
    }

    public byte[] getHeadingPair() {
        this.notYetImplemented("Reading byte arrays ");
        return (byte[])this.getProperty(12);
    }

    public void setHeadingPair(byte[] byArray) {
        this.notYetImplemented("Writing byte arrays ");
    }

    public void removeHeadingPair() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(12L);
    }

    public byte[] getDocparts() {
        this.notYetImplemented("Reading byte arrays");
        return (byte[])this.getProperty(13);
    }

    public void setDocparts(byte[] byArray) {
        this.notYetImplemented("Writing byte arrays");
    }

    public void removeDocparts() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(13L);
    }

    public String getManager() {
        return this.getPropertyStringValue(14);
    }

    public void setManager(String string) {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.setProperty(14, string);
    }

    public void removeManager() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(14L);
    }

    public String getCompany() {
        return this.getPropertyStringValue(15);
    }

    public void setCompany(String string) {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.setProperty(15, string);
    }

    public void removeCompany() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(15L);
    }

    public boolean getLinksDirty() {
        return this.getPropertyBooleanValue(16);
    }

    public void setLinksDirty(boolean bl) {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.setProperty(16, bl);
    }

    public void removeLinksDirty() {
        MutableSection mutableSection = (MutableSection)this.getFirstSection();
        mutableSection.removeProperty(16L);
    }

    public CustomProperties getCustomProperties() {
        CustomProperties customProperties = null;
        if (this.getSectionCount() >= 2) {
            customProperties = new CustomProperties();
            Section section = this.getSections().get(1);
            Map<Long, String> map = section.getDictionary();
            Property[] propertyArray = section.getProperties();
            int n = 0;
            for (int i = 0; i < propertyArray.length; ++i) {
                Property property = propertyArray[i];
                long l = property.getID();
                if (l == 0L || l == 1L) continue;
                ++n;
                CustomProperty customProperty = new CustomProperty(property, map.get(l));
                customProperties.put(customProperty.getName(), customProperty);
            }
            if (customProperties.size() != n) {
                customProperties.setPure(false);
            }
        }
        return customProperties;
    }

    public void setCustomProperties(CustomProperties customProperties) {
        this.ensureSection2();
        MutableSection mutableSection = (MutableSection)this.getSections().get(1);
        Map<Long, String> map = customProperties.getDictionary();
        mutableSection.clear();
        int n = customProperties.getCodepage();
        if (n < 0) {
            n = mutableSection.getCodepage();
        }
        if (n < 0) {
            n = 1200;
        }
        customProperties.setCodepage(n);
        mutableSection.setCodepage(n);
        mutableSection.setDictionary(map);
        for (Property property : customProperties.values()) {
            mutableSection.setProperty(property);
        }
    }

    private void ensureSection2() {
        if (this.getSectionCount() < 2) {
            MutableSection mutableSection = new MutableSection();
            mutableSection.setFormatID(SectionIDMap.DOCUMENT_SUMMARY_INFORMATION_ID[1]);
            this.addSection(mutableSection);
        }
    }

    public void removeCustomProperties() {
        if (this.getSectionCount() < 2) {
            throw new HPSFRuntimeException("Illegal internal format of Document SummaryInformation stream: second section is missing.");
        }
        this.getSections().remove(1);
    }

    private void notYetImplemented(String string) {
        throw new UnsupportedOperationException(string + " is not yet implemented.");
    }
}

