/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpsf;

import ai2.org.apache.poi.util.CodePageUtil;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

@Internal
class CodePageString {
    private static final POILogger logger = POILogFactory.getLogger(CodePageString.class);
    private byte[] _value;

    CodePageString(byte[] byArray, int n) {
        int n2 = n;
        int n3 = LittleEndian.getInt(byArray, n2);
        this._value = LittleEndian.getByteArray(byArray, n2 += 4, n3);
        if (n3 != 0 && this._value[n3 - 1] != 0) {
            logger.log(5, new Object[]{"CodePageString started at offset #" + n2 + " is not NULL-terminated"});
        }
    }

    CodePageString(String string, int n) throws UnsupportedEncodingException {
        this.setJavaValue(string, n);
    }

    String getJavaValue(int n) throws UnsupportedEncodingException {
        String string = n == -1 ? new String(this._value, StringUtil.UTF8) : CodePageUtil.getStringFromCodePage(this._value, n);
        int n2 = string.indexOf(0);
        if (n2 == -1) {
            logger.log(5, new Object[]{"String terminator (\\0) for CodePageString property value not found.Continue without trimming and hope for the best."});
            return string;
        }
        if (n2 != string.length() - 1) {
            logger.log(5, new Object[]{"String terminator (\\0) for CodePageString property value occured before the end of string. Trimming and hope for the best."});
        }
        return string.substring(0, n2);
    }

    int getSize() {
        return 4 + this._value.length;
    }

    void setJavaValue(String string, int n) throws UnsupportedEncodingException {
        String string2 = string + "\u0000";
        this._value = n == -1 ? string2.getBytes(StringUtil.UTF8) : CodePageUtil.getBytesInCodePage(string2, n);
    }

    int write(OutputStream outputStream) throws IOException {
        LittleEndian.putInt(this._value.length, outputStream);
        outputStream.write(this._value);
        return 4 + this._value.length;
    }
}

