/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpsf;

import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.StringUtil;

public class ClassID {
    public static final ClassID OLE10_PACKAGE = new ClassID("{0003000C-0000-0000-C000-000000000046}");
    public static final ClassID PPT_SHOW = new ClassID("{64818D10-4F9B-11CF-86EA-00AA00B929E8}");
    public static final ClassID XLS_WORKBOOK = new ClassID("{00020841-0000-0000-C000-000000000046}");
    public static final ClassID TXT_ONLY = new ClassID("{5e941d80-bf96-11cd-b579-08002b30bfeb}");
    public static final ClassID EXCEL97 = new ClassID("{00020820-0000-0000-C000-000000000046}");
    public static final ClassID EXCEL95 = new ClassID("{00020810-0000-0000-C000-000000000046}");
    public static final ClassID WORD97 = new ClassID("{00020906-0000-0000-C000-000000000046}");
    public static final ClassID WORD95 = new ClassID("{00020900-0000-0000-C000-000000000046}");
    public static final ClassID POWERPOINT97 = new ClassID("{64818D10-4F9B-11CF-86EA-00AA00B929E8}");
    public static final ClassID POWERPOINT95 = new ClassID("{EA7BAE70-FB3B-11CD-A903-00AA00510EA3}");
    public static final ClassID EQUATION30 = new ClassID("{0002CE02-0000-0000-C000-000000000046}");
    protected byte[] bytes;
    public static final int LENGTH = 16;

    public ClassID(byte[] byArray, int n) {
        this.read(byArray, n);
    }

    public ClassID() {
        this.bytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            this.bytes[i] = 0;
        }
    }

    public ClassID(String string) {
        this.bytes = new byte[16];
        String string2 = string.replaceAll("[{}-]", "");
        for (int i = 0; i < string2.length(); i += 2) {
            this.bytes[i / 2] = (byte)Integer.parseInt(string2.substring(i, i + 2), 16);
        }
    }

    public int length() {
        return 16;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] byArray) {
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = byArray[i];
        }
    }

    public byte[] read(byte[] byArray, int n) {
        this.bytes = new byte[16];
        this.bytes[0] = byArray[3 + n];
        this.bytes[1] = byArray[2 + n];
        this.bytes[2] = byArray[1 + n];
        this.bytes[3] = byArray[0 + n];
        this.bytes[4] = byArray[5 + n];
        this.bytes[5] = byArray[4 + n];
        this.bytes[6] = byArray[7 + n];
        this.bytes[7] = byArray[6 + n];
        for (int i = 8; i < 16; ++i) {
            this.bytes[i] = byArray[i + n];
        }
        return this.bytes;
    }

    public void write(byte[] byArray, int n) throws ArrayStoreException {
        if (byArray.length < 16) {
            throw new ArrayStoreException("Destination byte[] must have room for at least 16 bytes, but has a length of only " + byArray.length + ".");
        }
        byArray[0 + n] = this.bytes[3];
        byArray[1 + n] = this.bytes[2];
        byArray[2 + n] = this.bytes[1];
        byArray[3 + n] = this.bytes[0];
        byArray[4 + n] = this.bytes[5];
        byArray[5 + n] = this.bytes[4];
        byArray[6 + n] = this.bytes[7];
        byArray[7 + n] = this.bytes[6];
        for (int i = 8; i < 16; ++i) {
            byArray[i + n] = this.bytes[i];
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ClassID)) {
            return false;
        }
        ClassID classID = (ClassID)object;
        if (this.bytes.length != classID.bytes.length) {
            return false;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == classID.bytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return new String(this.bytes, StringUtil.UTF8).hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(38);
        stringBuffer.append('{');
        for (int i = 0; i < 16; ++i) {
            stringBuffer.append(HexDump.toHex(this.bytes[i]));
            if (i != 3 && i != 5 && i != 7 && i != 9) continue;
            stringBuffer.append('-');
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

