/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpsf;

import ai2.org.apache.poi.hpsf.IllegalPropertySetDataException;
import ai2.org.apache.poi.hpsf.TypedPropertyValue;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
class Array {
    private ArrayHeader _header;
    private TypedPropertyValue[] _values;

    Array() {
    }

    Array(byte[] byArray, int n) {
        this.read(byArray, n);
    }

    int read(byte[] byArray, int n) {
        int n2 = n;
        this._header = new ArrayHeader(byArray, n2);
        n2 += this._header.getSize();
        long l = this._header.getNumberOfScalarValues();
        if (l > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Sorry, but POI can't store array of properties with size of " + l + " in memory");
        }
        int n3 = (int)l;
        this._values = new TypedPropertyValue[n3];
        int n4 = this._header._type;
        if (n4 == 12) {
            for (int i = 0; i < n3; ++i) {
                TypedPropertyValue typedPropertyValue = new TypedPropertyValue();
                n2 += typedPropertyValue.read(byArray, n2);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                TypedPropertyValue typedPropertyValue = new TypedPropertyValue(n4, null);
                n2 += typedPropertyValue.readValuePadded(byArray, n2);
            }
        }
        return n2 - n;
    }

    static class ArrayHeader {
        private ArrayDimension[] _dimensions;
        private int _type;

        ArrayHeader(byte[] byArray, int n) {
            int n2 = n;
            this._type = LittleEndian.getInt(byArray, n2);
            long l = LittleEndian.getUInt(byArray, n2 += 4);
            n2 += 4;
            if (1L > l || l > 31L) {
                throw new IllegalPropertySetDataException("Array dimension number " + l + " is not in [1; 31] range");
            }
            int n3 = (int)l;
            this._dimensions = new ArrayDimension[n3];
            for (int i = 0; i < n3; ++i) {
                this._dimensions[i] = new ArrayDimension(byArray, n2);
                n2 += 8;
            }
        }

        long getNumberOfScalarValues() {
            long l = 1L;
            for (ArrayDimension arrayDimension : this._dimensions) {
                l *= arrayDimension._size;
            }
            return l;
        }

        int getSize() {
            return 8 + this._dimensions.length * 8;
        }

        int getType() {
            return this._type;
        }
    }

    static class ArrayDimension {
        static final int SIZE = 8;
        private int _indexOffset;
        private long _size;

        ArrayDimension(byte[] byArray, int n) {
            this._size = LittleEndian.getUInt(byArray, n);
            this._indexOffset = LittleEndian.getInt(byArray, n + 4);
        }
    }
}

