/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpbf.model.qcbits;

import ai2.org.apache.poi.hpbf.model.qcbits.QCBit;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.StringUtil;

public abstract class QCPLCBit
extends QCBit {
    protected int numberOfPLCs;
    protected int typeOfPLCS;
    protected int[] preData;
    protected long[] plcValA;
    protected long[] plcValB;

    private QCPLCBit(String string, String string2, byte[] byArray) {
        super(string, string2, byArray);
        this.numberOfPLCs = (int)LittleEndian.getUInt(byArray, 0);
        this.typeOfPLCS = (int)LittleEndian.getUInt(byArray, 4);
        this.plcValA = new long[this.numberOfPLCs];
        this.plcValB = new long[this.numberOfPLCs];
    }

    public int getNumberOfPLCs() {
        return this.numberOfPLCs;
    }

    public int getTypeOfPLCS() {
        return this.typeOfPLCS;
    }

    public int[] getPreData() {
        return this.preData;
    }

    public long[] getPlcValA() {
        return this.plcValA;
    }

    public long[] getPlcValB() {
        return this.plcValB;
    }

    public static QCPLCBit createQCPLCBit(String string, String string2, byte[] byArray) {
        int n = (int)LittleEndian.getUInt(byArray, 4);
        switch (n) {
            case 0: {
                return new Type0(string, string2, byArray);
            }
            case 4: {
                return new Type4(string, string2, byArray);
            }
            case 8: {
                return new Type8(string, string2, byArray);
            }
            case 12: {
                return new Type12(string, string2, byArray);
            }
        }
        throw new IllegalArgumentException("Sorry, I don't know how to deal with PLCs of type " + n);
    }

    public static class Type12
    extends QCPLCBit {
        private String[] hyperlinks;
        private static final int oneStartsAt = 76;
        private static final int twoStartsAt = 104;
        private static final int threePlusIncrement = 22;

        private Type12(String string, String string2, byte[] byArray) {
            super(string, string2, byArray);
            int n;
            int n2;
            this.hyperlinks = byArray.length == 52 ? new String[0] : new String[this.numberOfPLCs];
            this.preData = new int[1 + this.numberOfPLCs + 1];
            for (n2 = 0; n2 < this.preData.length; ++n2) {
                this.preData[n2] = (int)LittleEndian.getUInt(byArray, 8 + n2 * 4);
            }
            n2 = 12 + this.numberOfPLCs * 4 + 4;
            int n3 = 52;
            if (this.numberOfPLCs == 1 && this.hyperlinks.length == 1) {
                n3 = 76;
            } else if (this.numberOfPLCs >= 2) {
                n3 = 104 + (this.numberOfPLCs - 2) * 22;
            }
            this.plcValA = new long[(n3 - n2) / 2];
            this.plcValB = new long[0];
            for (n = 0; n < this.plcValA.length; ++n) {
                this.plcValA[n] = LittleEndian.getUShort(byArray, n2 + n * 2);
            }
            n2 = n3;
            for (n = 0; n < this.hyperlinks.length; ++n) {
                int n4 = LittleEndian.getUShort(byArray, n2);
                int n5 = LittleEndian.getUShort(byArray, n2 + 2);
                if (n5 == 0) {
                    this.hyperlinks[n] = "";
                    n2 += n4;
                    continue;
                }
                this.hyperlinks[n] = StringUtil.getFromUnicodeLE(byArray, n2 + 2, n4);
                n2 += 2 + 2 * n4;
            }
        }

        public int getNumberOfHyperlinks() {
            return this.hyperlinks.length;
        }

        public String getHyperlink(int n) {
            return this.hyperlinks[n];
        }

        public int getTextStartAt(int n) {
            return this.preData[1 + n];
        }

        public int getAllTextEndAt() {
            return this.preData[this.numberOfPLCs + 1];
        }
    }

    public static class Type8
    extends QCPLCBit {
        private Type8(String string, String string2, byte[] byArray) {
            super(string, string2, byArray);
            this.preData = new int[7];
            this.preData[0] = LittleEndian.getUShort(byArray, 8);
            this.preData[1] = LittleEndian.getUShort(byArray, 10);
            this.preData[2] = LittleEndian.getUShort(byArray, 12);
            this.preData[3] = LittleEndian.getUShort(byArray, 14);
            this.preData[4] = LittleEndian.getUShort(byArray, 16);
            this.preData[5] = LittleEndian.getUShort(byArray, 18);
            this.preData[6] = LittleEndian.getUShort(byArray, 20);
            for (int i = 0; i < this.numberOfPLCs; ++i) {
                this.plcValA[i] = LittleEndian.getUInt(byArray, 22 + 8 * i);
                this.plcValB[i] = LittleEndian.getUInt(byArray, 22 + 8 * i + 4);
            }
        }
    }

    public static class Type4
    extends QCPLCBit {
        private Type4(String string, String string2, byte[] byArray) {
            super(string, string2, byArray);
            this.preData = new int[4];
            this.preData[0] = LittleEndian.getUShort(byArray, 8);
            this.preData[1] = LittleEndian.getUShort(byArray, 10);
            this.preData[2] = LittleEndian.getUShort(byArray, 12);
            this.preData[3] = LittleEndian.getUShort(byArray, 14);
            for (int i = 0; i < this.numberOfPLCs; ++i) {
                this.plcValA[i] = LittleEndian.getUInt(byArray, 16 + 8 * i);
                this.plcValB[i] = LittleEndian.getUInt(byArray, 16 + 8 * i + 4);
            }
        }
    }

    public static class Type0
    extends QCPLCBit {
        private Type0(String string, String string2, byte[] byArray) {
            super(string, string2, byArray);
            this.preData = new int[4];
            this.preData[0] = LittleEndian.getUShort(byArray, 8);
            this.preData[1] = LittleEndian.getUShort(byArray, 10);
            this.preData[2] = LittleEndian.getUShort(byArray, 12);
            this.preData[3] = LittleEndian.getUShort(byArray, 14);
            for (int i = 0; i < this.numberOfPLCs; ++i) {
                this.plcValA[i] = LittleEndian.getUShort(byArray, 16 + 4 * i);
                this.plcValB[i] = LittleEndian.getUShort(byArray, 16 + 4 * i + 2);
            }
        }
    }
}

