/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpbf.dev;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class HPBFDumper {
    private NPOIFSFileSystem fs;

    public HPBFDumper(NPOIFSFileSystem nPOIFSFileSystem) {
        this.fs = nPOIFSFileSystem;
    }

    public HPBFDumper(InputStream inputStream) throws IOException {
        this(new NPOIFSFileSystem(inputStream));
    }

    private static byte[] getData(DirectoryNode directoryNode, String string) throws IOException {
        DocumentEntry documentEntry = (DocumentEntry)directoryNode.getEntry(string);
        byte[] byArray = new byte[documentEntry.getSize()];
        directoryNode.createDocumentInputStream(string).read(byArray);
        return byArray;
    }

    private String dumpBytes(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            String string;
            int n3 = i + n;
            int n4 = byArray[n3];
            if (n4 < 0) {
                n4 += 256;
            }
            if ((string = Integer.toHexString(n4)).length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Use:");
            System.err.println("  HPBFDumper <filename>");
            System.exit(1);
        }
        HPBFDumper hPBFDumper = new HPBFDumper(new NPOIFSFileSystem(new File(stringArray[0])));
        System.out.println("Dumping " + stringArray[0]);
        hPBFDumper.dumpContents();
        hPBFDumper.dumpEnvelope();
        hPBFDumper.dumpEscher();
        hPBFDumper.dump001CompObj(hPBFDumper.fs.getRoot());
        hPBFDumper.dumpQuill();
    }

    public void dumpEscher() throws IOException {
        DirectoryNode directoryNode = (DirectoryNode)this.fs.getRoot().getEntry("Escher");
        this.dumpEscherStm(directoryNode);
        this.dumpEscherDelayStm(directoryNode);
    }

    private void dumpEscherStream(byte[] byArray) {
        EscherRecord escherRecord;
        DefaultEscherRecordFactory defaultEscherRecordFactory = new DefaultEscherRecordFactory();
        for (int i = byArray.length; i > 0; i -= escherRecord.getRecordSize()) {
            escherRecord = defaultEscherRecordFactory.createRecord(byArray, 0);
            escherRecord.fillFields(byArray, 0, defaultEscherRecordFactory);
            System.out.println(escherRecord.toString());
        }
    }

    protected void dumpEscherStm(DirectoryNode directoryNode) throws IOException {
        byte[] byArray = HPBFDumper.getData(directoryNode, "EscherStm");
        System.out.println("");
        System.out.println("EscherStm - " + byArray.length + " bytes long:");
        if (byArray.length > 0) {
            this.dumpEscherStream(byArray);
        }
    }

    protected void dumpEscherDelayStm(DirectoryNode directoryNode) throws IOException {
        byte[] byArray = HPBFDumper.getData(directoryNode, "EscherDelayStm");
        System.out.println("");
        System.out.println("EscherDelayStm - " + byArray.length + " bytes long:");
        if (byArray.length > 0) {
            this.dumpEscherStream(byArray);
        }
    }

    public void dumpEnvelope() throws IOException {
        byte[] byArray = HPBFDumper.getData(this.fs.getRoot(), "Envelope");
        System.out.println("");
        System.out.println("Envelope - " + byArray.length + " bytes long:");
    }

    public void dumpContents() throws IOException {
        byte[] byArray = HPBFDumper.getData(this.fs.getRoot(), "Contents");
        System.out.println("");
        System.out.println("Contents - " + byArray.length + " bytes long:");
    }

    public void dumpCONTENTSraw(DirectoryNode directoryNode) throws IOException {
        int n;
        byte[] byArray = HPBFDumper.getData(directoryNode, "CONTENTS");
        System.out.println("");
        System.out.println("CONTENTS - " + byArray.length + " bytes long:");
        System.out.println(new String(byArray, 0, 8, LocaleUtil.CHARSET_1252) + this.dumpBytes(byArray, 8, 24));
        boolean bl = true;
        for (int i = 32; i < 512; i += 4 + n) {
            if (bl) {
                System.out.println(this.dumpBytes(byArray, i, 2));
                i += 2;
            }
            String string = new String(byArray, i, 4, LocaleUtil.CHARSET_1252);
            n = 8;
            if (bl) {
                n = 6;
            }
            System.out.println(string + " " + this.dumpBytes(byArray, i + 4, n));
            bl = !bl;
        }
        int n2 = -1;
        for (n = 512; n < byArray.length - 2 && n2 == -1; ++n) {
            if (byArray[n] != 0 || byArray[n + 1] != 0 || byArray[n + 2] != 0) continue;
            n2 = n;
        }
        if (n2 > 0) {
            n = (n2 - 512) / 2;
            System.out.println("");
            System.out.println(StringUtil.getFromUnicodeLE(byArray, 512, n));
        }
    }

    public void dumpCONTENTSguessed(DirectoryNode directoryNode) throws IOException {
        int n;
        byte[] byArray = HPBFDumper.getData(directoryNode, "CONTENTS");
        System.out.println("");
        System.out.println("CONTENTS - " + byArray.length + " bytes long:");
        String[] stringArray = new String[20];
        String[] stringArray2 = new String[20];
        int[] nArray = new int[20];
        int[] nArray2 = new int[20];
        int[] nArray3 = new int[20];
        int[] nArray4 = new int[20];
        int[] nArray5 = new int[20];
        for (int i = 0; i < 20; ++i) {
            n = 32 + i * 24;
            if (byArray[n] != 24 || byArray[n + 1] != 0) continue;
            stringArray[i] = new String(byArray, n + 2, 4, LocaleUtil.CHARSET_1252);
            nArray[i] = LittleEndian.getUShort(byArray, n + 6);
            nArray2[i] = LittleEndian.getUShort(byArray, n + 8);
            nArray3[i] = LittleEndian.getUShort(byArray, n + 10);
            stringArray2[i] = new String(byArray, n + 12, 4, LocaleUtil.CHARSET_1252);
            nArray4[i] = (int)LittleEndian.getUInt(byArray, n + 16);
            nArray5[i] = (int)LittleEndian.getUInt(byArray, n + 20);
        }
        String string = StringUtil.getFromUnicodeLE(byArray, nArray4[0], nArray5[0] / 2);
        for (n = 0; n < 20; ++n) {
            String string2 = Integer.toString(n);
            if (n < 10) {
                string2 = "0" + n;
            }
            System.out.print(string2 + " ");
            if (stringArray[n] == null) {
                System.out.println("(not present)");
                continue;
            }
            System.out.println("\t" + stringArray[n] + " " + nArray[n] + " " + nArray2[n] + " " + nArray3[n]);
            System.out.println("\t" + stringArray2[n] + " " + "from: " + Integer.toHexString(nArray4[n]) + " (" + nArray4[n] + ")" + ", len: " + Integer.toHexString(nArray5[n]) + " (" + nArray5[n] + ")");
        }
        System.out.println("");
        System.out.println("TEXT:");
        System.out.println(string);
        System.out.println("");
        for (n = 0; n < 20; ++n) {
            if (stringArray[n] == null) continue;
            int n2 = nArray4[n];
            System.out.println(stringArray[n] + " -> " + stringArray2[n] + " @ " + Integer.toHexString(n2) + " (" + n2 + ")");
            System.out.println("\t" + this.dumpBytes(byArray, n2, 4));
            System.out.println("\t" + this.dumpBytes(byArray, n2 + 4, 4));
            System.out.println("\t" + this.dumpBytes(byArray, n2 + 8, 4));
            System.out.println("\t(etc)");
        }
    }

    protected void dump001CompObj(DirectoryNode directoryNode) {
    }

    public void dumpQuill() throws IOException {
        DirectoryNode directoryNode = (DirectoryNode)this.fs.getRoot().getEntry("Quill");
        DirectoryNode directoryNode2 = (DirectoryNode)directoryNode.getEntry("QuillSub");
        this.dump001CompObj(directoryNode2);
        this.dumpCONTENTSraw(directoryNode2);
        this.dumpCONTENTSguessed(directoryNode2);
    }
}

