/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hpbf;

import ai2.org.apache.poi.POIDocument;
import ai2.org.apache.poi.hpbf.model.EscherDelayStm;
import ai2.org.apache.poi.hpbf.model.EscherStm;
import ai2.org.apache.poi.hpbf.model.MainContents;
import ai2.org.apache.poi.hpbf.model.QuillContents;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class HPBFDocument
extends POIDocument {
    private MainContents mainContents;
    private QuillContents quillContents;
    private EscherStm escherStm;
    private EscherDelayStm escherDelayStm;

    public HPBFDocument(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    public HPBFDocument(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this(nPOIFSFileSystem.getRoot());
    }

    public HPBFDocument(InputStream inputStream) throws IOException {
        this(new NPOIFSFileSystem(inputStream));
    }

    public HPBFDocument(DirectoryNode directoryNode) throws IOException {
        super(directoryNode);
        this.mainContents = new MainContents(directoryNode);
        this.quillContents = new QuillContents(directoryNode);
        this.escherStm = new EscherStm(directoryNode);
        this.escherDelayStm = new EscherDelayStm(directoryNode);
    }

    public MainContents getMainContents() {
        return this.mainContents;
    }

    public QuillContents getQuillContents() {
        return this.quillContents;
    }

    public EscherStm getEscherStm() {
        return this.escherStm;
    }

    public EscherDelayStm getEscherDelayStm() {
        return this.escherDelayStm;
    }

    public void write(OutputStream outputStream) throws IOException {
        throw new IllegalStateException("Writing is not yet implemented, see http://poi.apache.org/hpbf/");
    }
}

