/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hmef.extractor;

import ai2.org.apache.poi.hmef.Attachment;
import ai2.org.apache.poi.hmef.HMEFMessage;
import ai2.org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class HMEFContentsExtractor {
    private HMEFMessage message;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Use:");
            System.err.println("  HMEFContentsExtractor <filename> <output dir>");
            System.err.println("");
            System.err.println("");
            System.err.println("Where <filename> is the winmail.dat file to extract,");
            System.err.println(" and <output dir> is where to place the extracted files");
            System.exit(2);
        }
        HMEFContentsExtractor hMEFContentsExtractor = new HMEFContentsExtractor(new File(stringArray[0]));
        File file = new File(stringArray[1]);
        File file2 = new File(file, "message.rtf");
        if (!file.exists()) {
            throw new FileNotFoundException("Output directory " + file.getName() + " not found");
        }
        System.out.println("Extracting...");
        hMEFContentsExtractor.extractMessageBody(file2);
        hMEFContentsExtractor.extractAttachments(file);
        System.out.println("Extraction completed");
    }

    public HMEFContentsExtractor(File file) throws IOException {
        this(new HMEFMessage(new FileInputStream(file)));
    }

    public HMEFContentsExtractor(HMEFMessage hMEFMessage) {
        this.message = hMEFMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractMessageBody(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            MAPIRtfAttribute mAPIRtfAttribute = (MAPIRtfAttribute)this.message.getMessageMAPIAttribute(MAPIProperty.RTF_COMPRESSED);
            ((OutputStream)fileOutputStream).write(mAPIRtfAttribute.getData());
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractAttachments(File file) throws IOException {
        int n = 0;
        for (Attachment attachment : this.message.getAttachments()) {
            ++n;
            String string = attachment.getLongFilename();
            if (string == null || string.length() == 0) {
                string = attachment.getFilename();
            }
            if (string == null || string.length() == 0) {
                string = "attachment" + n;
                if (attachment.getExtension() != null) {
                    string = string + attachment.getExtension();
                }
            }
            File file2 = new File(file, string);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                ((OutputStream)fileOutputStream).write(attachment.getContents());
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
    }
}

