/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hmef.attribute;

import ai2.org.apache.poi.hmef.attribute.TNEFAttribute;
import ai2.org.apache.poi.hpsf.Util;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;

public final class TNEFDateAttribute
extends TNEFAttribute {
    private static POILogger logger = POILogFactory.getLogger(TNEFDateAttribute.class);
    private Date data;

    protected TNEFDateAttribute(int n, int n2, InputStream inputStream) throws IOException {
        super(n, n2, inputStream);
        byte[] byArray = this.getData();
        if (byArray.length == 8) {
            this.data = Util.filetimeToDate(LittleEndian.getLong(this.getData(), 0));
        } else if (byArray.length == 14) {
            Calendar calendar = LocaleUtil.getLocaleCalendar(LocaleUtil.TIMEZONE_UTC);
            calendar.set(1, LittleEndian.getUShort(byArray, 0));
            calendar.set(2, LittleEndian.getUShort(byArray, 2) - 1);
            calendar.set(5, LittleEndian.getUShort(byArray, 4));
            calendar.set(11, LittleEndian.getUShort(byArray, 6));
            calendar.set(12, LittleEndian.getUShort(byArray, 8));
            calendar.set(13, LittleEndian.getUShort(byArray, 10));
            calendar.clear(14);
            this.data = calendar.getTime();
        } else {
            throw new IllegalArgumentException("Invalid date, found " + byArray.length + " bytes");
        }
    }

    public Date getDate() {
        return this.data;
    }

    public String toString() {
        return "Attribute " + this.getProperty().toString() + ", type=" + this.getType() + ", date=" + this.data.toString();
    }

    public static Date getAsDate(TNEFAttribute tNEFAttribute) {
        if (tNEFAttribute == null) {
            return null;
        }
        if (tNEFAttribute instanceof TNEFDateAttribute) {
            return ((TNEFDateAttribute)tNEFAttribute).getDate();
        }
        logger.log(5, new Object[]{"Warning, non date property found: " + tNEFAttribute.toString()});
        return null;
    }
}

