/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hmef.attribute;

import ai2.org.apache.poi.hmef.attribute.TNEFDateAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFMAPIAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFProperty;
import ai2.org.apache.poi.hmef.attribute.TNEFStringAttribute;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.InputStream;

public class TNEFAttribute {
    private final TNEFProperty property;
    private final int type;
    private final byte[] data;
    private final int checksum;

    protected TNEFAttribute(int n, int n2, InputStream inputStream) throws IOException {
        this.type = n2;
        int n3 = LittleEndian.readInt(inputStream);
        this.property = TNEFProperty.getBest(n, n2);
        this.data = new byte[n3];
        IOUtils.readFully(inputStream, this.data);
        this.checksum = LittleEndian.readUShort(inputStream);
    }

    public static TNEFAttribute create(InputStream inputStream) throws IOException {
        int n = LittleEndian.readUShort(inputStream);
        int n2 = LittleEndian.readUShort(inputStream);
        if (n == TNEFProperty.ID_MAPIPROPERTIES.id || n == TNEFProperty.ID_ATTACHMENT.id) {
            return new TNEFMAPIAttribute(n, n2, inputStream);
        }
        if (n2 == 1 || n2 == 2) {
            return new TNEFStringAttribute(n, n2, inputStream);
        }
        if (n2 == 3) {
            return new TNEFDateAttribute(n, n2, inputStream);
        }
        return new TNEFAttribute(n, n2, inputStream);
    }

    public TNEFProperty getProperty() {
        return this.property;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return "Attribute " + this.property.toString() + ", type=" + this.type + ", data length=" + this.data.length;
    }
}

