/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hmef.attribute;

import ai2.org.apache.poi.hmef.CompressedRTF;
import ai2.org.apache.poi.hmef.attribute.MAPIAttribute;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import ai2.org.apache.poi.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public final class MAPIRtfAttribute
extends MAPIAttribute {
    private final byte[] decompressed;
    private final String data;

    public MAPIRtfAttribute(MAPIProperty mAPIProperty, int n, byte[] byArray) throws IOException {
        super(mAPIProperty, n, byArray);
        CompressedRTF compressedRTF = new CompressedRTF();
        byte[] byArray2 = compressedRTF.decompress(new ByteArrayInputStream(byArray));
        if (byArray2.length > compressedRTF.getDeCompressedSize()) {
            this.decompressed = new byte[compressedRTF.getDeCompressedSize()];
            System.arraycopy(byArray2, 0, this.decompressed, 0, this.decompressed.length);
        } else {
            this.decompressed = byArray2;
        }
        this.data = StringUtil.getFromCompressedUnicode(this.decompressed, 0, this.decompressed.length);
    }

    public byte[] getRawData() {
        return super.getData();
    }

    public byte[] getData() {
        return this.decompressed;
    }

    public String getDataString() {
        return this.data;
    }

    public String toString() {
        return this.getProperty().toString() + " " + this.data;
    }
}

