/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hmef.attribute;

import ai2.org.apache.poi.hmef.attribute.MAPIAttribute;
import ai2.org.apache.poi.hpsf.Util;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.Date;

public final class MAPIDateAttribute
extends MAPIAttribute {
    private static POILogger logger = POILogFactory.getLogger(MAPIDateAttribute.class);
    private Date data;

    protected MAPIDateAttribute(MAPIProperty mAPIProperty, int n, byte[] byArray) {
        super(mAPIProperty, n, byArray);
        this.data = Util.filetimeToDate(LittleEndian.getLong(byArray, 0));
    }

    public Date getDate() {
        return this.data;
    }

    public String toString() {
        return this.getProperty().toString() + " " + this.data.toString();
    }

    public static Date getAsDate(MAPIAttribute mAPIAttribute) {
        if (mAPIAttribute == null) {
            return null;
        }
        if (mAPIAttribute instanceof MAPIDateAttribute) {
            return ((MAPIDateAttribute)mAPIAttribute).getDate();
        }
        logger.log(5, new Object[]{"Warning, non date property found: " + mAPIAttribute.toString()});
        return null;
    }
}

