/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hmef.attribute;

import ai2.org.apache.poi.hmef.attribute.MAPIDateAttribute;
import ai2.org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import ai2.org.apache.poi.hmef.attribute.MAPIStringAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFProperty;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import ai2.org.apache.poi.hsmf.datatypes.Types;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAPIAttribute {
    private final MAPIProperty property;
    private final int type;
    private final byte[] data;

    public MAPIAttribute(MAPIProperty mAPIProperty, int n, byte[] byArray) {
        this.property = mAPIProperty;
        this.type = n;
        this.data = byArray;
    }

    public MAPIProperty getProperty() {
        return this.property;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        String string;
        if (this.data.length <= 16) {
            string = HexDump.toHex(this.data);
        } else {
            byte[] byArray = new byte[16];
            System.arraycopy(this.data, 0, byArray, 0, 16);
            string = HexDump.toHex(byArray);
            string = string.substring(0, string.length() - 1) + ", ....]";
        }
        return this.property.toString() + " " + string;
    }

    public static List<MAPIAttribute> create(TNEFAttribute tNEFAttribute) throws IOException {
        if (tNEFAttribute.getProperty() != TNEFProperty.ID_MAPIPROPERTIES && tNEFAttribute.getProperty() != TNEFProperty.ID_ATTACHMENT) {
            throw new IllegalArgumentException("Can only create from a MAPIProperty attribute, instead received a " + tNEFAttribute.getProperty() + " one");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(tNEFAttribute.getData());
        int n = LittleEndian.readInt(byteArrayInputStream);
        ArrayList<MAPIAttribute> arrayList = new ArrayList<MAPIAttribute>();
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2;
            Types.MAPIType mAPIType;
            int n3 = LittleEndian.readUShort(byteArrayInputStream);
            int n4 = LittleEndian.readUShort(byteArrayInputStream);
            boolean bl = false;
            boolean bl2 = false;
            int n5 = n3;
            if ((n3 & 0x1000) > 0) {
                bl = true;
                n5 -= 4096;
            }
            if (n5 == Types.ASCII_STRING.getId() || n5 == Types.UNICODE_STRING.getId() || n5 == Types.BINARY.getId() || n5 == Types.DIRECTORY.getId()) {
                bl2 = true;
            }
            if ((mAPIType = Types.getById(n5)) == null) {
                mAPIType = Types.createCustom(n5);
            }
            MAPIProperty mAPIProperty = MAPIProperty.get(n4);
            if (n4 >= 32768 && n4 <= 65535) {
                String string;
                int n6;
                byte[] byArray = new byte[16];
                IOUtils.readFully(byteArrayInputStream, byArray);
                n2 = LittleEndian.readInt(byteArrayInputStream);
                if (n2 == 0) {
                    n6 = LittleEndian.readInt(byteArrayInputStream);
                    object = MAPIProperty.get(n6);
                    string = ((MAPIProperty)object).name;
                } else {
                    n6 = LittleEndian.readInt(byteArrayInputStream);
                    object = new byte[n6];
                    IOUtils.readFully(byteArrayInputStream, (byte[])object);
                    string = StringUtil.getFromUnicodeLE((byte[])object, 0, n6 / 2 - 1);
                    MAPIAttribute.skipToBoundary(n6, byteArrayInputStream);
                }
                mAPIProperty = MAPIProperty.createCustom(n4, mAPIType, string);
            }
            if (mAPIProperty == MAPIProperty.UNKNOWN) {
                mAPIProperty = MAPIProperty.createCustom(n4, mAPIType, "(unknown " + Integer.toHexString(n4) + ")");
            }
            int n7 = 1;
            if (bl || bl2) {
                n7 = LittleEndian.readInt(byteArrayInputStream);
            }
            for (n2 = 0; n2 < n7; ++n2) {
                int n8 = MAPIAttribute.getLength(mAPIType, byteArrayInputStream);
                byte[] byArray = new byte[n8];
                IOUtils.readFully(byteArrayInputStream, byArray);
                MAPIAttribute.skipToBoundary(n8, byteArrayInputStream);
                object = mAPIType == Types.UNICODE_STRING || mAPIType == Types.ASCII_STRING ? new MAPIStringAttribute(mAPIProperty, n5, byArray) : (mAPIType == Types.APP_TIME || mAPIType == Types.TIME ? new MAPIDateAttribute(mAPIProperty, n5, byArray) : (n4 == MAPIProperty.RTF_COMPRESSED.id ? new MAPIRtfAttribute(mAPIProperty, n5, byArray) : new MAPIAttribute(mAPIProperty, n5, byArray)));
                arrayList.add((MAPIAttribute)object);
            }
        }
        return arrayList;
    }

    private static int getLength(Types.MAPIType mAPIType, InputStream inputStream) throws IOException {
        if (mAPIType.isFixedLength()) {
            return mAPIType.getLength();
        }
        if (mAPIType == Types.ASCII_STRING || mAPIType == Types.UNICODE_STRING || mAPIType == Types.DIRECTORY || mAPIType == Types.BINARY) {
            return LittleEndian.readInt(inputStream);
        }
        throw new IllegalArgumentException("Unknown type " + mAPIType);
    }

    private static void skipToBoundary(int n, InputStream inputStream) throws IOException {
        if (n % 4 != 0) {
            int n2 = 4 - n % 4;
            byte[] byArray = new byte[n2];
            IOUtils.readFully(inputStream, byArray);
        }
    }
}

