/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hmef;

import ai2.org.apache.poi.hmef.Attachment;
import ai2.org.apache.poi.hmef.attribute.MAPIAttribute;
import ai2.org.apache.poi.hmef.attribute.MAPIStringAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFMAPIAttribute;
import ai2.org.apache.poi.hmef.attribute.TNEFProperty;
import ai2.org.apache.poi.hsmf.datatypes.MAPIProperty;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HMEFMessage {
    public static final int HEADER_SIGNATURE = 574529400;
    private int fileId;
    private List<TNEFAttribute> messageAttributes = new ArrayList<TNEFAttribute>();
    private List<MAPIAttribute> mapiAttributes = new ArrayList<MAPIAttribute>();
    private List<Attachment> attachments = new ArrayList<Attachment>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HMEFMessage(InputStream inputStream) throws IOException {
        try {
            int n = LittleEndian.readInt(inputStream);
            if (n != 574529400) {
                throw new IllegalArgumentException("TNEF signature not detected in file, expected 574529400 but got " + n);
            }
            this.fileId = LittleEndian.readUShort(inputStream);
            this.process(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    private void process(InputStream inputStream) throws IOException {
        int n;
        do {
            n = inputStream.read();
            switch (n) {
                case 1: {
                    this.processMessage(inputStream);
                    break;
                }
                case 2: {
                    this.processAttachment(inputStream);
                    break;
                }
                case -1: 
                case 10: 
                case 13: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled level " + n);
                }
            }
        } while (n != -1);
    }

    void processMessage(InputStream inputStream) throws IOException {
        TNEFAttribute tNEFAttribute = TNEFAttribute.create(inputStream);
        this.messageAttributes.add(tNEFAttribute);
        if (tNEFAttribute instanceof TNEFMAPIAttribute) {
            TNEFMAPIAttribute tNEFMAPIAttribute = (TNEFMAPIAttribute)tNEFAttribute;
            this.mapiAttributes.addAll(tNEFMAPIAttribute.getMAPIAttributes());
        }
    }

    void processAttachment(InputStream inputStream) throws IOException {
        TNEFAttribute tNEFAttribute = TNEFAttribute.create(inputStream);
        if (this.attachments.isEmpty() || tNEFAttribute.getProperty() == TNEFProperty.ID_ATTACHRENDERDATA) {
            this.attachments.add(new Attachment());
        }
        Attachment attachment = this.attachments.get(this.attachments.size() - 1);
        attachment.addAttribute(tNEFAttribute);
    }

    public List<TNEFAttribute> getMessageAttributes() {
        return this.messageAttributes;
    }

    public List<MAPIAttribute> getMessageMAPIAttributes() {
        return this.mapiAttributes;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public TNEFAttribute getMessageAttribute(TNEFProperty tNEFProperty) {
        for (TNEFAttribute tNEFAttribute : this.messageAttributes) {
            if (tNEFAttribute.getProperty() != tNEFProperty) continue;
            return tNEFAttribute;
        }
        return null;
    }

    public MAPIAttribute getMessageMAPIAttribute(MAPIProperty mAPIProperty) {
        for (MAPIAttribute mAPIAttribute : this.mapiAttributes) {
            if (mAPIAttribute.getProperty() != mAPIProperty) continue;
            return mAPIAttribute;
        }
        return null;
    }

    private String getString(MAPIProperty mAPIProperty) {
        return MAPIStringAttribute.getAsString(this.getMessageMAPIAttribute(mAPIProperty));
    }

    public String getSubject() {
        return this.getString(MAPIProperty.CONVERSATION_TOPIC);
    }

    public String getBody() {
        return this.getString(MAPIProperty.RTF_COMPRESSED);
    }
}

