/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hmef;

import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.LZWDecompresser;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public final class CompressedRTF
extends LZWDecompresser {
    public static final byte[] COMPRESSED_SIGNATURE = new byte[]{76, 90, 70, 117};
    public static final byte[] UNCOMPRESSED_SIGNATURE = new byte[]{77, 69, 76, 65};
    public static final int COMPRESSED_SIGNATURE_INT = LittleEndian.getInt(COMPRESSED_SIGNATURE);
    public static final int UNCOMPRESSED_SIGNATURE_INT = LittleEndian.getInt(UNCOMPRESSED_SIGNATURE);
    public static final String LZW_RTF_PRELOAD = "{\\rtf1\\ansi\\mac\\deff0\\deftab720{\\fonttbl;}{\\f0\\fnil \\froman \\fswiss \\fmodern \\fscript \\fdecor MS Sans SerifSymbolArialTimes New RomanCourier{\\colortbl\\red0\\green0\\blue0\n\r\\par \\pard\\plain\\f0\\fs20\\b\\i\\u\\tab\\tx";
    private int compressedSize;
    private int decompressedSize;

    public CompressedRTF() {
        super(true, 2, true);
    }

    public void decompress(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.compressedSize = LittleEndian.readInt(inputStream);
        this.decompressedSize = LittleEndian.readInt(inputStream);
        int n = LittleEndian.readInt(inputStream);
        LittleEndian.readInt(inputStream);
        if (n == UNCOMPRESSED_SIGNATURE_INT) {
            IOUtils.copy(inputStream, outputStream);
        } else if (n != COMPRESSED_SIGNATURE_INT) {
            throw new IllegalArgumentException("Invalid compression signature " + n);
        }
        super.decompress(inputStream, outputStream);
    }

    public int getCompressedSize() {
        return this.compressedSize - 12;
    }

    public int getDeCompressedSize() {
        return this.decompressedSize;
    }

    protected int adjustDictionaryOffset(int n) {
        return n;
    }

    protected int populateDictionary(byte[] byArray) {
        byte[] byArray2 = LZW_RTF_PRELOAD.getBytes(Charset.forName("US-ASCII"));
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        return byArray2.length;
    }
}

