/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdgf.streams;

import ai2.org.apache.poi.hdgf.HDGFLZW;
import ai2.org.apache.poi.hdgf.streams.StreamStore;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public final class CompressedStreamStore
extends StreamStore {
    private byte[] compressedContents;
    private byte[] blockHeader = new byte[4];
    private boolean blockHeaderInContents = false;

    protected byte[] _getCompressedContents() {
        return this.compressedContents;
    }

    protected byte[] _getBlockHeader() {
        return this.blockHeader;
    }

    protected CompressedStreamStore(byte[] byArray, int n, int n2) throws IOException {
        this(CompressedStreamStore.decompress(byArray, n, n2));
        this.compressedContents = new byte[n2];
        System.arraycopy(byArray, n, this.compressedContents, 0, n2);
    }

    private CompressedStreamStore(byte[][] byArray) {
        super(byArray[1], 0, byArray[1].length);
        this.blockHeader = byArray[0];
    }

    protected void copyBlockHeaderToContents() {
        if (this.blockHeaderInContents) {
            return;
        }
        this.prependContentsWith(this.blockHeader);
        this.blockHeaderInContents = true;
    }

    public static byte[][] decompress(byte[] byArray, int n, int n2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        HDGFLZW hDGFLZW = new HDGFLZW();
        byte[] byArray2 = hDGFLZW.decompress(byteArrayInputStream);
        byte[][] byArrayArray = new byte[][]{new byte[4], new byte[byArray2.length - 4]};
        System.arraycopy(byArray2, 0, byArrayArray[0], 0, 4);
        System.arraycopy(byArray2, 4, byArrayArray[1], 0, byArrayArray[1].length);
        return byArrayArray;
    }
}

