/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdgf.streams;

import ai2.org.apache.poi.hdgf.chunks.Chunk;
import ai2.org.apache.poi.hdgf.chunks.ChunkFactory;
import ai2.org.apache.poi.hdgf.chunks.ChunkHeader;
import ai2.org.apache.poi.hdgf.pointers.Pointer;
import ai2.org.apache.poi.hdgf.streams.Stream;
import ai2.org.apache.poi.hdgf.streams.StreamStore;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.ArrayList;

public final class ChunkStream
extends Stream {
    private static POILogger logger = POILogFactory.getLogger(ChunkStream.class);
    private ChunkFactory chunkFactory;
    private Chunk[] chunks;

    protected ChunkStream(Pointer pointer, StreamStore streamStore, ChunkFactory chunkFactory) {
        super(pointer, streamStore);
        this.chunkFactory = chunkFactory;
        streamStore.copyBlockHeaderToContents();
    }

    public Chunk[] getChunks() {
        return this.chunks;
    }

    public void findChunks() {
        int n;
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        if (this.getPointer().getOffset() == 25779) {
            n = 0;
            ++n;
        }
        n = 0;
        byte[] byArray = this.getStore().getContents();
        try {
            while (n < byArray.length) {
                int n2 = ChunkHeader.getHeaderSize(this.chunkFactory.getVersion());
                if (n + n2 <= byArray.length) {
                    Chunk chunk = this.chunkFactory.createChunk(byArray, n);
                    arrayList.add(chunk);
                    n += chunk.getOnDiskSize();
                    continue;
                }
                logger.log(5, new Object[]{"Needed " + n2 + " bytes to create the next chunk header, but only found " + (byArray.length - n) + " bytes, ignoring rest of data"});
                n = byArray.length;
            }
        }
        catch (Exception exception) {
            logger.log(7, new Object[]{"Failed to create chunk at " + n + ", ignoring rest of data." + exception});
        }
        this.chunks = arrayList.toArray(new Chunk[arrayList.size()]);
    }
}

