/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdgf.pointers;

import ai2.org.apache.poi.hdgf.pointers.Pointer;
import ai2.org.apache.poi.hdgf.pointers.PointerV6;
import ai2.org.apache.poi.util.LittleEndian;

public final class PointerFactory {
    private int version;

    public PointerFactory(int n) {
        this.version = n;
    }

    public int getVersion() {
        return this.version;
    }

    public Pointer createPointer(byte[] byArray, int n) {
        if (this.version >= 6) {
            PointerV6 pointerV6 = new PointerV6();
            pointerV6.type = LittleEndian.getInt(byArray, n + 0);
            pointerV6.address = (int)LittleEndian.getUInt(byArray, n + 4);
            pointerV6.offset = (int)LittleEndian.getUInt(byArray, n + 8);
            pointerV6.length = (int)LittleEndian.getUInt(byArray, n + 12);
            pointerV6.format = LittleEndian.getShort(byArray, n + 16);
            return pointerV6;
        }
        if (this.version == 5) {
            throw new RuntimeException("TODO Support v5 Pointers");
        }
        throw new IllegalArgumentException("Visio files with versions below 5 are not supported, yours was " + this.version);
    }
}

