/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdgf.extractor;

import ai2.org.apache.poi.POIOLE2TextExtractor;
import ai2.org.apache.poi.hdgf.HDGFDiagram;
import ai2.org.apache.poi.hdgf.chunks.Chunk;
import ai2.org.apache.poi.hdgf.streams.ChunkStream;
import ai2.org.apache.poi.hdgf.streams.PointerContainingStream;
import ai2.org.apache.poi.hdgf.streams.Stream;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VisioTextExtractor
extends POIOLE2TextExtractor {
    private HDGFDiagram hdgf;

    public VisioTextExtractor(HDGFDiagram hDGFDiagram) {
        super(hDGFDiagram);
        this.hdgf = hDGFDiagram;
    }

    public VisioTextExtractor(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    public VisioTextExtractor(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this(nPOIFSFileSystem.getRoot());
    }

    public VisioTextExtractor(DirectoryNode directoryNode) throws IOException {
        this(new HDGFDiagram(directoryNode));
    }

    @Deprecated
    public VisioTextExtractor(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(new HDGFDiagram(directoryNode, pOIFSFileSystem));
    }

    public VisioTextExtractor(InputStream inputStream) throws IOException {
        this(new NPOIFSFileSystem(inputStream));
    }

    public String[] getAllText() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.hdgf.getTopLevelStreams().length; ++i) {
            this.findText(this.hdgf.getTopLevelStreams()[i], arrayList);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void findText(Stream stream, ArrayList<String> arrayList) {
        int n;
        Stream stream2;
        if (stream instanceof PointerContainingStream) {
            stream2 = (PointerContainingStream)stream;
            for (n = 0; n < ((PointerContainingStream)stream2).getPointedToStreams().length; ++n) {
                this.findText(((PointerContainingStream)stream2).getPointedToStreams()[n], arrayList);
            }
        }
        if (stream instanceof ChunkStream) {
            stream2 = (ChunkStream)stream;
            for (n = 0; n < ((ChunkStream)stream2).getChunks().length; ++n) {
                String string;
                Chunk.Command command;
                Chunk chunk = ((ChunkStream)stream2).getChunks()[n];
                if (chunk == null || chunk.getName() == null || !chunk.getName().equals("Text") || chunk.getCommands().length <= 0 || (command = chunk.getCommands()[0]) == null || command.getValue() == null || (string = command.getValue().toString()).equals("") || string.equals("\n")) continue;
                arrayList.add(string);
            }
        }
    }

    @Override
    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getAllText();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (stringArray[i].endsWith("\r") || stringArray[i].endsWith("\n")) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Use:");
            System.err.println("   VisioTextExtractor <file.vsd>");
            System.exit(1);
        }
        VisioTextExtractor visioTextExtractor = new VisioTextExtractor(new FileInputStream(stringArray[0]));
        System.out.print(visioTextExtractor.getText());
        visioTextExtractor.close();
    }
}

