/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdgf.dev;

import ai2.org.apache.poi.hdgf.HDGFDiagram;
import ai2.org.apache.poi.hdgf.chunks.Chunk;
import ai2.org.apache.poi.hdgf.pointers.Pointer;
import ai2.org.apache.poi.hdgf.streams.ChunkStream;
import ai2.org.apache.poi.hdgf.streams.PointerContainingStream;
import ai2.org.apache.poi.hdgf.streams.Stream;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import java.io.File;

public final class VSDDumper {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Use:");
            System.err.println("  VSDDumper <filename>");
            System.exit(1);
        }
        HDGFDiagram hDGFDiagram = new HDGFDiagram(new NPOIFSFileSystem(new File(stringArray[0])));
        System.out.println("Opened " + stringArray[0]);
        System.out.println("The document claims a size of " + hDGFDiagram.getDocumentSize() + "   (" + Long.toHexString(hDGFDiagram.getDocumentSize()) + ")");
        System.out.println();
        VSDDumper.dumpStream(hDGFDiagram.getTrailerStream(), 0);
    }

    public static void dumpStream(Stream stream, int n) {
        int n2;
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "    ";
        }
        String string2 = string + "    ";
        String string3 = string2 + "    ";
        Pointer pointer = stream.getPointer();
        System.out.println(string + "Stream at\t" + pointer.getOffset() + " - " + Integer.toHexString(pointer.getOffset()));
        System.out.println(string + "  Type is\t" + pointer.getType() + " - " + Integer.toHexString(pointer.getType()));
        System.out.println(string + "  Format is\t" + pointer.getFormat() + " - " + Integer.toHexString(pointer.getFormat()));
        System.out.println(string + "  Length is\t" + pointer.getLength() + " - " + Integer.toHexString(pointer.getLength()));
        if (pointer.destinationCompressed()) {
            int n3 = stream._getContentsLength();
            System.out.println(string + "  DC.Length is\t" + n3 + " - " + Integer.toHexString(n3));
        }
        System.out.println(string + "  Compressed is\t" + pointer.destinationCompressed());
        System.out.println(string + "  Stream is\t" + stream.getClass().getName());
        byte[] byArray = stream._getStore()._getContents();
        String string4 = "";
        if (byArray.length >= 8) {
            for (int i = 0; i < 8; ++i) {
                if (i > 0) {
                    string4 = string4 + ", ";
                }
                string4 = string4 + byArray[i];
            }
        }
        System.out.println(string + "  First few bytes are\t" + string4);
        if (stream instanceof PointerContainingStream) {
            PointerContainingStream pointerContainingStream = (PointerContainingStream)stream;
            System.out.println(string + "  Has " + pointerContainingStream.getPointedToStreams().length + " children:");
            for (n2 = 0; n2 < pointerContainingStream.getPointedToStreams().length; ++n2) {
                VSDDumper.dumpStream(pointerContainingStream.getPointedToStreams()[n2], n + 1);
            }
        }
        if (stream instanceof ChunkStream) {
            ChunkStream chunkStream = (ChunkStream)stream;
            System.out.println(string + "  Has " + chunkStream.getChunks().length + " chunks:");
            for (n2 = 0; n2 < chunkStream.getChunks().length; ++n2) {
                Chunk chunk = chunkStream.getChunks()[n2];
                System.out.println(string2 + "" + chunk.getName());
                System.out.println(string2 + "  Length is " + chunk._getContents().length + " (" + Integer.toHexString(chunk._getContents().length) + ")");
                System.out.println(string2 + "  OD Size is " + chunk.getOnDiskSize() + " (" + Integer.toHexString(chunk.getOnDiskSize()) + ")");
                System.out.println(string2 + "  T / S is " + chunk.getTrailer() + " / " + chunk.getSeparator());
                System.out.println(string2 + "  Holds " + chunk.getCommands().length + " commands");
                for (int i = 0; i < chunk.getCommands().length; ++i) {
                    Chunk.Command command = chunk.getCommands()[i];
                    System.out.println(string3 + "" + command.getDefinition().getName() + " " + command.getValue());
                }
            }
        }
    }
}

