/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdgf.chunks;

import ai2.org.apache.poi.hdgf.chunks.ChunkHeaderV11;
import ai2.org.apache.poi.hdgf.chunks.ChunkHeaderV4V5;
import ai2.org.apache.poi.hdgf.chunks.ChunkHeaderV6;
import ai2.org.apache.poi.util.LittleEndian;
import java.nio.charset.Charset;

public abstract class ChunkHeader {
    protected int type;
    protected int id;
    protected int length;
    protected int unknown1;

    public static ChunkHeader createChunkHeader(int n, byte[] byArray, int n2) {
        if (n >= 6) {
            ChunkHeaderV6 chunkHeaderV6 = n > 6 ? new ChunkHeaderV11() : new ChunkHeaderV6();
            chunkHeaderV6.type = (int)LittleEndian.getUInt(byArray, n2 + 0);
            chunkHeaderV6.id = (int)LittleEndian.getUInt(byArray, n2 + 4);
            chunkHeaderV6.unknown1 = (int)LittleEndian.getUInt(byArray, n2 + 8);
            chunkHeaderV6.length = (int)LittleEndian.getUInt(byArray, n2 + 12);
            chunkHeaderV6.unknown2 = LittleEndian.getShort(byArray, n2 + 16);
            chunkHeaderV6.unknown3 = (short)LittleEndian.getUnsignedByte(byArray, n2 + 18);
            return chunkHeaderV6;
        }
        if (n == 5 || n == 4) {
            ChunkHeaderV4V5 chunkHeaderV4V5 = new ChunkHeaderV4V5();
            chunkHeaderV4V5.type = LittleEndian.getShort(byArray, n2 + 0);
            chunkHeaderV4V5.id = LittleEndian.getShort(byArray, n2 + 2);
            chunkHeaderV4V5.unknown2 = (short)LittleEndian.getUnsignedByte(byArray, n2 + 4);
            chunkHeaderV4V5.unknown3 = (short)LittleEndian.getUnsignedByte(byArray, n2 + 5);
            chunkHeaderV4V5.unknown1 = LittleEndian.getShort(byArray, n2 + 6);
            chunkHeaderV4V5.length = (int)LittleEndian.getUInt(byArray, n2 + 8);
            return chunkHeaderV4V5;
        }
        throw new IllegalArgumentException("Visio files with versions below 4 are not supported, yours was " + n);
    }

    public static int getHeaderSize(int n) {
        if (n > 6) {
            return ChunkHeaderV11.getHeaderSize();
        }
        if (n == 6) {
            return ChunkHeaderV6.getHeaderSize();
        }
        return ChunkHeaderV4V5.getHeaderSize();
    }

    public abstract int getSizeInBytes();

    public abstract boolean hasTrailer();

    public abstract boolean hasSeparator();

    public abstract Charset getChunkCharset();

    public int getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public int getUnknown1() {
        return this.unknown1;
    }
}

