/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdgf.chunks;

import ai2.org.apache.poi.hdgf.chunks.Chunk;
import ai2.org.apache.poi.hdgf.chunks.ChunkHeader;
import ai2.org.apache.poi.hdgf.chunks.ChunkSeparator;
import ai2.org.apache.poi.hdgf.chunks.ChunkTrailer;
import ai2.org.apache.poi.util.LocaleUtil;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class ChunkFactory {
    private int version;
    private Hashtable<Integer, CommandDefinition[]> chunkCommandDefinitions = new Hashtable();
    private static String chunkTableName = "/ai2.org.apache.poi/hdgf/chunks_parse_cmds.tbl";
    private static POILogger logger = POILogFactory.getLogger(ChunkFactory.class);

    public ChunkFactory(int n) throws IOException {
        this.version = n;
        this.processChunkParseCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChunkParseCommands() throws IOException {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            inputStream = ChunkFactory.class.getResourceAsStream(chunkTableName);
            if (inputStream == null) {
                throw new IllegalStateException("Unable to find HDGF chunk definition on the classpath - " + chunkTableName);
            }
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, LocaleUtil.CHARSET_1252));
            while ((string = bufferedReader.readLine()) != null) {
                CommandDefinition[] commandDefinitionArray;
                if (string.startsWith("#") || string.startsWith(" ") || string.startsWith("\t") || string.length() == 0) continue;
                if (!string.startsWith("start")) {
                    throw new IllegalStateException("Expecting start xxx, found " + string);
                }
                int n = Integer.parseInt(string.substring(6));
                ArrayList<CommandDefinition> arrayList = new ArrayList<CommandDefinition>();
                while (!(string = bufferedReader.readLine()).startsWith("end")) {
                    commandDefinitionArray = new StringTokenizer(string, " ");
                    int n2 = Integer.parseInt(commandDefinitionArray.nextToken());
                    int n3 = Integer.parseInt(commandDefinitionArray.nextToken());
                    String string2 = commandDefinitionArray.nextToken("\uffff").substring(1);
                    CommandDefinition commandDefinition = new CommandDefinition(n2, n3, string2);
                    arrayList.add(commandDefinition);
                }
                commandDefinitionArray = arrayList.toArray(new CommandDefinition[arrayList.size()]);
                this.chunkCommandDefinitions.put(n, commandDefinitionArray);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public int getVersion() {
        return this.version;
    }

    public Chunk createChunk(byte[] byArray, int n) {
        ChunkHeader chunkHeader = ChunkHeader.createChunkHeader(this.version, byArray, n);
        if (chunkHeader.length < 0) {
            throw new IllegalArgumentException("Found a chunk with a negative length, which isn't allowed");
        }
        int n2 = n + chunkHeader.getLength() + chunkHeader.getSizeInBytes();
        if (n2 > byArray.length) {
            logger.log(5, new Object[]{"Header called for " + chunkHeader.getLength() + " bytes, but that would take us past the end of the data!"});
            n2 = byArray.length;
            chunkHeader.length = byArray.length - n - chunkHeader.getSizeInBytes();
            if (chunkHeader.hasTrailer()) {
                chunkHeader.length -= 8;
                n2 -= 8;
            }
            if (chunkHeader.hasSeparator()) {
                chunkHeader.length -= 4;
                n2 -= 4;
            }
        }
        ChunkTrailer chunkTrailer = null;
        ChunkSeparator chunkSeparator = null;
        if (chunkHeader.hasTrailer()) {
            if (n2 <= byArray.length - 8) {
                chunkTrailer = new ChunkTrailer(byArray, n2);
                n2 += 8;
            } else {
                logger.log(7, new Object[]{"Header claims a length to " + n2 + " there's then no space for the trailer in the data (" + byArray.length + ")"});
            }
        }
        if (chunkHeader.hasSeparator()) {
            if (n2 <= byArray.length - 4) {
                chunkSeparator = new ChunkSeparator(byArray, n2);
            } else {
                logger.log(7, new Object[]{"Header claims a length to " + n2 + " there's then no space for the separator in the data (" + byArray.length + ")"});
            }
        }
        byte[] byArray2 = new byte[chunkHeader.getLength()];
        System.arraycopy(byArray, n + chunkHeader.getSizeInBytes(), byArray2, 0, byArray2.length);
        Chunk chunk = new Chunk(chunkHeader, chunkTrailer, chunkSeparator, byArray2);
        CommandDefinition[] commandDefinitionArray = this.chunkCommandDefinitions.get(chunkHeader.getType());
        if (commandDefinitionArray == null) {
            commandDefinitionArray = new CommandDefinition[]{};
        }
        chunk.commandDefinitions = commandDefinitionArray;
        chunk.processCommands();
        return chunk;
    }

    public static class CommandDefinition {
        private int type;
        private int offset;
        private String name;

        public CommandDefinition(int n, int n2, String string) {
            this.type = n;
            this.offset = n2;
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getType() {
            return this.type;
        }
    }
}

