/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdgf;

import ai2.org.apache.poi.hdgf.HDGFLZW;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class HDGFLZWCompressor {
    byte[] dict = new byte[4096];
    byte[] buffer = new byte[16];
    int bufferLen = 0;
    byte[] rawCode = new byte[18];
    int rawCodeLen = 0;
    int posInp = 0;
    int posOut = 0;
    int nextMask = 0;
    int maskBitsSet = 0;

    private int findRawCodeInBuffer() {
        for (int i = 4096 - this.rawCodeLen; i > 0; --i) {
            boolean bl = true;
            for (int j = 0; bl && j < this.rawCodeLen; ++j) {
                if (this.dict[i + j] == this.rawCode[j]) continue;
                bl = false;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    private void outputCompressed(OutputStream outputStream) throws IOException {
        if (this.rawCodeLen < 3) {
            for (int i = 0; i < this.rawCodeLen; ++i) {
                this.outputUncompressed(this.rawCode[i], outputStream);
            }
            return;
        }
        int n = this.findRawCodeInBuffer();
        if ((n -= 18) < 0) {
            n += 4096;
        }
        ++this.maskBitsSet;
        int n2 = n & 0xFF;
        int n3 = this.rawCodeLen - 3 + (n - n2 >> 4);
        this.buffer[this.bufferLen] = HDGFLZW.fromInt(n2);
        ++this.bufferLen;
        this.buffer[this.bufferLen] = HDGFLZW.fromInt(n3);
        ++this.bufferLen;
        for (int i = 0; i < this.rawCodeLen; ++i) {
            this.dict[this.posOut & 0xFFF] = this.rawCode[i];
            ++this.posOut;
        }
        if (this.maskBitsSet == 8) {
            this.output8Codes(outputStream);
        }
    }

    private void outputUncompressed(byte by, OutputStream outputStream) throws IOException {
        this.nextMask += 1 << this.maskBitsSet;
        ++this.maskBitsSet;
        this.buffer[this.bufferLen] = by;
        ++this.bufferLen;
        this.dict[this.posOut & 0xFFF] = by;
        ++this.posOut;
        if (this.maskBitsSet == 8) {
            this.output8Codes(outputStream);
        }
    }

    private void output8Codes(OutputStream outputStream) throws IOException {
        outputStream.write(new byte[]{HDGFLZW.fromInt(this.nextMask)});
        outputStream.write(this.buffer, 0, this.bufferLen);
        this.nextMask = 0;
        this.maskBitsSet = 0;
        this.bufferLen = 0;
    }

    public void compress(InputStream inputStream, OutputStream outputStream) throws IOException {
        boolean bl = true;
        while (bl) {
            int n = inputStream.read();
            ++this.posInp;
            if (n == -1) {
                bl = false;
            }
            byte by = HDGFLZW.fromInt(n);
            if (!bl) {
                if (this.rawCodeLen <= 0) break;
                this.outputCompressed(outputStream);
                if (this.maskBitsSet <= 0) break;
                this.output8Codes(outputStream);
                break;
            }
            this.rawCode[this.rawCodeLen] = by;
            ++this.rawCodeLen;
            int n2 = this.findRawCodeInBuffer();
            if (this.rawCodeLen == 18 && n2 > -1) {
                this.outputCompressed(outputStream);
                this.rawCodeLen = 0;
                continue;
            }
            if (n2 > -1) continue;
            --this.rawCodeLen;
            if (this.rawCodeLen > 0) {
                this.outputCompressed(outputStream);
                this.rawCode[0] = by;
                this.rawCodeLen = 1;
                if (this.findRawCodeInBuffer() > -1) continue;
                this.outputUncompressed(by, outputStream);
                this.rawCodeLen = 0;
                continue;
            }
            this.outputUncompressed(by, outputStream);
        }
    }
}

