/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdgf;

import ai2.org.apache.poi.POIDocument;
import ai2.org.apache.poi.hdgf.chunks.ChunkFactory;
import ai2.org.apache.poi.hdgf.pointers.Pointer;
import ai2.org.apache.poi.hdgf.pointers.PointerFactory;
import ai2.org.apache.poi.hdgf.streams.PointerContainingStream;
import ai2.org.apache.poi.hdgf.streams.Stream;
import ai2.org.apache.poi.hdgf.streams.StringsStream;
import ai2.org.apache.poi.hdgf.streams.TrailerStream;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LocaleUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public final class HDGFDiagram
extends POIDocument {
    private static final String VISIO_HEADER = "Visio (TM) Drawing\r\n";
    private byte[] _docstream;
    private short version;
    private long docSize;
    private Pointer trailerPointer;
    private TrailerStream trailer;
    private ChunkFactory chunkFactory;
    private PointerFactory ptrFactory;

    public HDGFDiagram(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    public HDGFDiagram(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this(nPOIFSFileSystem.getRoot());
    }

    @Deprecated
    public HDGFDiagram(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(directoryNode);
    }

    public HDGFDiagram(DirectoryNode directoryNode) throws IOException {
        super(directoryNode);
        DocumentEntry documentEntry = (DocumentEntry)directoryNode.getEntry("VisioDocument");
        this._docstream = new byte[documentEntry.getSize()];
        directoryNode.createDocumentInputStream("VisioDocument").read(this._docstream);
        String string = new String(this._docstream, 0, 20, LocaleUtil.CHARSET_1252);
        if (!string.equals(VISIO_HEADER)) {
            throw new IllegalArgumentException("Wasn't a valid visio document, started with " + string);
        }
        this.version = LittleEndian.getShort(this._docstream, 26);
        this.docSize = LittleEndian.getUInt(this._docstream, 28);
        this.ptrFactory = new PointerFactory(this.version);
        this.chunkFactory = new ChunkFactory(this.version);
        this.trailerPointer = this.ptrFactory.createPointer(this._docstream, 36);
        this.trailer = (TrailerStream)Stream.createStream(this.trailerPointer, this._docstream, this.chunkFactory, this.ptrFactory);
        this.trailer.findChildren(this._docstream);
    }

    public TrailerStream getTrailerStream() {
        return this.trailer;
    }

    public Stream[] getTopLevelStreams() {
        return this.trailer.getPointedToStreams();
    }

    public long getDocumentSize() {
        return this.docSize;
    }

    public void debug() {
        System.err.println("Trailer is at " + this.trailerPointer.getOffset());
        System.err.println("Trailer has type " + this.trailerPointer.getType());
        System.err.println("Trailer has length " + this.trailerPointer.getLength());
        System.err.println("Trailer has format " + this.trailerPointer.getFormat());
        for (int i = 0; i < this.trailer.getPointedToStreams().length; ++i) {
            Stream stream;
            Stream stream2 = this.trailer.getPointedToStreams()[i];
            Pointer pointer = stream2.getPointer();
            System.err.println("Looking at pointer " + i);
            System.err.println("\tType is " + pointer.getType() + "\t\t" + Integer.toHexString(pointer.getType()));
            System.err.println("\tOffset is " + pointer.getOffset() + "\t\t" + Long.toHexString(pointer.getOffset()));
            System.err.println("\tAddress is " + pointer.getAddress() + "\t" + Long.toHexString(pointer.getAddress()));
            System.err.println("\tLength is " + pointer.getLength() + "\t\t" + Long.toHexString(pointer.getLength()));
            System.err.println("\tFormat is " + pointer.getFormat() + "\t\t" + Long.toHexString(pointer.getFormat()));
            System.err.println("\tCompressed is " + pointer.destinationCompressed());
            System.err.println("\tStream is " + stream2.getClass());
            if (stream2 instanceof PointerContainingStream && ((PointerContainingStream)(stream = (PointerContainingStream)stream2)).getPointedToStreams() != null && ((PointerContainingStream)stream).getPointedToStreams().length > 0) {
                System.err.println("\tContains " + ((PointerContainingStream)stream).getPointedToStreams().length + " other pointers/streams");
                for (int j = 0; j < ((PointerContainingStream)stream).getPointedToStreams().length; ++j) {
                    Stream stream3 = ((PointerContainingStream)stream).getPointedToStreams()[j];
                    Pointer pointer2 = stream3.getPointer();
                    System.err.println("\t\t" + j + " - Type is " + pointer2.getType() + "\t\t" + Integer.toHexString(pointer2.getType()));
                    System.err.println("\t\t" + j + " - Length is " + pointer2.getLength() + "\t\t" + Long.toHexString(pointer2.getLength()));
                }
            }
            if (!(stream2 instanceof StringsStream)) continue;
            System.err.println("\t\t**strings**");
            stream = (StringsStream)stream2;
            System.err.println("\t\t" + stream._getContentsLength());
        }
    }

    public void write(OutputStream outputStream) {
        throw new IllegalStateException("Writing is not yet implemented, see http://poi.apache.org/hdgf/");
    }

    public static void main(String[] stringArray) throws Exception {
        NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(new File(stringArray[0]));
        HDGFDiagram hDGFDiagram = new HDGFDiagram(nPOIFSFileSystem);
        hDGFDiagram.debug();
        nPOIFSFileSystem.close();
    }
}

