/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdf.model;

import ai2.org.apache.poi.hdf.event.HDFLowLevelParsingListener;
import ai2.org.apache.poi.hdf.model.HDFObjectModel;
import ai2.org.apache.poi.hdf.model.hdftypes.CHPFormattedDiskPage;
import ai2.org.apache.poi.hdf.model.hdftypes.ChpxNode;
import ai2.org.apache.poi.hdf.model.hdftypes.DocumentProperties;
import ai2.org.apache.poi.hdf.model.hdftypes.FileInformationBlock;
import ai2.org.apache.poi.hdf.model.hdftypes.FontTable;
import ai2.org.apache.poi.hdf.model.hdftypes.FormattedDiskPage;
import ai2.org.apache.poi.hdf.model.hdftypes.ListTables;
import ai2.org.apache.poi.hdf.model.hdftypes.PAPFormattedDiskPage;
import ai2.org.apache.poi.hdf.model.hdftypes.PapxNode;
import ai2.org.apache.poi.hdf.model.hdftypes.PlexOfCps;
import ai2.org.apache.poi.hdf.model.hdftypes.SepxNode;
import ai2.org.apache.poi.hdf.model.hdftypes.StyleSheet;
import ai2.org.apache.poi.hdf.model.hdftypes.TextPiece;
import ai2.org.apache.poi.hdf.model.util.ParsingState;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public final class HDFObjectFactory {
    private POIFSFileSystem _filesystem;
    private FileInformationBlock _fib;
    private HDFLowLevelParsingListener _listener;
    private ParsingState _charParsingState;
    private ParsingState _parParsingState;
    byte[] _mainDocument;
    byte[] _tableBuffer;

    public static void main(String[] stringArray) throws Exception {
        new HDFObjectFactory(new FileInputStream("c:\\test.doc"));
    }

    protected HDFObjectFactory(InputStream inputStream, HDFLowLevelParsingListener hDFLowLevelParsingListener) throws IOException {
        this._listener = hDFLowLevelParsingListener == null ? new HDFObjectModel() : hDFLowLevelParsingListener;
        this._filesystem = new POIFSFileSystem(inputStream);
        DocumentEntry documentEntry = (DocumentEntry)this._filesystem.getRoot().getEntry("WordDocument");
        this._mainDocument = new byte[documentEntry.getSize()];
        this._filesystem.createDocumentInputStream("WordDocument").read(this._mainDocument);
        this._fib = new FileInformationBlock(this._mainDocument);
        this.initTableStream();
        this.initTextPieces();
        this.initFormattingProperties();
    }

    public HDFObjectFactory(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileInformationBlock> getTypes(InputStream inputStream) throws IOException {
        ArrayList<FileInformationBlock> arrayList = new ArrayList<FileInformationBlock>(1);
        POIFSFileSystem pOIFSFileSystem = null;
        try {
            pOIFSFileSystem = new POIFSFileSystem(inputStream);
            DocumentEntry documentEntry = (DocumentEntry)pOIFSFileSystem.getRoot().getEntry("WordDocument");
            byte[] byArray = new byte[documentEntry.getSize()];
            pOIFSFileSystem.createDocumentInputStream("WordDocument").read(byArray);
            FileInformationBlock fileInformationBlock = new FileInformationBlock(byArray);
            arrayList.add(fileInformationBlock);
            ArrayList<FileInformationBlock> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (pOIFSFileSystem != null) {
                pOIFSFileSystem.close();
            }
        }
    }

    private void initTableStream() throws IOException {
        String string = null;
        string = this._fib.isFWhichTblStm() ? "1Table" : "0Table";
        DocumentEntry documentEntry = (DocumentEntry)this._filesystem.getRoot().getEntry(string);
        int n = documentEntry.getSize();
        this._tableBuffer = new byte[n];
        this._filesystem.createDocumentInputStream(string).read(this._tableBuffer);
    }

    private void initTextPieces() throws IOException {
        int n;
        int n2 = this._fib.getFcClx();
        while (this._tableBuffer[n2] == 1) {
            n = LittleEndian.getShort(this._tableBuffer, ++n2);
            n2 += 2 + n;
        }
        if (this._tableBuffer[n2] != 2) {
            throw new IOException("The text piece table is corrupted");
        }
        n = LittleEndian.getInt(this._tableBuffer, ++n2);
        n2 += 4;
        int n3 = (n - 4) / 12;
        for (int i = 0; i < n3; ++i) {
            int n4 = LittleEndian.getInt(this._tableBuffer, n2 + (n3 + 1) * 4 + i * 8 + 2);
            boolean bl = false;
            if ((n4 & 0x40000000) == 0) {
                bl = true;
            } else {
                bl = false;
                n4 &= 0xBFFFFFFF;
                n4 /= 2;
            }
            int n5 = LittleEndian.getInt(this._tableBuffer, n2 + (i + 1) * 4) - LittleEndian.getInt(this._tableBuffer, n2 + i * 4);
            TextPiece textPiece = new TextPiece(n4, n5, bl);
            this._listener.text(textPiece);
        }
    }

    private void initFormattingProperties() {
        this.createStyleSheet();
        this.createListTables();
        this.createFontTable();
        this.initDocumentProperties();
        this.initSectionProperties();
    }

    private void initCharacterProperties(int n, PlexOfCps plexOfCps, int n2, int n3) {
        int n4 = plexOfCps.length();
        int n5 = this._charParsingState.getCurrentPageIndex();
        FormattedDiskPage formattedDiskPage = this._charParsingState.getFkp();
        int n6 = this._charParsingState.getCurrentPropIndex();
        int n7 = formattedDiskPage.size();
        int n8 = 0;
        int n9 = 0;
        do {
            if (n6 < n7) {
                n8 = formattedDiskPage.getStart(n6);
                n9 = formattedDiskPage.getEnd(n6);
                byte[] byArray = formattedDiskPage.getGrpprl(n6);
                this._listener.characterRun(new ChpxNode(Math.max(n8, n2), Math.min(n9, n3), byArray));
                if (n9 < n3) {
                    ++n6;
                    continue;
                }
                this._charParsingState.setState(n5, formattedDiskPage, n6);
                break;
            }
            int n10 = LittleEndian.getInt(this._tableBuffer, n + plexOfCps.getStructOffset(++n5));
            byte[] byArray = new byte[512];
            System.arraycopy(this._mainDocument, n10 * 512, byArray, 0, 512);
            formattedDiskPage = new CHPFormattedDiskPage(byArray);
            n6 = 0;
            n7 = formattedDiskPage.size();
        } while (n5 < n4);
    }

    private void initParagraphProperties(int n, PlexOfCps plexOfCps, int n2, PlexOfCps plexOfCps2, int n3, int n4) {
        int n5 = plexOfCps.length();
        int n6 = this._parParsingState.getCurrentPageIndex();
        FormattedDiskPage formattedDiskPage = this._parParsingState.getFkp();
        int n7 = this._parParsingState.getCurrentPropIndex();
        int n8 = formattedDiskPage.size();
        do {
            int n9;
            if (n7 < n8) {
                n9 = formattedDiskPage.getStart(n7);
                int n10 = formattedDiskPage.getEnd(n7);
                byte[] byArray = formattedDiskPage.getGrpprl(n7);
                this._listener.paragraph(new PapxNode(Math.max(n9, n3), Math.min(n10, n4), byArray));
                this.initCharacterProperties(n2, plexOfCps2, Math.max(n3, n9), Math.min(n10, n4));
                if (n10 < n4) {
                    ++n7;
                    continue;
                }
                this._parParsingState.setState(n6, formattedDiskPage, n7);
                break;
            }
            n9 = LittleEndian.getInt(this._tableBuffer, n + plexOfCps.getStructOffset(++n6));
            byte[] byArray = new byte[512];
            System.arraycopy(this._mainDocument, n9 * 512, byArray, 0, 512);
            formattedDiskPage = new PAPFormattedDiskPage(byArray);
            n7 = 0;
            n8 = formattedDiskPage.size();
        } while (n6 < n5);
    }

    private void initParagraphProperties() {
        int n = this._fib.getFcPlcfbtePapx();
        int n2 = this._fib.getLcbPlcfbtePapx();
        int n3 = this._fib.getFcPlcfbteChpx();
        int n4 = this._fib.getLcbPlcfbteChpx();
        PlexOfCps plexOfCps = new PlexOfCps(n4, 4);
        PlexOfCps plexOfCps2 = new PlexOfCps(n2, 4);
        int n5 = LittleEndian.getInt(this._tableBuffer, n3 + plexOfCps.getStructOffset(0));
        int n6 = plexOfCps.length();
        int n7 = 0;
        byte[] byArray = new byte[512];
        System.arraycopy(this._mainDocument, n5 * 512, byArray, 0, 512);
        CHPFormattedDiskPage cHPFormattedDiskPage = new CHPFormattedDiskPage(byArray);
        int n8 = 0;
        int n9 = cHPFormattedDiskPage.size();
        int n10 = plexOfCps2.length();
        for (int i = 0; i < n10; ++i) {
            int n11 = LittleEndian.getInt(this._tableBuffer, n + plexOfCps2.getStructOffset(i));
            byArray = new byte[512];
            System.arraycopy(this._mainDocument, n11 * 512, byArray, 0, 512);
            PAPFormattedDiskPage pAPFormattedDiskPage = new PAPFormattedDiskPage(byArray);
            int n12 = pAPFormattedDiskPage.size();
            block1: for (int j = 0; j < n12; ++j) {
                int n13 = pAPFormattedDiskPage.getStart(j);
                int n14 = pAPFormattedDiskPage.getEnd(j);
                byte[] byArray2 = pAPFormattedDiskPage.getGrpprl(j);
                this._listener.paragraph(new PapxNode(n13, n14, byArray2));
                int n15 = 0;
                int n16 = 0;
                do {
                    if (n8 < n9) {
                        n15 = cHPFormattedDiskPage.getStart(n8);
                        n16 = cHPFormattedDiskPage.getEnd(n8);
                        byte[] byArray3 = cHPFormattedDiskPage.getGrpprl(n8);
                        this._listener.characterRun(new ChpxNode(n15, n16, byArray3));
                        if (n16 >= n14) continue block1;
                        ++n8;
                        continue;
                    }
                    n5 = LittleEndian.getInt(this._tableBuffer, n3 + plexOfCps.getStructOffset(++n7));
                    byArray = new byte[512];
                    System.arraycopy(this._mainDocument, n5 * 512, byArray, 0, 512);
                    cHPFormattedDiskPage = new CHPFormattedDiskPage(byArray);
                    n8 = 0;
                    n9 = cHPFormattedDiskPage.size();
                } while (n5 <= n6 + 1);
            }
        }
    }

    private void initParsingStates(int n, PlexOfCps plexOfCps, int n2, PlexOfCps plexOfCps2) {
        int n3 = LittleEndian.getInt(this._tableBuffer, n2 + plexOfCps2.getStructOffset(0));
        byte[] byArray = new byte[512];
        System.arraycopy(this._mainDocument, n3 * 512, byArray, 0, 512);
        CHPFormattedDiskPage cHPFormattedDiskPage = new CHPFormattedDiskPage(byArray);
        this._charParsingState = new ParsingState(n3, cHPFormattedDiskPage);
        int n4 = LittleEndian.getInt(this._tableBuffer, n + plexOfCps.getStructOffset(0));
        byArray = new byte[512];
        System.arraycopy(this._mainDocument, n4 * 512, byArray, 0, 512);
        PAPFormattedDiskPage pAPFormattedDiskPage = new PAPFormattedDiskPage(byArray);
        this._parParsingState = new ParsingState(n4, pAPFormattedDiskPage);
    }

    private void initSectionProperties() {
        SepxNode sepxNode;
        byte[] byArray;
        short s;
        int n;
        int n2;
        int n3;
        int n4 = this._fib.getCcpText();
        int n5 = this._fib.getFcMin();
        int n6 = this._fib.getFcPlcfsed();
        int n7 = this._fib.getLcbPlcfsed();
        int n8 = this._fib.getFcPlcfbtePapx();
        int n9 = this._fib.getLcbPlcfbtePapx();
        int n10 = this._fib.getFcPlcfbteChpx();
        int n11 = this._fib.getLcbPlcfbteChpx();
        PlexOfCps plexOfCps = new PlexOfCps(n11, 4);
        PlexOfCps plexOfCps2 = new PlexOfCps(n9, 4);
        this.initParsingStates(n8, plexOfCps2, n10, plexOfCps);
        PlexOfCps plexOfCps3 = new PlexOfCps(n7, 12);
        int n12 = plexOfCps3.length();
        int n13 = n5;
        int n14 = n5 + n4;
        int n15 = 0;
        for (n3 = 0; n3 < n12; ++n3) {
            n2 = LittleEndian.getInt(this._tableBuffer, n6 + plexOfCps3.getIntOffset(n3)) + n5;
            n15 = LittleEndian.getInt(this._tableBuffer, n6 + plexOfCps3.getIntOffset(n3 + 1)) + n5;
            n = LittleEndian.getInt(this._tableBuffer, n6 + plexOfCps3.getStructOffset(n3) + 2);
            s = LittleEndian.getShort(this._mainDocument, n);
            byArray = new byte[s];
            System.arraycopy(this._mainDocument, n + 2, byArray, 0, s);
            sepxNode = new SepxNode(n3 + 1, n2, n15, byArray);
            this._listener.bodySection(sepxNode);
            this.initParagraphProperties(n8, plexOfCps2, n10, plexOfCps, n2, Math.min(n14, n15));
            if (n15 > n14) break;
        }
        while (n3 < n12) {
            n2 = LittleEndian.getInt(this._tableBuffer, n6 + plexOfCps3.getIntOffset(n3)) + n5;
            n15 = LittleEndian.getInt(this._tableBuffer, n6 + plexOfCps3.getIntOffset(n3 + 1)) + n5;
            n = LittleEndian.getInt(this._tableBuffer, n6 + plexOfCps3.getStructOffset(n3) + 2);
            s = LittleEndian.getShort(this._mainDocument, n);
            byArray = new byte[s];
            System.arraycopy(this._mainDocument, n + 2, byArray, 0, s);
            sepxNode = new SepxNode(n3 + 1, n2, n15, byArray);
            this._listener.hdrSection(sepxNode);
            this.initParagraphProperties(n8, plexOfCps2, n10, plexOfCps, Math.max(n2, n14), n15);
            ++n3;
        }
        this._listener.endSections();
    }

    private void initDocumentProperties() {
        int n = this._fib.getFcDop();
        int n2 = this._fib.getLcbDop();
        byte[] byArray = new byte[n2];
        System.arraycopy(this._tableBuffer, n, byArray, 0, n2);
        this._listener.document(new DocumentProperties(byArray));
    }

    private void createStyleSheet() {
        int n = this._fib.getFcStshf();
        int n2 = this._fib.getLcbStshf();
        byte[] byArray = new byte[n2];
        System.arraycopy(this._tableBuffer, n, byArray, 0, n2);
        this._listener.styleSheet(new StyleSheet(byArray));
    }

    private void createListTables() {
        int n = this._fib.getFcPlfLfo();
        int n2 = this._fib.getLcbPlfLfo();
        byte[] byArray = new byte[n2];
        System.arraycopy(this._tableBuffer, n, byArray, 0, n2);
        int n3 = this._fib.getFcPlcfLst();
        int n4 = this._fib.getLcbPlcfLst();
        if (n3 > 0 && n4 > 0) {
            n4 = n - n3;
            byte[] byArray2 = new byte[n4];
            System.arraycopy(this._tableBuffer, n3, byArray2, 0, n4);
            this._listener.lists(new ListTables(byArray2, byArray));
        }
    }

    private void createFontTable() {
        int n = this._fib.getFcSttbfffn();
        int n2 = this._fib.getLcbSttbfffn();
        byte[] byArray = new byte[n2];
        System.arraycopy(this._tableBuffer, n, byArray, 0, n2);
        this._listener.fonts(new FontTable(byArray));
    }
}

