/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdf.extractor;

import ai2.org.apache.poi.hdf.extractor.CHP;
import ai2.org.apache.poi.hdf.extractor.FontTable;
import ai2.org.apache.poi.hdf.extractor.HeaderFooter;
import ai2.org.apache.poi.hdf.extractor.PAP;
import ai2.org.apache.poi.hdf.extractor.SEP;
import ai2.org.apache.poi.hdf.extractor.StyleDescription;
import ai2.org.apache.poi.hdf.extractor.StyleSheet;
import ai2.org.apache.poi.hdf.extractor.TAP;
import ai2.org.apache.poi.hdf.extractor.TC;
import ai2.org.apache.poi.hdf.extractor.TableRow;
import ai2.org.apache.poi.hdf.extractor.TextPiece;
import ai2.org.apache.poi.hdf.extractor.Utils;
import ai2.org.apache.poi.hdf.extractor.data.DOP;
import ai2.org.apache.poi.hdf.extractor.data.LVL;
import ai2.org.apache.poi.hdf.extractor.data.ListTables;
import ai2.org.apache.poi.hdf.extractor.util.BTreeSet;
import ai2.org.apache.poi.hdf.extractor.util.ChpxNode;
import ai2.org.apache.poi.hdf.extractor.util.NumberFormatter;
import ai2.org.apache.poi.hdf.extractor.util.PapxNode;
import ai2.org.apache.poi.hdf.extractor.util.PropertyNode;
import ai2.org.apache.poi.hdf.extractor.util.SepxNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public final class WordDocument {
    private static final float K_1440_0F = 1440.0f;
    byte[] _header;
    StyleSheet _styleSheet;
    ListTables _listTables;
    DOP _docProps = new DOP();
    int _currentList = -1;
    int _tableSize;
    int _sectionCounter = 1;
    FontTable _fonts;
    BTreeSet _text = new BTreeSet();
    BTreeSet _characterTable = new BTreeSet();
    BTreeSet _paragraphTable = new BTreeSet();
    BTreeSet _sectionTable = new BTreeSet();
    StringBuffer _headerBuffer = new StringBuffer();
    StringBuffer _bodyBuffer = new StringBuffer();
    StringBuffer _cellBuffer;
    ArrayList<String> _cells;
    ArrayList<TableRow> _table;
    byte[] _plcfHdd;
    int _fcMin;
    int _ccpText;
    int _ccpFtn;
    private static String _outName;
    private InputStream istream;
    private POIFSFileSystem filesystem;
    private static int HEADER_EVEN_INDEX;
    private static int HEADER_ODD_INDEX;
    private static int FOOTER_EVEN_INDEX;
    private static int FOOTER_ODD_INDEX;
    private static int HEADER_FIRST_INDEX;
    private static int FOOTER_FIRST_INDEX;

    public static void main(String[] stringArray) {
        try {
            _outName = stringArray[1];
            WordDocument wordDocument = new WordDocument(stringArray[0]);
            wordDocument.closeDoc();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeAllText(Writer writer) throws IOException {
        int n = Utils.convertBytesToInt(this._header, 24);
        int n2 = Utils.convertBytesToInt(this._header, 28);
        ArrayList<PropertyNode> arrayList = this.findProperties(n, n2, this._text.root);
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            TextPiece textPiece = (TextPiece)arrayList.get(i);
            int n4 = textPiece.getStart();
            int n5 = textPiece.getEnd();
            boolean bl = textPiece.usesUnicode();
            int n6 = 1;
            if (bl) {
                n6 = 2;
                for (int j = n4; j < n5; j += n6) {
                    char c = (char)Utils.convertBytesToShort(this._header, j);
                    writer.write(c);
                }
                continue;
            }
            String string = new String(this._header, n4, n5 - n4, "windows-1252");
            writer.write(string);
        }
    }

    public WordDocument(String string) throws IOException {
        this(new FileInputStream(string));
    }

    public WordDocument(InputStream inputStream) throws IOException {
        this.istream = inputStream;
        this.filesystem = new POIFSFileSystem(this.istream);
        this.readFIB();
        ArrayList<PropertyNode> arrayList = this.findProperties(this._fcMin, this._fcMin + this._ccpText, this._sectionTable.root);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            SepxNode sepxNode = (SepxNode)arrayList.get(i);
            int n2 = sepxNode.getStart();
            int n3 = sepxNode.getEnd();
            SEP sEP = (SEP)StyleSheet.uncompressProperty(sepxNode.getSepx(), new SEP(), this._styleSheet);
            this.writeSection(Math.max(this._fcMin, n2), Math.min(this._fcMin + this._ccpText, n3), sEP, this._text, this._paragraphTable, this._characterTable, this._styleSheet);
        }
        this.istream.close();
    }

    private void readFIB() throws IOException {
        DocumentEntry documentEntry = (DocumentEntry)this.filesystem.getRoot().getEntry("WordDocument");
        this._header = new byte[documentEntry.getSize()];
        this.filesystem.createDocumentInputStream("WordDocument").read(this._header);
        short s = LittleEndian.getShort(this._header, 10);
        this._fcMin = LittleEndian.getInt(this._header, 24);
        this._ccpText = LittleEndian.getInt(this._header, 76);
        this._ccpFtn = LittleEndian.getInt(this._header, 80);
        int n = LittleEndian.getInt(this._header, 250);
        int n2 = LittleEndian.getInt(this._header, 254);
        int n3 = LittleEndian.getInt(this._header, 258);
        int n4 = LittleEndian.getInt(this._header, 262);
        boolean bl = (s & 0x200) != 0;
        this.processComplexFile(bl, n, n2, n3, n4);
    }

    private void processComplexFile(boolean bl, int n, int n2, int n3, int n4) throws IOException {
        int n5 = LittleEndian.getInt(this._header, 418);
        String string = null;
        DocumentEntry documentEntry = null;
        string = bl ? "1Table" : "0Table";
        documentEntry = (DocumentEntry)this.filesystem.getRoot().getEntry(string);
        int n6 = documentEntry.getSize();
        byte[] byArray = new byte[n6];
        this.filesystem.createDocumentInputStream(string).read(byArray);
        this.initDocProperties(byArray);
        this.initPclfHdd(byArray);
        this.findText(byArray, n5);
        this.findFormatting(byArray, n, n2, n3, n4);
    }

    private void findText(byte[] byArray, int n) throws IOException {
        int n2;
        int n3 = n;
        while (byArray[n3] == 1) {
            n2 = LittleEndian.getShort(byArray, ++n3);
            n3 += 2 + n2;
        }
        if (byArray[n3] != 2) {
            throw new IOException("corrupted Word file");
        }
        n2 = LittleEndian.getInt(byArray, ++n3);
        n3 += 4;
        int n4 = (n2 - 4) / 12;
        for (int i = 0; i < n4; ++i) {
            int n5 = LittleEndian.getInt(byArray, n3 + (n4 + 1) * 4 + i * 8 + 2);
            boolean bl = false;
            if ((n5 & 0x40000000) == 0) {
                bl = true;
            } else {
                bl = false;
                n5 &= 0xBFFFFFFF;
                n5 /= 2;
            }
            int n6 = LittleEndian.getInt(byArray, n3 + (i + 1) * 4) - LittleEndian.getInt(byArray, n3 + i * 4);
            TextPiece textPiece = new TextPiece(n5, n6, bl);
            this._text.add(textPiece);
        }
    }

    private void findFormatting(byte[] byArray, int n, int n2, int n3, int n4) {
        byte[] byArray2;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        byte[] byArray3;
        int n11;
        int n12;
        this.openDoc();
        this.createStyleSheet(byArray);
        this.createListTables(byArray);
        this.createFontTable(byArray);
        int n13 = (n2 - 4) / 8;
        for (n12 = 0; n12 < n13; ++n12) {
            n11 = LittleEndian.getInt(byArray, n + (4 * (n13 + 1) + 4 * n12));
            byArray3 = new byte[512];
            System.arraycopy(this._header, n11 * 512, byArray3, 0, 512);
            n10 = Utils.convertUnsignedByteToInt(byArray3[511]);
            for (n9 = 0; n9 < n10; ++n9) {
                n8 = LittleEndian.getInt(byArray3, n9 * 4);
                n7 = LittleEndian.getInt(byArray3, (n9 + 1) * 4);
                n6 = 2 * Utils.convertUnsignedByteToInt(byArray3[(n10 + 1) * 4 + n9]);
                if (n6 == 0) {
                    this._characterTable.add(new ChpxNode(n8, n7, new byte[0]));
                    continue;
                }
                n5 = Utils.convertUnsignedByteToInt(byArray3[n6]);
                byArray2 = new byte[n5];
                System.arraycopy(byArray3, ++n6, byArray2, 0, n5);
                this._characterTable.add(new ChpxNode(n8, n7, byArray2));
            }
        }
        n13 = (n4 - 4) / 8;
        for (n12 = 0; n12 < n13; ++n12) {
            n11 = LittleEndian.getInt(byArray, n3 + (4 * (n13 + 1) + 4 * n12));
            byArray3 = new byte[512];
            System.arraycopy(this._header, n11 * 512, byArray3, 0, 512);
            n10 = Utils.convertUnsignedByteToInt(byArray3[511]);
            for (n9 = 0; n9 < n10; ++n9) {
                n8 = LittleEndian.getInt(byArray3, n9 * 4);
                n7 = LittleEndian.getInt(byArray3, (n9 + 1) * 4);
                n6 = 2 * Utils.convertUnsignedByteToInt(byArray3[(n10 + 1) * 4 + n9 * 13]);
                n5 = 2 * Utils.convertUnsignedByteToInt(byArray3[n6]);
                n5 = n5 == 0 ? 2 * Utils.convertUnsignedByteToInt(byArray3[++n6]) : --n5;
                byArray2 = new byte[n5];
                System.arraycopy(byArray3, ++n6, byArray2, 0, n5);
                this._paragraphTable.add(new PapxNode(n8, n7, byArray2));
            }
        }
        n12 = Utils.convertBytesToInt(this._header, 24);
        n11 = Utils.convertBytesToInt(this._header, 202);
        int n14 = Utils.convertBytesToInt(this._header, 206);
        byte[] byArray4 = new byte[n14];
        System.arraycopy(byArray, n11, byArray4, 0, n14);
        n13 = (n14 - 4) / 16;
        for (n9 = 0; n9 < n13; ++n9) {
            n8 = Utils.convertBytesToInt(byArray4, n9 * 4) + n12;
            n7 = Utils.convertBytesToInt(byArray4, (n9 + 1) * 4) + n12;
            n6 = Utils.convertBytesToInt(byArray4, 4 * (n13 + 1) + n9 * 12 + 2);
            n5 = Utils.convertBytesToShort(this._header, n6);
            byArray2 = new byte[n5];
            System.arraycopy(this._header, n6 + 2, byArray2, 0, n5);
            SepxNode sepxNode = new SepxNode(n9 + 1, n8, n7, byArray2);
            this._sectionTable.add(sepxNode);
        }
    }

    public void openDoc() {
        this._headerBuffer.append("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\r\n");
        this._headerBuffer.append("<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\r\n");
        this._headerBuffer.append("<fo:layout-master-set>\r\n");
    }

    private HeaderFooter findSectionHdrFtr(int n, int n2) {
        int n3;
        if (this._plcfHdd.length < 50) {
            return new HeaderFooter(0, 0, 0);
        }
        int n4 = n3 = this._fcMin + this._ccpText + this._ccpFtn;
        int n5 = 0;
        switch (n) {
            case 1: {
                n5 = HEADER_EVEN_INDEX + n2 * 6;
                break;
            }
            case 3: {
                n5 = FOOTER_EVEN_INDEX + n2 * 6;
                break;
            }
            case 2: {
                n5 = HEADER_ODD_INDEX + n2 * 6;
                break;
            }
            case 4: {
                n5 = FOOTER_ODD_INDEX + n2 * 6;
                break;
            }
            case 5: {
                n5 = HEADER_FIRST_INDEX + n2 * 6;
                break;
            }
            case 6: {
                n5 = FOOTER_FIRST_INDEX + n2 * 6;
            }
        }
        HeaderFooter headerFooter = new HeaderFooter(n, n3 += Utils.convertBytesToInt(this._plcfHdd, n5 * 4), n4 += Utils.convertBytesToInt(this._plcfHdd, (n5 + 1) * 4));
        if (n4 - n3 == 0 && n2 > 1) {
            headerFooter = this.findSectionHdrFtr(n, n2 - 1);
        }
        return headerFooter;
    }

    private void initDocProperties(byte[] byArray) {
        int n = LittleEndian.getInt(this._header, 402);
        int n2 = LittleEndian.getInt(this._header, 406);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this._docProps._fFacingPages = (byArray2[0] & 1) > 0;
        this._docProps._fpc = (byArray2[0] & 0x60) >> 5;
        short s = LittleEndian.getShort(byArray2, 2);
        this._docProps._rncFtn = s & 3;
        this._docProps._nFtn = (short)(s & 0xFFFC) >> 2;
        s = LittleEndian.getShort(byArray2, 52);
        this._docProps._rncEdn = s & 3;
        this._docProps._nEdn = (short)(s & 0xFFFC) >> 2;
        s = LittleEndian.getShort(byArray2, 54);
        this._docProps._epc = s & 3;
    }

    public void writeSection(int n, int n2, SEP sEP, BTreeSet bTreeSet, BTreeSet bTreeSet2, BTreeSet bTreeSet3, StyleSheet styleSheet) {
        HeaderFooter headerFooter = this.findSectionHdrFtr(5, this._sectionCounter);
        HeaderFooter headerFooter2 = this.findSectionHdrFtr(6, this._sectionCounter);
        HeaderFooter headerFooter3 = this.findSectionHdrFtr(2, this._sectionCounter);
        HeaderFooter headerFooter4 = this.findSectionHdrFtr(1, this._sectionCounter);
        HeaderFooter headerFooter5 = this.findSectionHdrFtr(4, this._sectionCounter);
        HeaderFooter headerFooter6 = this.findSectionHdrFtr(3, this._sectionCounter);
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (this._docProps._fFacingPages) {
            String string6;
            String string7;
            if (sEP._fTitlePage) {
                string7 = this.createRegion(true, headerFooter, sEP, "title-header" + this._sectionCounter);
                string6 = this.createRegion(false, headerFooter2, sEP, "title-footer" + this._sectionCounter);
                string = this.createPageMaster(sEP, "first", this._sectionCounter, string7, string6);
            }
            string7 = this.createRegion(true, headerFooter4, sEP, "even-header" + this._sectionCounter);
            string6 = this.createRegion(false, headerFooter6, sEP, "even-footer" + this._sectionCounter);
            string2 = this.createPageMaster(sEP, "even", this._sectionCounter, string7, string6);
            string7 = this.createRegion(true, headerFooter3, sEP, "odd-header" + this._sectionCounter);
            string6 = this.createRegion(false, headerFooter5, sEP, "odd-footer" + this._sectionCounter);
            string3 = this.createPageMaster(sEP, "odd", this._sectionCounter, string7, string6);
            string5 = this.createEvenOddPageSequence(string, string2, string3, this._sectionCounter);
            this.openPage(string5, "reference");
            if (sEP._fTitlePage) {
                if (!headerFooter.isEmpty()) {
                    this.addStaticContent("title-header" + this._sectionCounter, headerFooter);
                }
                if (!headerFooter2.isEmpty()) {
                    this.addStaticContent("title-footer" + this._sectionCounter, headerFooter2);
                }
            }
            if (!headerFooter3.isEmpty()) {
                this.addStaticContent("odd-header" + this._sectionCounter, headerFooter3);
            }
            if (!headerFooter5.isEmpty()) {
                this.addStaticContent("odd-footer" + this._sectionCounter, headerFooter5);
            }
            if (!headerFooter4.isEmpty()) {
                this.addStaticContent("even-header" + this._sectionCounter, headerFooter4);
            }
            if (!headerFooter6.isEmpty()) {
                this.addStaticContent("even-footer" + this._sectionCounter, headerFooter6);
            }
            this.openFlow();
            this.addBlockContent(n, n2, bTreeSet, bTreeSet2, bTreeSet3);
            this.closeFlow();
            this.closePage();
        } else {
            String string8 = this.createRegion(true, headerFooter3, sEP, null);
            String string9 = this.createRegion(false, headerFooter5, sEP, null);
            string4 = this.createPageMaster(sEP, "page", this._sectionCounter, string8, string9);
            if (sEP._fTitlePage) {
                string8 = this.createRegion(true, headerFooter, sEP, "title-header" + this._sectionCounter);
                string9 = this.createRegion(false, headerFooter2, sEP, "title-footer" + this._sectionCounter);
                string = this.createPageMaster(sEP, "first", this._sectionCounter, string8, string9);
                string5 = this.createPageSequence(string, string4, this._sectionCounter);
                this.openPage(string5, "reference");
                if (!headerFooter.isEmpty()) {
                    this.addStaticContent("title-header" + this._sectionCounter, headerFooter);
                }
                if (!headerFooter2.isEmpty()) {
                    this.addStaticContent("title-footer" + this._sectionCounter, headerFooter2);
                }
            } else {
                this.openPage(string4, "name");
            }
            if (!headerFooter3.isEmpty()) {
                this.addStaticContent("xsl-region-before", headerFooter3);
            }
            if (!headerFooter5.isEmpty()) {
                this.addStaticContent("xsl-region-after", headerFooter5);
            }
            this.openFlow();
            this.addBlockContent(n, n2, bTreeSet, bTreeSet2, bTreeSet3);
            this.closeFlow();
            this.closePage();
        }
        ++this._sectionCounter;
    }

    private int calculateHeaderHeight(int n, int n2, int n3) {
        int n4;
        ArrayList<PropertyNode> arrayList = this.findProperties(n, n2, this._paragraphTable.root);
        int n5 = arrayList.size();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n4 = 0; n4 < n5; ++n4) {
            PapxNode papxNode = (PapxNode)arrayList.get(n4);
            int n6 = Math.max(papxNode.getStart(), n);
            int n7 = Math.min(papxNode.getEnd(), n2);
            int n8 = 0;
            int n9 = 0;
            ArrayList<PropertyNode> arrayList3 = this.findProperties(n6, n7, this._characterTable.root);
            int n10 = arrayList3.size();
            for (int i = 0; i < n10; ++i) {
                ChpxNode chpxNode = (ChpxNode)arrayList3.get(i);
                short s = Utils.convertBytesToShort(papxNode.getPapx(), 0);
                StyleDescription styleDescription = this._styleSheet.getStyleDescription(s);
                CHP cHP = (CHP)StyleSheet.uncompressProperty(chpxNode.getChpx(), styleDescription.getCHP(), this._styleSheet);
                int n11 = 10;
                n9 = Math.max(n9, n11);
                int n12 = Math.max(n6, chpxNode.getStart());
                int n13 = Math.min(n7, chpxNode.getEnd());
                ArrayList<PropertyNode> arrayList4 = this.findProperties(n12, n13, this._text.root);
                int n14 = arrayList4.size();
                StringBuffer stringBuffer = new StringBuffer();
                for (int j = 0; j < n14; ++j) {
                    TextPiece textPiece = (TextPiece)arrayList4.get(j);
                    int n15 = Math.max(textPiece.getStart(), n12);
                    int n16 = Math.min(textPiece.getEnd(), n13);
                    if (textPiece.usesUnicode()) {
                        this.addUnicodeText(n15, n16, stringBuffer);
                        continue;
                    }
                    this.addText(n15, n16, stringBuffer);
                }
                String string = stringBuffer.toString();
                if ((n8 += 10 * string.length()) <= n3) continue;
                arrayList2.add(n9);
                n9 = 0;
                n8 = 0;
            }
            arrayList2.add(n9);
        }
        n4 = 0;
        n5 = arrayList2.size();
        for (int i = 0; i < n5; ++i) {
            Integer n17 = (Integer)arrayList2.get(i);
            n4 += n17.intValue();
        }
        return n4;
    }

    private String createRegion(boolean bl, HeaderFooter headerFooter, SEP sEP, String string) {
        if (headerFooter.isEmpty()) {
            return "";
        }
        String string2 = "region-name=\"" + string + "\"";
        if (string == null) {
            string2 = "";
        }
        int n = this.calculateHeaderHeight(headerFooter.getStart(), headerFooter.getEnd(), sEP._xaPage / 20);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string3 = null;
        String string4 = null;
        if (bl) {
            string3 = "before";
            string4 = "before";
            n2 = sEP._dyaHdrTop / 20;
            n4 = n + n2;
            sEP._dyaTop = Math.max(n4 * 20, sEP._dyaTop);
        } else {
            string3 = "after";
            string4 = "after";
            n3 = sEP._dyaHdrBottom / 20;
            n4 = n + n3;
            sEP._dyaBottom = Math.max(n4 * 20, sEP._dyaBottom);
        }
        return "<fo:region-" + string3 + " display-align=\"" + string4 + "\" extent=\"" + n4 + "pt\" " + string2 + "/>";
    }

    private String createRegion(String string, String string2) {
        return "<fo:region-" + string + " overflow=\"scroll\" region-name=\"" + string2 + "\"/>";
    }

    private String createEvenOddPageSequence(String string, String string2, String string3, int n) {
        String string4 = "my-sequence" + n;
        this._headerBuffer.append("<fo:page-sequence-master master-name=\"" + string4 + "\"> ");
        this._headerBuffer.append("<fo:repeatable-page-master-alternatives>");
        if (string != null) {
            this._headerBuffer.append("<fo:conditional-page-master-reference page-position=\"first\" master-reference=\"" + string + "\"/>");
        }
        this._headerBuffer.append("<fo:conditional-page-master-reference odd-or-even=\"odd\" ");
        this._headerBuffer.append("master-reference=\"" + string3 + "\"/> ");
        this._headerBuffer.append("<fo:conditional-page-master-reference odd-or-even=\"even\" ");
        this._headerBuffer.append("master-reference=\"" + string2 + "\"/> ");
        this._headerBuffer.append("</fo:repeatable-page-master-alternatives>");
        this._headerBuffer.append("</fo:page-sequence-master>");
        return string4;
    }

    private String createPageSequence(String string, String string2, int n) {
        String string3 = null;
        if (string != null) {
            string3 = "my-sequence" + n;
            this._headerBuffer.append("<fo:page-sequence-master master-name=\"" + string3 + "\"> ");
            this._headerBuffer.append("<fo:single-page-master-reference master-reference=\"" + string + "\"/>");
            this._headerBuffer.append("<fo:repeatable-page-master-reference master-reference=\"" + string2 + "\"/>");
            this._headerBuffer.append("</fo:page-sequence-master>");
        }
        return string3;
    }

    private void addBlockContent(int n, int n2, BTreeSet bTreeSet, BTreeSet bTreeSet2, BTreeSet bTreeSet3) {
        BTreeSet.BTreeNode bTreeNode = bTreeSet2.root;
        ArrayList<PropertyNode> arrayList = this.findProperties(n, n2, bTreeNode);
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            PapxNode papxNode = (PapxNode)arrayList.get(i);
            this.createParagraph(n, n2, papxNode, bTreeSet3, bTreeSet);
        }
    }

    private String getTextAlignment(byte by) {
        switch (by) {
            case 0: {
                return "start";
            }
            case 1: {
                return "center";
            }
            case 2: {
                return "end";
            }
            case 3: {
                return "justify";
            }
        }
        return "left";
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createParagraph(int n, int n2, PapxNode papxNode, BTreeSet bTreeSet, BTreeSet bTreeSet2) {
        PAP pAP;
        StyleDescription styleDescription;
        StringBuffer stringBuffer;
        block6: {
            stringBuffer = this._bodyBuffer;
            byte[] byArray = papxNode.getPapx();
            short s = Utils.convertBytesToShort(byArray, 0);
            styleDescription = this._styleSheet.getStyleDescription(s);
            pAP = (PAP)StyleSheet.uncompressProperty(byArray, styleDescription.getPAP(), this._styleSheet);
            if (pAP._fInTable > 0) {
                if (pAP._fTtp == 0) {
                    if (this._cellBuffer == null) {
                        this._cellBuffer = new StringBuffer();
                    }
                    stringBuffer = this._cellBuffer;
                    break block6;
                } else {
                    if (this._table == null) {
                        this._table = new ArrayList();
                    }
                    TAP tAP = (TAP)StyleSheet.uncompressProperty(byArray, new TAP(), this._styleSheet);
                    TableRow tableRow = new TableRow(this._cells, tAP);
                    this._table.add(tableRow);
                    this._cells = null;
                    return;
                }
            }
            this.printTable();
        }
        if (pAP._ilfo > 0) {
            LVL lVL = this._listTables.getLevel(pAP._ilfo, pAP._ilvl);
            this.addListParagraphContent(lVL, stringBuffer, pAP, papxNode, n, n2, styleDescription);
            return;
        }
        this.addParagraphContent(stringBuffer, pAP, papxNode, n, n2, styleDescription);
    }

    private void addListParagraphContent(LVL lVL, StringBuffer stringBuffer, PAP pAP, PapxNode papxNode, int n, int n2, StyleDescription styleDescription) {
        pAP = (PAP)StyleSheet.uncompressProperty(lVL._papx, pAP, this._styleSheet, false);
        this.addParagraphProperties(pAP, stringBuffer);
        ArrayList<PropertyNode> arrayList = this.findProperties(Math.max(papxNode.getStart(), n), Math.min(papxNode.getEnd(), n2), this._characterTable.root);
        int n3 = arrayList.size();
        CHP cHP = (CHP)StyleSheet.uncompressProperty(((ChpxNode)arrayList.get(n3 - 1)).getChpx(), styleDescription.getCHP(), this._styleSheet);
        cHP = (CHP)StyleSheet.uncompressProperty(lVL._chpx, cHP, this._styleSheet);
        int n4 = -1 * pAP._dxaLeft1;
        String string = this.getBulletText(lVL, pAP);
        if ((n4 -= string.length() * 10 * 20) > 0) {
            cHP._paddingEnd = (short)n4;
        }
        this.addCharacterProperties(cHP, stringBuffer);
        boolean bl = false;
        stringBuffer.append(string);
        switch (lVL._ixchFollow) {
            case 0: {
                this.addText('\t', stringBuffer);
                break;
            }
            case 1: {
                this.addText(' ', stringBuffer);
            }
        }
        this.closeLine(stringBuffer);
        for (int i = 0; i < n3; ++i) {
            ChpxNode chpxNode = (ChpxNode)arrayList.get(i);
            byte[] byArray = chpxNode.getChpx();
            CHP cHP2 = (CHP)StyleSheet.uncompressProperty(byArray, styleDescription.getCHP(), this._styleSheet);
            this.addCharacterProperties(cHP2, stringBuffer);
            int n5 = Math.max(chpxNode.getStart(), papxNode.getStart());
            int n6 = Math.min(chpxNode.getEnd(), papxNode.getEnd());
            ArrayList<PropertyNode> arrayList2 = this.findProperties(n5, n6, this._text.root);
            int n7 = arrayList2.size();
            for (int j = 0; j < n7; ++j) {
                TextPiece textPiece = (TextPiece)arrayList2.get(j);
                n5 = Math.max(n5, textPiece.getStart());
                n6 = Math.min(n6, textPiece.getEnd());
                if (textPiece.usesUnicode()) {
                    this.addUnicodeText(n5, n6, stringBuffer);
                } else {
                    this.addText(n5, n6, stringBuffer);
                }
                this.closeLine(stringBuffer);
            }
        }
        this.closeBlock(stringBuffer);
    }

    private void addParagraphContent(StringBuffer stringBuffer, PAP pAP, PapxNode papxNode, int n, int n2, StyleDescription styleDescription) {
        this.addParagraphProperties(pAP, stringBuffer);
        ArrayList<PropertyNode> arrayList = this.findProperties(Math.max(papxNode.getStart(), n), Math.min(papxNode.getEnd(), n2), this._characterTable.root);
        int n3 = arrayList.size();
        for (int i = 0; i < n3; ++i) {
            ChpxNode chpxNode = (ChpxNode)arrayList.get(i);
            byte[] byArray = chpxNode.getChpx();
            CHP cHP = (CHP)StyleSheet.uncompressProperty(byArray, styleDescription.getCHP(), this._styleSheet);
            this.addCharacterProperties(cHP, stringBuffer);
            int n4 = Math.max(chpxNode.getStart(), papxNode.getStart());
            int n5 = Math.min(chpxNode.getEnd(), papxNode.getEnd());
            ArrayList<PropertyNode> arrayList2 = this.findProperties(n4, n5, this._text.root);
            int n6 = arrayList2.size();
            for (int j = 0; j < n6; ++j) {
                TextPiece textPiece = (TextPiece)arrayList2.get(j);
                n4 = Math.max(n4, textPiece.getStart());
                n5 = Math.min(n5, textPiece.getEnd());
                if (textPiece.usesUnicode()) {
                    this.addUnicodeText(n4, n5, stringBuffer);
                } else {
                    this.addText(n4, n5, stringBuffer);
                }
                this.closeLine(stringBuffer);
            }
        }
        this.closeBlock(stringBuffer);
    }

    private void addText(int n, int n2, StringBuffer stringBuffer) {
        for (int i = n; i < n2; ++i) {
            char c = '?';
            c = (char)this._header[i];
            this.addText(c, stringBuffer);
        }
    }

    private void addText(char c, StringBuffer stringBuffer) {
        int n = 0xFFFF & c;
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == ' ' || c == '-' || c == '.' || c == '$') {
            stringBuffer.append(c);
        } else if (n == 7 && this._cellBuffer != null) {
            if (this._cells == null) {
                this._cells = new ArrayList();
            }
            this.closeLine(this._cellBuffer);
            this.closeBlock(this._cellBuffer);
            this._cells.add(this._cellBuffer.toString());
            this._cellBuffer = null;
        } else {
            if (n < 32) {
                n = 32;
            }
            stringBuffer.append("&#");
            stringBuffer.append(n);
            stringBuffer.append(';');
        }
    }

    private void addUnicodeText(int n, int n2, StringBuffer stringBuffer) {
        for (int i = n; i < n2; i += 2) {
            char c = Utils.getUnicodeCharacter(this._header, i);
            this.addText(c, stringBuffer);
        }
    }

    private void addParagraphProperties(PAP pAP, StringBuffer stringBuffer) {
        stringBuffer.append("<fo:block ");
        stringBuffer.append("text-align=\"" + this.getTextAlignment(pAP._jc) + "\"\r\n");
        stringBuffer.append("linefeed-treatment=\"preserve\" ");
        stringBuffer.append("white-space-collapse=\"false\" ");
        if (pAP._fKeep > 0) {
            stringBuffer.append("keep-together.within-page=\"always\"\r\n");
        }
        if (pAP._fKeepFollow > 0) {
            stringBuffer.append("keep-with-next.within-page=\"always\"\r\n");
        }
        if (pAP._fPageBreakBefore > 0) {
            stringBuffer.append("break-before=\"page\"\r\n");
        }
        if (pAP._fNoAutoHyph == 0) {
            stringBuffer.append("hyphenate=\"true\"\r\n");
        } else {
            stringBuffer.append("hyphenate=\"false\"\r\n");
        }
        if (pAP._dxaLeft > 0) {
            stringBuffer.append("start-indent=\"" + (float)pAP._dxaLeft / 1440.0f + "in\"\r\n");
        }
        if (pAP._dxaRight > 0) {
            stringBuffer.append("end-indent=\"" + (float)pAP._dxaRight / 1440.0f + "in\"\r\n");
        }
        if (pAP._dxaLeft1 != 0) {
            stringBuffer.append("text-indent=\"" + (float)pAP._dxaLeft1 / 1440.0f + "in\"\r\n");
        }
        if (pAP._lspd[1] == 0) {
            // empty if block
        }
        this.addBorder(stringBuffer, pAP._brcTop, "top");
        this.addBorder(stringBuffer, pAP._brcBottom, "bottom");
        this.addBorder(stringBuffer, pAP._brcLeft, "left");
        this.addBorder(stringBuffer, pAP._brcRight, "right");
        stringBuffer.append(">");
    }

    private void addCharacterProperties(CHP cHP, StringBuffer stringBuffer) {
        stringBuffer.append("<fo:inline ");
        stringBuffer.append("font-family=\"" + this._fonts.getFont(cHP._ftcAscii) + "\" ");
        stringBuffer.append("font-size=\"" + cHP._hps / 2 + "pt\" ");
        stringBuffer.append("color=\"" + this.getColor(cHP._ico) + "\" ");
        this.addBorder(stringBuffer, cHP._brc, "top");
        this.addBorder(stringBuffer, cHP._brc, "bottom");
        this.addBorder(stringBuffer, cHP._brc, "left");
        this.addBorder(stringBuffer, cHP._brc, "right");
        if (cHP._italic) {
            stringBuffer.append("font-style=\"italic\" ");
        }
        if (cHP._bold) {
            stringBuffer.append("font-weight=\"bold\" ");
        }
        if (cHP._fSmallCaps) {
            stringBuffer.append("font-variant=\"small-caps\" ");
        }
        if (cHP._fCaps) {
            stringBuffer.append("text-transform=\"uppercase\" ");
        }
        if (cHP._fStrike || cHP._fDStrike) {
            stringBuffer.append("text-decoration=\"line-through\" ");
        }
        if (cHP._fShadow) {
            int n = cHP._hps / 24;
            stringBuffer.append("text-shadow=\"" + n + "pt\"");
        }
        if (cHP._fLowerCase) {
            stringBuffer.append("text-transform=\"lowercase\" ");
        }
        if (cHP._kul > 0) {
            stringBuffer.append("text-decoration=\"underline\" ");
        }
        if (cHP._highlighted) {
            stringBuffer.append("background-color=\"" + this.getColor(cHP._icoHighlight) + "\" ");
        }
        if (cHP._paddingStart != 0) {
            stringBuffer.append("padding-start=\"" + (float)cHP._paddingStart / 1440.0f + "in\" ");
        }
        if (cHP._paddingEnd != 0) {
            stringBuffer.append("padding-end=\"" + (float)cHP._paddingEnd / 1440.0f + "in\" ");
        }
        stringBuffer.append(">");
    }

    private void addStaticContent(String string, HeaderFooter headerFooter) {
        this._bodyBuffer.append("<fo:static-content flow-name=\"" + string + "\">");
        this.addBlockContent(headerFooter.getStart(), headerFooter.getEnd(), this._text, this._paragraphTable, this._characterTable);
        this._bodyBuffer.append("</fo:static-content>");
    }

    private String getBulletText(LVL lVL, PAP pAP) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lVL._xst.length; ++i) {
            if (lVL._xst[i] < '\t') {
                LVL lVL2 = this._listTables.getLevel(pAP._ilfo, lVL._xst[i]);
                int n = lVL2._iStartAt++;
                if (lVL != lVL2 && n > 1) {
                    --n;
                }
                stringBuffer.append(NumberFormatter.getNumber(n, lVL._nfc));
                continue;
            }
            stringBuffer.append(lVL._xst[i]);
        }
        return stringBuffer.toString();
    }

    private ArrayList<PropertyNode> findProperties(int n, int n2, BTreeSet.BTreeNode bTreeNode) {
        ArrayList<PropertyNode> arrayList = new ArrayList<PropertyNode>();
        BTreeSet.Entry[] entryArray = bTreeNode._entries;
        for (int i = 0; i < entryArray.length && entryArray[i] != null; ++i) {
            BTreeSet.BTreeNode bTreeNode2 = entryArray[i].child;
            PropertyNode propertyNode = (PropertyNode)entryArray[i].element;
            if (propertyNode != null) {
                ArrayList<PropertyNode> arrayList2;
                int n3 = propertyNode.getStart();
                int n4 = propertyNode.getEnd();
                if (n3 < n2) {
                    if (n3 >= n) {
                        if (bTreeNode2 != null) {
                            arrayList2 = this.findProperties(n, n2, bTreeNode2);
                            arrayList.addAll(arrayList2);
                        }
                        arrayList.add(propertyNode);
                        continue;
                    }
                    if (n >= n4) continue;
                    arrayList.add(propertyNode);
                    continue;
                }
                if (bTreeNode2 == null) break;
                arrayList2 = this.findProperties(n, n2, bTreeNode2);
                arrayList.addAll(arrayList2);
                break;
            }
            if (bTreeNode2 == null) continue;
            ArrayList<PropertyNode> arrayList3 = this.findProperties(n, n2, bTreeNode2);
            arrayList.addAll(arrayList3);
        }
        return arrayList;
    }

    private void openPage(String string, String string2) {
        this._bodyBuffer.append("<fo:page-sequence master-reference=\"" + string + "\">\r\n");
    }

    private void openFlow() {
        this._bodyBuffer.append("<fo:flow flow-name=\"xsl-region-body\">\r\n");
    }

    private void closeFlow() {
        this._bodyBuffer.append("</fo:flow>\r\n");
    }

    private void closePage() {
        this._bodyBuffer.append("</fo:page-sequence>\r\n");
    }

    private void closeLine(StringBuffer stringBuffer) {
        stringBuffer.append("</fo:inline>");
    }

    private void closeBlock(StringBuffer stringBuffer) {
        stringBuffer.append("</fo:block>\r\n");
    }

    private ArrayList<PropertyNode> findPAPProperties(int n, int n2, BTreeSet.BTreeNode bTreeNode) {
        ArrayList<PropertyNode> arrayList = new ArrayList<PropertyNode>();
        BTreeSet.Entry[] entryArray = bTreeNode._entries;
        for (int i = 0; i < entryArray.length && entryArray[i] != null; ++i) {
            BTreeSet.BTreeNode bTreeNode2 = entryArray[i].child;
            PapxNode papxNode = (PapxNode)entryArray[i].element;
            if (papxNode != null) {
                ArrayList<PropertyNode> arrayList2;
                int n3 = papxNode.getStart();
                if (n3 < n2) {
                    if (n3 < n) continue;
                    if (bTreeNode2 != null) {
                        arrayList2 = this.findPAPProperties(n, n2, bTreeNode2);
                        arrayList.addAll(arrayList2);
                    }
                    arrayList.add(papxNode);
                    continue;
                }
                if (bTreeNode2 == null) break;
                arrayList2 = this.findPAPProperties(n, n2, bTreeNode2);
                arrayList.addAll(arrayList2);
                break;
            }
            if (bTreeNode2 == null) continue;
            ArrayList<PropertyNode> arrayList3 = this.findPAPProperties(n, n2, bTreeNode2);
            arrayList.addAll(arrayList3);
        }
        return arrayList;
    }

    private String createPageMaster(SEP sEP, String string, int n, String string2, String string3) {
        float f = (float)sEP._yaPage / 1440.0f;
        float f2 = (float)sEP._xaPage / 1440.0f;
        float f3 = (float)sEP._dxaLeft / 1440.0f;
        float f4 = (float)sEP._dxaRight / 1440.0f;
        float f5 = (float)sEP._dyaTop / 1440.0f;
        float f6 = (float)sEP._dyaBottom / 1440.0f;
        String string4 = string + "-page" + n;
        this._headerBuffer.append("<fo:simple-page-master master-name=\"" + string4 + "\"\r\n");
        this._headerBuffer.append("page-height=\"" + f + "in\"\r\n");
        this._headerBuffer.append("page-width=\"" + f2 + "in\"\r\n");
        this._headerBuffer.append(">\r\n");
        this._headerBuffer.append("<fo:region-body ");
        this._headerBuffer.append("margin=\"" + f5 + "in " + f4 + "in " + f6 + "in " + f3 + "in\"\r\n");
        this.addBorder(this._headerBuffer, sEP._brcTop, "top");
        this.addBorder(this._headerBuffer, sEP._brcBottom, "bottom");
        this.addBorder(this._headerBuffer, sEP._brcLeft, "left");
        this.addBorder(this._headerBuffer, sEP._brcRight, "right");
        if (sEP._ccolM1 > 0) {
            this._headerBuffer.append("column-count=\"" + (sEP._ccolM1 + 1) + "\" ");
            if (sEP._fEvenlySpaced) {
                this._headerBuffer.append("column-gap=\"" + (float)sEP._dxaColumns / 1440.0f + "in\"");
            } else {
                this._headerBuffer.append("column-gap=\"0.25in\"");
            }
        }
        this._headerBuffer.append("/>\r\n");
        if (string2 != null) {
            this._headerBuffer.append(string2);
        }
        if (string3 != null) {
            this._headerBuffer.append(string3);
        }
        this._headerBuffer.append("</fo:simple-page-master>\r\n");
        return string4;
    }

    private void addBorder(StringBuffer stringBuffer, short[] sArray, String string) {
        if ((sArray[0] & 0xFF00) != 0 && sArray[0] != -1) {
            float f = (float)(sArray[0] & 0xFF) / 8.0f;
            String string2 = this.getBorderStyle(sArray[0]);
            String string3 = this.getColor(sArray[1] & 0xFF);
            stringBuffer.append("border-" + string + "-style=\"" + string2 + "\"\r\n");
            stringBuffer.append("border-" + string + "-color=\"" + string3 + "\"\r\n");
            stringBuffer.append("border-" + string + "-width=\"" + f + "pt\"\r\n");
        }
    }

    public void closeDoc() {
        this._headerBuffer.append("</fo:layout-master-set>");
        this._bodyBuffer.append("</fo:root>");
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(_outName), "8859_1");
            outputStreamWriter.write(this._headerBuffer.toString());
            outputStreamWriter.write(this._bodyBuffer.toString());
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getColor(int n) {
        switch (n) {
            case 1: {
                return "black";
            }
            case 2: {
                return "blue";
            }
            case 3: {
                return "cyan";
            }
            case 4: {
                return "green";
            }
            case 5: {
                return "magenta";
            }
            case 6: {
                return "red";
            }
            case 7: {
                return "yellow";
            }
            case 8: {
                return "white";
            }
            case 9: {
                return "darkblue";
            }
            case 10: {
                return "darkcyan";
            }
            case 11: {
                return "darkgreen";
            }
            case 12: {
                return "darkmagenta";
            }
            case 13: {
                return "darkred";
            }
            case 14: {
                return "darkyellow";
            }
            case 15: {
                return "darkgray";
            }
            case 16: {
                return "lightgray";
            }
        }
        return "black";
    }

    private String getBorderStyle(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return "solid";
            }
            case 3: {
                return "double";
            }
            case 5: {
                return "solid";
            }
            case 6: {
                return "dotted";
            }
            case 7: 
            case 8: {
                return "dashed";
            }
            case 9: {
                return "dotted";
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return "double";
            }
            case 20: {
                return "solid";
            }
            case 21: {
                return "double";
            }
            case 22: {
                return "dashed";
            }
            case 23: {
                return "dashed";
            }
            case 24: {
                return "ridge";
            }
            case 25: {
                return "grooved";
            }
        }
        return "solid";
    }

    private void createListTables(byte[] byArray) {
        int n = LittleEndian.getInt(this._header, 746);
        int n2 = LittleEndian.getInt(this._header, 750);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        int n3 = LittleEndian.getInt(this._header, 738);
        int n4 = LittleEndian.getInt(this._header, 738);
        if (n3 > 0 && n4 > 0) {
            n4 = n - n3;
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray, n3, byArray3, 0, n4);
            this._listTables = new ListTables(byArray3, byArray2);
        }
    }

    private void createStyleSheet(byte[] byArray) {
        int n = LittleEndian.getInt(this._header, 162);
        int n2 = LittleEndian.getInt(this._header, 166);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this._styleSheet = new StyleSheet(byArray2);
    }

    private void createFontTable(byte[] byArray) {
        int n = LittleEndian.getInt(this._header, 274);
        int n2 = LittleEndian.getInt(this._header, 278);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this._fonts = new FontTable(byArray2);
    }

    private void overrideCellBorder(int n, int n2, int n3, int n4, TC tC, TAP tAP) {
        if (n == 0) {
            if (tC._brcTop[0] == 0 || tC._brcTop[0] == -1) {
                tC._brcTop = tAP._brcTop;
            }
            if (tC._brcBottom[0] == 0 || tC._brcBottom[0] == -1) {
                tC._brcBottom = tAP._brcHorizontal;
            }
        } else if (n == n3 - 1) {
            if (tC._brcTop[0] == 0 || tC._brcTop[0] == -1) {
                tC._brcTop = tAP._brcHorizontal;
            }
            if (tC._brcBottom[0] == 0 || tC._brcBottom[0] == -1) {
                tC._brcBottom = tAP._brcBottom;
            }
        } else {
            if (tC._brcTop[0] == 0 || tC._brcTop[0] == -1) {
                tC._brcTop = tAP._brcHorizontal;
            }
            if (tC._brcBottom[0] == 0 || tC._brcBottom[0] == -1) {
                tC._brcBottom = tAP._brcHorizontal;
            }
        }
        if (n2 == 0) {
            if (tC._brcLeft[0] == 0 || tC._brcLeft[0] == -1) {
                tC._brcLeft = tAP._brcLeft;
            }
            if (tC._brcRight[0] == 0 || tC._brcRight[0] == -1) {
                tC._brcRight = tAP._brcVertical;
            }
        } else if (n2 == n4 - 1) {
            if (tC._brcLeft[0] == 0 || tC._brcLeft[0] == -1) {
                tC._brcLeft = tAP._brcVertical;
            }
            if (tC._brcRight[0] == 0 || tC._brcRight[0] == -1) {
                tC._brcRight = tAP._brcRight;
            }
        } else {
            if (tC._brcLeft[0] == 0 || tC._brcLeft[0] == -1) {
                tC._brcLeft = tAP._brcVertical;
            }
            if (tC._brcRight[0] == 0 || tC._brcRight[0] == -1) {
                tC._brcRight = tAP._brcVertical;
            }
        }
    }

    private void printTable() {
        if (this._table != null) {
            int n = this._table.size();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                StringBuffer stringBuffer3 = stringBuffer2;
                TableRow tableRow = this._table.get(i);
                TAP tAP = tableRow.getTAP();
                ArrayList<String> arrayList = tableRow.getCells();
                if (tAP._fTableHeader) {
                    stringBuffer3 = stringBuffer;
                }
                stringBuffer3.append("<fo:table-row ");
                if (tAP._dyaRowHeight > 0) {
                    stringBuffer3.append("height=\"" + (float)tAP._dyaRowHeight / 1440.0f + "in\" ");
                }
                if (tAP._fCantSplit) {
                    stringBuffer3.append("keep-together=\"always\" ");
                }
                stringBuffer3.append(">");
                for (int j = 0; j < tAP._itcMac; ++j) {
                    TC tC = tAP._rgtc[j];
                    this.overrideCellBorder(i, j, n, tAP._itcMac, tC, tAP);
                    stringBuffer3.append("<fo:table-cell ");
                    stringBuffer3.append("width=\"" + (float)(tAP._rgdxaCenter[j + 1] - tAP._rgdxaCenter[j]) / 1440.0f + "in\" ");
                    stringBuffer3.append("padding-start=\"" + (float)tAP._dxaGapHalf / 1440.0f + "in\" ");
                    stringBuffer3.append("padding-end=\"" + (float)tAP._dxaGapHalf / 1440.0f + "in\" ");
                    this.addBorder(stringBuffer3, tC._brcTop, "top");
                    this.addBorder(stringBuffer3, tC._brcLeft, "left");
                    this.addBorder(stringBuffer3, tC._brcBottom, "bottom");
                    this.addBorder(stringBuffer3, tC._brcRight, "right");
                    stringBuffer3.append(">");
                    stringBuffer3.append(arrayList.get(j));
                    stringBuffer3.append("</fo:table-cell>");
                }
                stringBuffer3.append("</fo:table-row>");
            }
            StringBuffer stringBuffer4 = new StringBuffer();
            stringBuffer4.append("<fo:table>");
            if (stringBuffer.length() > 0) {
                stringBuffer4.append("<fo:table-header>");
                stringBuffer4.append(stringBuffer.toString());
                stringBuffer4.append("</fo:table-header>");
            }
            stringBuffer4.append("<fo:table-body>");
            stringBuffer4.append(stringBuffer2.toString());
            stringBuffer4.append("</fo:table-body>");
            stringBuffer4.append("</fo:table>");
            this._bodyBuffer.append(stringBuffer4.toString());
            this._table = null;
        }
    }

    private void initPclfHdd(byte[] byArray) {
        int n = Utils.convertBytesToInt(this._header, 246);
        int n2 = Utils.convertBytesToInt(this._header, 242);
        this._plcfHdd = new byte[n];
        System.arraycopy(byArray, n2, this._plcfHdd, 0, n);
    }

    static {
        HEADER_EVEN_INDEX = 0;
        HEADER_ODD_INDEX = 1;
        FOOTER_EVEN_INDEX = 2;
        FOOTER_ODD_INDEX = 3;
        HEADER_FIRST_INDEX = 4;
        FOOTER_FIRST_INDEX = 5;
    }
}

