/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdf.extractor;

import ai2.org.apache.poi.hdf.extractor.PropertySet;
import ai2.org.apache.poi.hdf.extractor.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public final class NewOleFile
extends RandomAccessFile {
    private byte[] LAOLA_ID_ARRAY = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private int _num_bbd_blocks;
    private int _root_startblock;
    private int _sbd_startblock;
    private long _size;
    private int[] _bbd_list;
    protected int[] _big_block_depot;
    protected int[] _small_block_depot;
    Map<String, PropertySet> _propertySetsHT = new HashMap<String, PropertySet>();
    List<PropertySet> _propertySetsV = new ArrayList<PropertySet>();

    public NewOleFile(String string, String string2) throws FileNotFoundException {
        super(string, string2);
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws IOException {
        int n;
        for (n = 0; n < this.LAOLA_ID_ARRAY.length; ++n) {
            if (this.LAOLA_ID_ARRAY[n] == this.readByte()) continue;
            throw new IOException("Not an OLE file");
        }
        this._size = this.length();
        this._num_bbd_blocks = this.readInt(44L);
        this._root_startblock = this.readInt(48L);
        this._sbd_startblock = this.readInt(60L);
        this._bbd_list = new int[this._num_bbd_blocks];
        if (this._num_bbd_blocks <= 109) {
            this.seek(76L);
            for (n = 0; n < this._num_bbd_blocks; ++n) {
                this._bbd_list[n] = this.readIntLE();
            }
        } else {
            this.populateBbdList();
        }
        this._big_block_depot = new int[this._num_bbd_blocks * 128];
        n = 0;
        for (int i = 0; i < this._num_bbd_blocks; ++i) {
            int n2 = (this._bbd_list[i] + 1) * 512;
            this.seek(n2);
            for (int j = 0; j < 128; ++j) {
                this._big_block_depot[n++] = this.readIntLE();
            }
        }
        this._small_block_depot = this.createSmallBlockDepot();
        int[] nArray = this.readChain(this._big_block_depot, this._root_startblock);
        this.initializePropertySets(nArray);
    }

    public static void main(String[] stringArray) throws Exception {
        NewOleFile newOleFile = new NewOleFile(stringArray[0], "r");
        newOleFile.close();
    }

    protected int[] readChain(int[] nArray, int n) {
        int n2;
        int[] nArray2 = new int[nArray.length];
        nArray2[0] = n;
        int n3 = 1;
        while ((n2 = nArray[nArray2[n3 - 1]]) != -2) {
            nArray2[n3] = n2;
            ++n3;
        }
        int[] nArray3 = new int[n3];
        System.arraycopy(nArray2, 0, nArray3, 0, n3);
        return nArray3;
    }

    private void initializePropertySets(int[] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            int n = (nArray[i] + 1) * 512;
            this.seek(n);
            for (int j = 0; j < 4; ++j) {
                int n2;
                byte[] byArray = new byte[128];
                this.read(byArray);
                int n3 = Utils.convertBytesToShort(byArray[65], byArray[64]) / 2 - 1;
                if (n3 <= 0) continue;
                StringBuffer stringBuffer = new StringBuffer(n3);
                for (n2 = 0; n2 < n3; ++n2) {
                    stringBuffer.append((char)byArray[n2 * 2]);
                }
                n2 = byArray[66];
                int n4 = Utils.convertBytesToInt(byArray[71], byArray[70], byArray[69], byArray[68]);
                int n5 = Utils.convertBytesToInt(byArray[75], byArray[74], byArray[73], byArray[72]);
                int n6 = Utils.convertBytesToInt(byArray[79], byArray[78], byArray[77], byArray[76]);
                int n7 = Utils.convertBytesToInt(byArray[119], byArray[118], byArray[117], byArray[116]);
                int n8 = Utils.convertBytesToInt(byArray[123], byArray[122], byArray[121], byArray[120]);
                PropertySet propertySet = new PropertySet(stringBuffer.toString(), n2, n4, n5, n6, n7, n8, i * 4 + j);
                this._propertySetsHT.put(stringBuffer.toString(), propertySet);
                this._propertySetsV.add(propertySet);
            }
        }
    }

    private int[] createSmallBlockDepot() throws IOException {
        int[] nArray = this.readChain(this._big_block_depot, this._sbd_startblock);
        int[] nArray2 = new int[nArray.length * 128];
        for (int i = 0; i < nArray.length && nArray[i] != -2; ++i) {
            int n = (nArray[i] + 1) * 512;
            this.seek(n);
            for (int j = 0; j < 128; ++j) {
                nArray2[j] = this.readIntLE();
            }
        }
        return nArray2;
    }

    private void populateBbdList() throws IOException {
        int n;
        this.seek(76L);
        for (n = 0; n < 109; ++n) {
            this._bbd_list[n] = this.readIntLE();
        }
        n = 109;
        int n2 = this._num_bbd_blocks - 109;
        this.seek(72L);
        int n3 = this.readIntLE();
        this.seek(68L);
        int n4 = this.readIntLE();
        n4 = (n4 + 1) * 512;
        for (int i = 0; i < n3; ++i) {
            int n5 = Math.min(127, n2);
            for (int j = 0; j < n5; ++j) {
                this.seek(n4 + j * 4);
                this._bbd_list[n++] = this.readIntLE();
            }
            if (n5 != 127) continue;
            this.seek(n4 + 508);
            n4 = this.readIntLE();
            n4 = (n4 + 1) * 512;
            n2 -= 127;
        }
    }

    private int readInt(long l) throws IOException {
        this.seek(l);
        return this.readIntLE();
    }

    private int readIntLE() throws IOException {
        byte[] byArray = new byte[4];
        this.read(byArray);
        return Utils.convertBytesToInt(byArray[3], byArray[2], byArray[1], byArray[0]);
    }
}

