/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hdf.event;

import ai2.org.apache.poi.hdf.event.HDFLowLevelParsingListener;
import ai2.org.apache.poi.hdf.event.HDFParsingListener;
import ai2.org.apache.poi.hdf.model.hdftypes.CharacterProperties;
import ai2.org.apache.poi.hdf.model.hdftypes.ChpxNode;
import ai2.org.apache.poi.hdf.model.hdftypes.DocumentProperties;
import ai2.org.apache.poi.hdf.model.hdftypes.FontTable;
import ai2.org.apache.poi.hdf.model.hdftypes.HeaderFooter;
import ai2.org.apache.poi.hdf.model.hdftypes.LVL;
import ai2.org.apache.poi.hdf.model.hdftypes.ListTables;
import ai2.org.apache.poi.hdf.model.hdftypes.PapxNode;
import ai2.org.apache.poi.hdf.model.hdftypes.ParagraphProperties;
import ai2.org.apache.poi.hdf.model.hdftypes.PropertyNode;
import ai2.org.apache.poi.hdf.model.hdftypes.SectionProperties;
import ai2.org.apache.poi.hdf.model.hdftypes.SepxNode;
import ai2.org.apache.poi.hdf.model.hdftypes.StyleDescription;
import ai2.org.apache.poi.hdf.model.hdftypes.StyleSheet;
import ai2.org.apache.poi.hdf.model.hdftypes.TableProperties;
import ai2.org.apache.poi.hdf.model.hdftypes.TextPiece;
import ai2.org.apache.poi.hdf.model.util.BTreeSet;
import ai2.org.apache.poi.hdf.model.util.NumberFormatter;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public final class EventBridge
implements HDFLowLevelParsingListener {
    private static int HEADER_EVEN_INDEX = 0;
    private static int HEADER_ODD_INDEX = 1;
    private static int FOOTER_EVEN_INDEX = 2;
    private static int FOOTER_ODD_INDEX = 3;
    private static int HEADER_FIRST_INDEX = 4;
    private static int FOOTER_FIRST_INDEX = 5;
    HDFParsingListener _listener;
    StyleSheet _stsh;
    DocumentProperties _dop;
    StyleDescription _currentStd;
    ListTables _listTables;
    byte[] _mainDocument;
    byte[] _tableStream;
    int _fcMin;
    int _ccpText;
    int _ccpFtn;
    int _hdrSize;
    int _hdrOffset;
    BTreeSet _text = new BTreeSet();
    private boolean _beginHeaders;
    BTreeSet _hdrSections = new BTreeSet();
    BTreeSet _hdrParagraphs = new BTreeSet();
    BTreeSet _hdrCharacterRuns = new BTreeSet();
    int _sectionCounter = 1;
    List<HeaderFooter[]> _hdrs = new ArrayList<HeaderFooter[]>();
    private boolean _holdParagraph = false;
    private int _endHoldIndex = -1;
    private List<PropertyNode> _onHold;

    public EventBridge(HDFParsingListener hDFParsingListener) {
        this._listener = hDFParsingListener;
    }

    @Override
    public void mainDocument(byte[] byArray) {
        this._mainDocument = byArray;
    }

    @Override
    public void tableStream(byte[] byArray) {
        this._tableStream = byArray;
    }

    @Override
    public void miscellaneous(int n, int n2, int n3, int n4, int n5) {
        this._fcMin = n;
        this._ccpText = n2;
        this._ccpFtn = n3;
        this._hdrOffset = n4;
        this._hdrSize = n5;
    }

    @Override
    public void document(DocumentProperties documentProperties) {
        this._dop = documentProperties;
    }

    @Override
    public void bodySection(SepxNode sepxNode) {
        SectionProperties sectionProperties = (SectionProperties)StyleSheet.uncompressProperty(sepxNode.getSepx(), new SectionProperties(), this._stsh);
        HeaderFooter[] headerFooterArray = this.findSectionHdrFtrs(this._sectionCounter);
        this._hdrs.add(headerFooterArray);
        this._listener.section(sectionProperties, sepxNode.getStart() - this._fcMin, sepxNode.getEnd() - this._fcMin);
        ++this._sectionCounter;
    }

    @Override
    public void hdrSection(SepxNode sepxNode) {
        this._beginHeaders = true;
        this._hdrSections.add(sepxNode);
    }

    @Override
    public void endSections() {
        for (int i = 1; i < this._sectionCounter; ++i) {
            HeaderFooter[] headerFooterArray = this._hdrs.get(i - 1);
            HeaderFooter headerFooter = null;
            if (!headerFooterArray[0].isEmpty()) {
                headerFooter = headerFooterArray[0];
                this._listener.header(i - 1, 1);
                this.flushHeaderProps(headerFooter.getStart(), headerFooter.getEnd());
            }
            if (!headerFooterArray[1].isEmpty()) {
                headerFooter = headerFooterArray[1];
                this._listener.header(i - 1, 2);
                this.flushHeaderProps(headerFooter.getStart(), headerFooter.getEnd());
            }
            if (!headerFooterArray[2].isEmpty()) {
                headerFooter = headerFooterArray[2];
                this._listener.footer(i - 1, 3);
                this.flushHeaderProps(headerFooter.getStart(), headerFooter.getEnd());
            }
            if (!headerFooterArray[3].isEmpty()) {
                headerFooter = headerFooterArray[2];
                this._listener.footer(i - 1, 3);
                this.flushHeaderProps(headerFooter.getStart(), headerFooter.getEnd());
            }
            if (!headerFooterArray[4].isEmpty()) {
                headerFooter = headerFooterArray[4];
                this._listener.header(i - 1, 5);
                this.flushHeaderProps(headerFooter.getStart(), headerFooter.getEnd());
            }
            if (headerFooterArray[5].isEmpty()) continue;
            headerFooter = headerFooterArray[5];
            this._listener.footer(i - 1, 6);
            this.flushHeaderProps(headerFooter.getStart(), headerFooter.getEnd());
        }
    }

    @Override
    public void paragraph(PapxNode papxNode) {
        if (this._beginHeaders) {
            this._hdrParagraphs.add(papxNode);
        }
        byte[] byArray = papxNode.getPapx();
        short s = LittleEndian.getShort(byArray, 0);
        this._currentStd = this._stsh.getStyleDescription(s);
        ParagraphProperties paragraphProperties = (ParagraphProperties)StyleSheet.uncompressProperty(byArray, this._currentStd.getPAP(), this._stsh);
        if (paragraphProperties.getFTtp() > 0) {
            TableProperties tableProperties = (TableProperties)StyleSheet.uncompressProperty(byArray, new TableProperties(), this._stsh);
            this._listener.tableRowEnd(tableProperties, papxNode.getStart() - this._fcMin, papxNode.getEnd() - this._fcMin);
        } else if (paragraphProperties.getIlfo() > 0) {
            this._holdParagraph = true;
            this._endHoldIndex = papxNode.getEnd();
            this._onHold.add(papxNode);
        } else {
            this._listener.paragraph(paragraphProperties, papxNode.getStart() - this._fcMin, papxNode.getEnd() - this._fcMin);
        }
    }

    @Override
    public void characterRun(ChpxNode chpxNode) {
        if (this._beginHeaders) {
            this._hdrCharacterRuns.add(chpxNode);
        }
        int n = chpxNode.getStart();
        int n2 = chpxNode.getEnd();
        if (this._holdParagraph) {
            this._onHold.add(chpxNode);
            if (n2 >= this._endHoldIndex) {
                this._holdParagraph = false;
                this._endHoldIndex = -1;
                this.flushHeldParagraph();
                this._onHold = new ArrayList<PropertyNode>();
            }
        }
        byte[] byArray = chpxNode.getChpx();
        CharacterProperties characterProperties = (CharacterProperties)StyleSheet.uncompressProperty(byArray, this._currentStd.getCHP(), this._stsh);
        List<PropertyNode> list = BTreeSet.findProperties(n, n2, this._text.root);
        String string = this.getTextFromNodes(list, n, n2);
        this._listener.characterRun(characterProperties, string, n - this._fcMin, n2 - this._fcMin);
    }

    @Override
    public void text(TextPiece textPiece) {
        this._text.add(textPiece);
    }

    @Override
    public void fonts(FontTable fontTable) {
    }

    @Override
    public void lists(ListTables listTables) {
        this._listTables = listTables;
    }

    @Override
    public void styleSheet(StyleSheet styleSheet) {
        this._stsh = styleSheet;
    }

    private void flushHeaderProps(int n, int n2) {
        List<PropertyNode> list = BTreeSet.findProperties(n, n2, this._hdrSections.root);
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            SepxNode sepxNode = (SepxNode)list.get(i);
            int n4 = Math.max(sepxNode.getStart(), n);
            int n5 = Math.min(sepxNode.getEnd(), n2);
            List<PropertyNode> list2 = BTreeSet.findProperties(n4, n5, this._hdrParagraphs.root);
            int n6 = list2.size();
            for (int j = 0; j < n6; ++j) {
                PapxNode papxNode = (PapxNode)list2.get(j);
                int n7 = Math.max(papxNode.getStart(), n4);
                int n8 = Math.min(papxNode.getEnd(), n5);
                PapxNode papxNode2 = new PapxNode(n7, n8, papxNode.getPapx());
                this.paragraph(papxNode2);
                List<PropertyNode> list3 = BTreeSet.findProperties(n7, n8, this._hdrCharacterRuns.root);
                int n9 = list3.size();
                for (int k = 0; k < n9; ++k) {
                    ChpxNode chpxNode = (ChpxNode)list3.get(k);
                    int n10 = Math.max(chpxNode.getStart(), n7);
                    int n11 = Math.min(chpxNode.getEnd(), n8);
                    ChpxNode chpxNode2 = new ChpxNode(n10, n11, chpxNode.getChpx());
                    this.characterRun(chpxNode2);
                }
            }
        }
    }

    private String getTextFromNodes(List<PropertyNode> list, int n, int n2) {
        int n3 = list.size();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n3; ++i) {
            int n4;
            TextPiece textPiece = (TextPiece)list.get(i);
            int n5 = Math.max(n, textPiece.getStart());
            int n6 = Math.min(n2, textPiece.getEnd());
            if (textPiece.usesUnicode()) {
                for (n4 = n5; n4 < n6; n4 += 2) {
                    stringBuffer.append((char)LittleEndian.getShort(this._mainDocument, n4));
                }
                continue;
            }
            for (n4 = n5; n4 < n6; ++n4) {
                stringBuffer.append(this._mainDocument[n4]);
            }
        }
        return stringBuffer.toString();
    }

    private void flushHeldParagraph() {
        PapxNode papxNode = (PapxNode)this._onHold.get(0);
        byte[] byArray = papxNode.getPapx();
        short s = LittleEndian.getShort(byArray, 0);
        StyleDescription styleDescription = this._stsh.getStyleDescription(s);
        ParagraphProperties paragraphProperties = (ParagraphProperties)StyleSheet.uncompressProperty(byArray, this._currentStd.getPAP(), this._stsh);
        LVL lVL = this._listTables.getLevel(paragraphProperties.getIlfo(), paragraphProperties.getIlvl());
        paragraphProperties = (ParagraphProperties)StyleSheet.uncompressProperty(lVL._papx, paragraphProperties, this._stsh, false);
        int n = this._onHold.size() - 1;
        CharacterProperties characterProperties = (CharacterProperties)StyleSheet.uncompressProperty(((ChpxNode)this._onHold.get(n)).getChpx(), styleDescription.getCHP(), this._stsh);
        characterProperties = (CharacterProperties)StyleSheet.uncompressProperty(lVL._chpx, characterProperties, this._stsh);
        String string = this.getBulletText(lVL, paragraphProperties);
        this._listener.listEntry(string, characterProperties, paragraphProperties, papxNode.getStart() - this._fcMin, papxNode.getEnd() - this._fcMin);
        for (int i = 1; i <= n; ++i) {
            this.characterRun((ChpxNode)this._onHold.get(i));
        }
    }

    private String getBulletText(LVL lVL, ParagraphProperties paragraphProperties) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lVL._xst.length; ++i) {
            if (lVL._xst[i] < '\t') {
                LVL lVL2 = this._listTables.getLevel(paragraphProperties.getIlfo(), lVL._xst[i]);
                int n = lVL2._iStartAt++;
                if (lVL != lVL2 && n > 1) {
                    --n;
                }
                stringBuffer.append(NumberFormatter.getNumber(n, lVL._nfc));
                continue;
            }
            stringBuffer.append(lVL._xst[i]);
        }
        switch (lVL._ixchFollow) {
            case 0: {
                stringBuffer.append('\t');
                break;
            }
            case 1: {
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    private HeaderFooter[] findSectionHdrFtrs(int n) {
        HeaderFooter[] headerFooterArray = new HeaderFooter[6];
        for (int i = 1; i < 7; ++i) {
            headerFooterArray[i - 1] = this.createSectionHdrFtr(n, i);
        }
        return headerFooterArray;
    }

    private HeaderFooter createSectionHdrFtr(int n, int n2) {
        int n3;
        if (this._hdrSize < 50) {
            return new HeaderFooter(0, 0, 0);
        }
        int n4 = n3 = this._fcMin + this._ccpText + this._ccpFtn;
        int n5 = 0;
        switch (n2) {
            case 1: {
                n5 = HEADER_EVEN_INDEX + n * 6;
                break;
            }
            case 3: {
                n5 = FOOTER_EVEN_INDEX + n * 6;
                break;
            }
            case 2: {
                n5 = HEADER_ODD_INDEX + n * 6;
                break;
            }
            case 4: {
                n5 = FOOTER_ODD_INDEX + n * 6;
                break;
            }
            case 5: {
                n5 = HEADER_FIRST_INDEX + n * 6;
                break;
            }
            case 6: {
                n5 = FOOTER_FIRST_INDEX + n * 6;
            }
        }
        HeaderFooter headerFooter = new HeaderFooter(n2, n3 += LittleEndian.getInt(this._tableStream, this._hdrOffset + n5 * 4), n4 += LittleEndian.getInt(this._tableStream, this._hdrOffset + (n5 + 1) * 4));
        if (n4 - n3 == 0 && n > 1) {
            headerFooter = this.createSectionHdrFtr(n2, n - 1);
        }
        return headerFooter;
    }
}

