/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.extractor;

import ai2.org.apache.poi.POIOLE2TextExtractor;
import ai2.org.apache.poi.POITextExtractor;
import ai2.org.apache.poi.POIXMLDocument;
import ai2.org.apache.poi.POIXMLRelation;
import ai2.org.apache.poi.POIXMLTextExtractor;
import ai2.org.apache.poi.hdgf.extractor.VisioTextExtractor;
import ai2.org.apache.poi.hpbf.extractor.PublisherTextExtractor;
import ai2.org.apache.poi.hslf.extractor.PowerPointExtractor;
import ai2.org.apache.poi.hsmf.MAPIMessage;
import ai2.org.apache.poi.hsmf.datatypes.AttachmentChunks;
import ai2.org.apache.poi.hsmf.extractor.OutlookTextExtactor;
import ai2.org.apache.poi.hssf.extractor.EventBasedExcelExtractor;
import ai2.org.apache.poi.hssf.extractor.ExcelExtractor;
import ai2.org.apache.poi.hwpf.OldWordFileFormatException;
import ai2.org.apache.poi.hwpf.extractor.Word6Extractor;
import ai2.org.apache.poi.hwpf.extractor.WordExtractor;
import ai2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import ai2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import ai2.org.apache.poi.openxml4j.opc.OPCPackage;
import ai2.org.apache.poi.openxml4j.opc.PackageAccess;
import ai2.org.apache.poi.openxml4j.opc.PackagePart;
import ai2.org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import ai2.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.Entry;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.NotOLE2FileException;
import ai2.org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.xslf.XSLFSlideShow;
import ai2.org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import ai2.org.apache.poi.xslf.usermodel.XSLFRelation;
import ai2.org.apache.poi.xssf.extractor.XSSFEventBasedExcelExtractor;
import ai2.org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import ai2.org.apache.poi.xssf.usermodel.XSSFRelation;
import ai2.org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.xmlbeans.XmlException;

public class ExtractorFactory {
    public static final String CORE_DOCUMENT_REL = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument";
    protected static final String VISIO_DOCUMENT_REL = "http://schemas.microsoft.com/visio/2010/relationships/document";
    protected static final String STRICT_DOCUMENT_REL = "http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument";
    private static final ThreadLocal<Boolean> threadPreferEventExtractors = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static Boolean allPreferEventExtractors;

    public static boolean getThreadPrefersEventExtractors() {
        return threadPreferEventExtractors.get();
    }

    public static Boolean getAllThreadsPreferEventExtractors() {
        return allPreferEventExtractors;
    }

    public static void setThreadPrefersEventExtractors(boolean bl) {
        threadPreferEventExtractors.set(bl);
    }

    public static void setAllThreadsPreferEventExtractors(Boolean bl) {
        allPreferEventExtractors = bl;
    }

    protected static boolean getPreferEventExtractor() {
        if (allPreferEventExtractors != null) {
            return allPreferEventExtractors;
        }
        return threadPreferEventExtractors.get();
    }

    public static POITextExtractor createExtractor(File file) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        InputStream inputStream = null;
        try {
            NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(file);
            POIOLE2TextExtractor pOIOLE2TextExtractor = ExtractorFactory.createExtractor(nPOIFSFileSystem);
            return pOIOLE2TextExtractor;
        }
        catch (OfficeXmlFileException officeXmlFileException) {
            POIXMLTextExtractor pOIXMLTextExtractor = ExtractorFactory.createExtractor(OPCPackage.open(file.toString(), PackageAccess.READ));
            return pOIXMLTextExtractor;
        }
        catch (NotOLE2FileException notOLE2FileException) {
            throw new IllegalArgumentException("Your File was neither an OLE2 file, nor an OOXML file");
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static POITextExtractor createExtractor(InputStream inputStream) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        if (!inputStream.markSupported()) {
            inputStream = new PushbackInputStream(inputStream, 8);
        }
        if (NPOIFSFileSystem.hasPOIFSHeader(inputStream)) {
            return ExtractorFactory.createExtractor(new NPOIFSFileSystem(inputStream));
        }
        if (POIXMLDocument.hasOOXMLHeader(inputStream)) {
            return ExtractorFactory.createExtractor(OPCPackage.open(inputStream));
        }
        throw new IllegalArgumentException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static POIXMLTextExtractor createExtractor(OPCPackage oPCPackage) throws IOException, OpenXML4JException, XmlException {
        Object object;
        PackageRelationshipCollection packageRelationshipCollection = oPCPackage.getRelationshipsByType(CORE_DOCUMENT_REL);
        if (packageRelationshipCollection.size() == 0) {
            packageRelationshipCollection = oPCPackage.getRelationshipsByType(STRICT_DOCUMENT_REL);
        }
        if (packageRelationshipCollection.size() == 0 && ((PackageRelationshipCollection)(object = oPCPackage.getRelationshipsByType(VISIO_DOCUMENT_REL))).size() == 1) {
            throw new IllegalArgumentException("Text extraction not supported for Visio OOXML files");
        }
        if (packageRelationshipCollection.size() != 1) {
            throw new IllegalArgumentException("Invalid OOXML Package received - expected 1 core document, found " + packageRelationshipCollection.size());
        }
        object = oPCPackage.getPart(packageRelationshipCollection.getRelationship(0));
        for (XSSFRelation pOIXMLRelation : XSSFExcelExtractor.SUPPORTED_TYPES) {
            if (!((PackagePart)object).getContentType().equals(pOIXMLRelation.getContentType())) continue;
            if (ExtractorFactory.getPreferEventExtractor()) {
                return new XSSFEventBasedExcelExtractor(oPCPackage);
            }
            return new XSSFExcelExtractor(oPCPackage);
        }
        for (POIXMLRelation pOIXMLRelation : XWPFWordExtractor.SUPPORTED_TYPES) {
            if (!((PackagePart)object).getContentType().equals(pOIXMLRelation.getContentType())) continue;
            return new XWPFWordExtractor(oPCPackage);
        }
        for (POIXMLRelation pOIXMLRelation : XSLFPowerPointExtractor.SUPPORTED_TYPES) {
            if (!((PackagePart)object).getContentType().equals(pOIXMLRelation.getContentType())) continue;
            return new XSLFPowerPointExtractor(oPCPackage);
        }
        if (XSLFRelation.THEME_MANAGER.getContentType().equals(((PackagePart)object).getContentType())) {
            return new XSLFPowerPointExtractor(new XSLFSlideShow(oPCPackage));
        }
        oPCPackage.revert();
        throw new IllegalArgumentException("No supported documents found in the OOXML package (found " + ((PackagePart)object).getContentType() + ")");
    }

    public static POIOLE2TextExtractor createExtractor(POIFSFileSystem pOIFSFileSystem) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        return (POIOLE2TextExtractor)ExtractorFactory.createExtractor(pOIFSFileSystem.getRoot());
    }

    public static POIOLE2TextExtractor createExtractor(NPOIFSFileSystem nPOIFSFileSystem) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        return (POIOLE2TextExtractor)ExtractorFactory.createExtractor(nPOIFSFileSystem.getRoot());
    }

    public static POIOLE2TextExtractor createExtractor(OPOIFSFileSystem oPOIFSFileSystem) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        return (POIOLE2TextExtractor)ExtractorFactory.createExtractor(oPOIFSFileSystem.getRoot());
    }

    public static POITextExtractor createExtractor(DirectoryNode directoryNode) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        if (directoryNode.hasEntry("Workbook") || directoryNode.hasEntry("WORKBOOK") || directoryNode.hasEntry("BOOK")) {
            if (ExtractorFactory.getPreferEventExtractor()) {
                return new EventBasedExcelExtractor(directoryNode);
            }
            return new ExcelExtractor(directoryNode);
        }
        if (directoryNode.hasEntry("WordDocument")) {
            try {
                return new WordExtractor(directoryNode);
            }
            catch (OldWordFileFormatException oldWordFileFormatException) {
                return new Word6Extractor(directoryNode);
            }
        }
        if (directoryNode.hasEntry("PowerPoint Document")) {
            return new PowerPointExtractor(directoryNode);
        }
        if (directoryNode.hasEntry("VisioDocument")) {
            return new VisioTextExtractor(directoryNode);
        }
        if (directoryNode.hasEntry("Quill")) {
            return new PublisherTextExtractor(directoryNode);
        }
        if (directoryNode.hasEntry("__substg1.0_1000001E") || directoryNode.hasEntry("__substg1.0_1000001F") || directoryNode.hasEntry("__substg1.0_0047001E") || directoryNode.hasEntry("__substg1.0_0047001F") || directoryNode.hasEntry("__substg1.0_0037001E") || directoryNode.hasEntry("__substg1.0_0037001F")) {
            return new OutlookTextExtactor(directoryNode);
        }
        Iterator<Entry> iterator = directoryNode.getEntries();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (!entry.getName().equals("Package")) continue;
            OPCPackage oPCPackage = OPCPackage.open(directoryNode.createDocumentInputStream("Package"));
            return ExtractorFactory.createExtractor(oPCPackage);
        }
        throw new IllegalArgumentException("No supported documents found in the OLE2 stream");
    }

    /*
     * WARNING - void declaration
     */
    public static POITextExtractor[] getEmbededDocsTextExtractors(POIOLE2TextExtractor pOIOLE2TextExtractor) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        void var5_13;
        void var5_11;
        ArrayList<POITextExtractor> arrayList;
        ArrayList<Entry> arrayList2 = new ArrayList<Entry>();
        ArrayList<ByteArrayInputStream> arrayList3 = new ArrayList<ByteArrayInputStream>();
        DirectoryEntry directoryEntry = pOIOLE2TextExtractor.getRoot();
        if (directoryEntry == null) {
            throw new IllegalStateException("The extractor didn't know which POIFS it came from!");
        }
        if (pOIOLE2TextExtractor instanceof ExcelExtractor) {
            arrayList = directoryEntry.getEntries();
            while (arrayList.hasNext()) {
                Entry object = arrayList.next();
                if (!object.getName().startsWith("MBD")) continue;
                arrayList2.add(object);
            }
        } else if (pOIOLE2TextExtractor instanceof WordExtractor) {
            try {
                arrayList = (DirectoryEntry)directoryEntry.getEntry("ObjectPool");
                Iterator<Entry> n = arrayList.getEntries();
                while (n.hasNext()) {
                    Entry entry = n.next();
                    if (!entry.getName().startsWith("_")) continue;
                    arrayList2.add(entry);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else if (!(pOIOLE2TextExtractor instanceof PowerPointExtractor) && pOIOLE2TextExtractor instanceof OutlookTextExtactor) {
            arrayList = ((OutlookTextExtactor)pOIOLE2TextExtractor).getMAPIMessage();
            for (AttachmentChunks attachmentChunks : ((MAPIMessage)((Object)arrayList)).getAttachmentFiles()) {
                if (attachmentChunks.attachData != null) {
                    byte[] byArray = attachmentChunks.attachData.getValue();
                    arrayList3.add(new ByteArrayInputStream(byArray));
                    continue;
                }
                if (attachmentChunks.attachmentDirectory == null) continue;
                arrayList2.add(attachmentChunks.attachmentDirectory.getDirectory());
            }
        }
        if (arrayList2.size() == 0 && arrayList3.size() == 0) {
            return new POITextExtractor[0];
        }
        arrayList = new ArrayList<POITextExtractor>();
        boolean bl = false;
        while (var5_11 < arrayList2.size()) {
            arrayList.add(ExtractorFactory.createExtractor((DirectoryNode)arrayList2.get((int)var5_11)));
            ++var5_11;
        }
        boolean bl2 = false;
        while (var5_13 < arrayList3.size()) {
            try {
                arrayList.add(ExtractorFactory.createExtractor((InputStream)arrayList3.get((int)var5_13)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (XmlException xmlException) {
                throw new IOException(xmlException.getMessage());
            }
            catch (OpenXML4JException openXML4JException) {
                throw new IOException(openXML4JException.getMessage());
            }
            ++var5_13;
        }
        return arrayList.toArray(new POITextExtractor[arrayList.size()]);
    }

    public static POITextExtractor[] getEmbededDocsTextExtractors(POIXMLTextExtractor pOIXMLTextExtractor) {
        throw new IllegalStateException("Not yet supported");
    }
}

