/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.dev;

import ai2.org.apache.poi.openxml4j.opc.internal.ZipHelper;
import ai2.org.apache.poi.openxml4j.util.ZipSecureFile;
import ai2.org.apache.poi.util.IOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class OOXMLPrettyPrint {
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final DocumentBuilder documentBuilder;

    public OOXMLPrettyPrint() throws ParserConfigurationException {
        ZipSecureFile.setMinInflateRatio(1.0E-5);
        this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length <= 1 || stringArray.length % 2 != 0) {
            System.err.println("Use:");
            System.err.println("\tjava OOXMLPrettyPrint [<filename> <outfilename>] ...");
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            File file = new File(stringArray[i]);
            if (!file.exists()) {
                System.err.println("Error, file not found!");
                System.err.println("\t" + file.toString());
                System.exit(2);
            }
            OOXMLPrettyPrint.handleFile(file, new File(stringArray[i + 1]));
        }
        System.out.println("Done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleFile(File file, File file2) throws ZipException, IOException, TransformerException, ParserConfigurationException {
        System.out.println("Reading zip-file " + file + " and writing pretty-printed XML to " + file2);
        ZipFile zipFile = ZipHelper.openZipFile(file);
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            try {
                new OOXMLPrettyPrint().handle(zipFile, zipOutputStream);
            }
            finally {
                zipOutputStream.close();
            }
        }
        finally {
            zipFile.close();
            System.out.println();
        }
    }

    private void handle(ZipFile zipFile, ZipOutputStream zipOutputStream) throws IOException, TransformerException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            zipOutputStream.putNextEntry(new ZipEntry(string));
            try {
                if (string.endsWith(".xml") || string.endsWith(".rels")) {
                    Document document = this.documentBuilder.parse(new InputSource(zipFile.getInputStream(zipEntry)));
                    document.setXmlStandalone(true);
                    OOXMLPrettyPrint.pretty(document, zipOutputStream, 2);
                } else {
                    System.out.println("Not pretty-printing non-XML file " + string);
                    IOUtils.copy(zipFile.getInputStream(zipEntry), zipOutputStream);
                }
            }
            catch (Exception exception) {
                throw new IOException("While handling entry " + string, exception);
            }
            finally {
                zipOutputStream.closeEntry();
            }
            System.out.print(".");
        }
    }

    private static void pretty(Document document, OutputStream outputStream, int n) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        if (n > 0) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(n));
        }
        StreamResult streamResult = new StreamResult(outputStream);
        DOMSource dOMSource = new DOMSource(document);
        transformer.transform(dOMSource, streamResult);
    }
}

