/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ddf;

import ai2.org.apache.poi.ddf.EscherArrayProperty;
import ai2.org.apache.poi.ddf.EscherBoolProperty;
import ai2.org.apache.poi.ddf.EscherComplexProperty;
import ai2.org.apache.poi.ddf.EscherProperties;
import ai2.org.apache.poi.ddf.EscherProperty;
import ai2.org.apache.poi.ddf.EscherRGBProperty;
import ai2.org.apache.poi.ddf.EscherShapePathProperty;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EscherPropertyFactory {
    public List<EscherProperty> createProperties(byte[] byArray, int n, short n2) {
        short s;
        ArrayList<EscherProperty> arrayList = new ArrayList<EscherProperty>();
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            short s2 = LittleEndian.getShort(byArray, n3);
            int n4 = LittleEndian.getInt(byArray, n3 + 2);
            s = (short)(s2 & 0x3FFF);
            boolean bl = (s2 & Short.MIN_VALUE) != 0;
            boolean bl2 = (s2 & 0x4000) != 0;
            byte by = EscherProperties.getPropertyType(s);
            if (by == 1) {
                arrayList.add(new EscherBoolProperty(s2, n4));
            } else if (by == 2) {
                arrayList.add(new EscherRGBProperty(s2, n4));
            } else if (by == 3) {
                arrayList.add(new EscherShapePathProperty(s2, n4));
            } else if (!bl) {
                arrayList.add(new EscherSimpleProperty(s2, n4));
            } else if (by == 5) {
                arrayList.add(new EscherArrayProperty(s2, new byte[n4]));
            } else {
                arrayList.add(new EscherComplexProperty(s2, new byte[n4]));
            }
            n3 += 6;
        }
        for (EscherProperty escherProperty : arrayList) {
            if (!(escherProperty instanceof EscherComplexProperty)) continue;
            if (escherProperty instanceof EscherArrayProperty) {
                n3 += ((EscherArrayProperty)escherProperty).setArrayData(byArray, n3);
                continue;
            }
            s = byArray.length - n3;
            byte[] byArray2 = ((EscherComplexProperty)escherProperty).getComplexData();
            if (s < byArray2.length) {
                throw new IllegalStateException("Could not read complex escher property, lenght was " + byArray2.length + ", but had only " + s + " bytes left");
            }
            System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
            n3 += byArray2.length;
        }
        return arrayList;
    }
}

