/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ddf;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.LittleEndian;

public class EscherColorRef {
    int opid = -1;
    int colorRef = 0;
    private static final BitField FLAG_SYS_INDEX = new BitField(0x10000000);
    private static final BitField FLAG_SCHEME_INDEX = new BitField(0x8000000);
    private static final BitField FLAG_SYSTEM_RGB = new BitField(0x4000000);
    private static final BitField FLAG_PALETTE_RGB = new BitField(0x2000000);
    private static final BitField FLAG_PALETTE_INDEX = new BitField(0x1000000);
    private static final BitField FLAG_BLUE = new BitField(0xFF0000);
    private static final BitField FLAG_GREEN = new BitField(65280);
    private static final BitField FLAG_RED = new BitField(255);

    public EscherColorRef(int n) {
        this.colorRef = n;
    }

    public EscherColorRef(byte[] byArray, int n, int n2) {
        assert (n2 == 4 || n2 == 6);
        int n3 = n;
        if (n2 == 6) {
            this.opid = LittleEndian.getUShort(byArray, n3);
            n3 += 2;
        }
        this.colorRef = LittleEndian.getInt(byArray, n3);
    }

    public boolean hasSysIndexFlag() {
        return FLAG_SYS_INDEX.isSet(this.colorRef);
    }

    public void setSysIndexFlag(boolean bl) {
        FLAG_SYS_INDEX.setBoolean(this.colorRef, bl);
    }

    public boolean hasSchemeIndexFlag() {
        return FLAG_SCHEME_INDEX.isSet(this.colorRef);
    }

    public void setSchemeIndexFlag(boolean bl) {
        FLAG_SCHEME_INDEX.setBoolean(this.colorRef, bl);
    }

    public boolean hasSystemRGBFlag() {
        return FLAG_SYSTEM_RGB.isSet(this.colorRef);
    }

    public void setSystemRGBFlag(boolean bl) {
        FLAG_SYSTEM_RGB.setBoolean(this.colorRef, bl);
    }

    public boolean hasPaletteRGBFlag() {
        return FLAG_PALETTE_RGB.isSet(this.colorRef);
    }

    public void setPaletteRGBFlag(boolean bl) {
        FLAG_PALETTE_RGB.setBoolean(this.colorRef, bl);
    }

    public boolean hasPaletteIndexFlag() {
        return FLAG_PALETTE_INDEX.isSet(this.colorRef);
    }

    public void setPaletteIndexFlag(boolean bl) {
        FLAG_PALETTE_INDEX.setBoolean(this.colorRef, bl);
    }

    public int[] getRGB() {
        int[] nArray = new int[]{FLAG_RED.getValue(this.colorRef), FLAG_GREEN.getValue(this.colorRef), FLAG_BLUE.getValue(this.colorRef)};
        return nArray;
    }

    public SysIndexSource getSysIndexSource() {
        if (!this.hasSysIndexFlag()) {
            return null;
        }
        int n = FLAG_RED.getValue(this.colorRef);
        for (SysIndexSource sysIndexSource : SysIndexSource.values()) {
            if (sysIndexSource.value != n) continue;
            return sysIndexSource;
        }
        return null;
    }

    public SysIndexProcedure getSysIndexProcedure() {
        if (!this.hasSysIndexFlag()) {
            return null;
        }
        int n = FLAG_RED.getValue(this.colorRef);
        for (SysIndexProcedure sysIndexProcedure : SysIndexProcedure.values()) {
            if (sysIndexProcedure == SysIndexProcedure.INVERT_AFTER || sysIndexProcedure == SysIndexProcedure.INVERT_HIGHBIT_AFTER || !sysIndexProcedure.mask.isSet(n)) continue;
            return sysIndexProcedure;
        }
        return null;
    }

    public int getSysIndexInvert() {
        if (!this.hasSysIndexFlag()) {
            return 0;
        }
        int n = FLAG_GREEN.getValue(this.colorRef);
        if (SysIndexProcedure.INVERT_AFTER.mask.isSet(n)) {
            return 1;
        }
        if (SysIndexProcedure.INVERT_HIGHBIT_AFTER.mask.isSet(n)) {
            return 2;
        }
        return 0;
    }

    public int getSchemeIndex() {
        if (!this.hasSchemeIndexFlag()) {
            return -1;
        }
        return FLAG_RED.getValue(this.colorRef);
    }

    public int getPaletteIndex() {
        if (!this.hasPaletteIndexFlag()) {
            return -1;
        }
        return FLAG_GREEN.getValue(this.colorRef) << 8 & FLAG_RED.getValue(this.colorRef);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SysIndexProcedure {
        DARKEN_COLOR(1),
        LIGHTEN_COLOR(2),
        ADD_GRAY_LEVEL(3),
        SUB_GRAY_LEVEL(4),
        REVERSE_GRAY_LEVEL(5),
        THRESHOLD(6),
        INVERT_AFTER(32),
        INVERT_HIGHBIT_AFTER(64);

        BitField mask;

        private SysIndexProcedure(int n2) {
            this.mask = new BitField(n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SysIndexSource {
        FILL_COLOR(240),
        LINE_OR_FILL_COLOR(241),
        LINE_COLOR(242),
        SHADOW_COLOR(243),
        CURRENT_OR_LAST_COLOR(244),
        FILL_BACKGROUND_COLOR(245),
        LINE_BACKGROUND_COLOR(246),
        FILL_OR_LINE_COLOR(247);

        int value;

        private SysIndexSource(int n2) {
            this.value = n2;
        }
    }
}

