/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.ddf;

import ai2.org.apache.poi.ddf.EscherBlipRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherSerializationListener;
import ai2.org.apache.poi.ddf.NullEscherSerializationListener;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndian;

public final class EscherBSERecord
extends EscherRecord {
    public static final short RECORD_ID = -4089;
    public static final String RECORD_DESCRIPTION = "MsofbtBSE";
    public static final byte BT_ERROR = 0;
    public static final byte BT_UNKNOWN = 1;
    public static final byte BT_EMF = 2;
    public static final byte BT_WMF = 3;
    public static final byte BT_PICT = 4;
    public static final byte BT_JPEG = 5;
    public static final byte BT_PNG = 6;
    public static final byte BT_DIB = 7;
    private byte field_1_blipTypeWin32;
    private byte field_2_blipTypeMacOS;
    private byte[] field_3_uid;
    private short field_4_tag;
    private int field_5_size;
    private int field_6_ref;
    private int field_7_offset;
    private byte field_8_usage;
    private byte field_9_name;
    private byte field_10_unused2;
    private byte field_11_unused3;
    private EscherBlipRecord field_12_blipRecord;
    private byte[] _remainingData;

    public int fillFields(byte[] byArray, int n, EscherRecordFactory escherRecordFactory) {
        int n2 = this.readHeader(byArray, n);
        int n3 = n + 8;
        this.field_1_blipTypeWin32 = byArray[n3];
        this.field_2_blipTypeMacOS = byArray[n3 + 1];
        this.field_3_uid = new byte[16];
        System.arraycopy(byArray, n3 + 2, this.field_3_uid, 0, 16);
        this.field_4_tag = LittleEndian.getShort(byArray, n3 + 18);
        this.field_5_size = LittleEndian.getInt(byArray, n3 + 20);
        this.field_6_ref = LittleEndian.getInt(byArray, n3 + 24);
        this.field_7_offset = LittleEndian.getInt(byArray, n3 + 28);
        this.field_8_usage = byArray[n3 + 32];
        this.field_9_name = byArray[n3 + 33];
        this.field_10_unused2 = byArray[n3 + 34];
        this.field_11_unused3 = byArray[n3 + 35];
        int n4 = 0;
        if ((n2 -= 36) > 0) {
            this.field_12_blipRecord = (EscherBlipRecord)escherRecordFactory.createRecord(byArray, n3 + 36);
            n4 = this.field_12_blipRecord.fillFields(byArray, n3 + 36, escherRecordFactory);
        }
        this._remainingData = new byte[n2 -= n4];
        System.arraycopy(byArray, n3 += 36 + n4, this._remainingData, 0, n2);
        return n2 + 8 + 36 + (this.field_12_blipRecord == null ? 0 : this.field_12_blipRecord.getRecordSize());
    }

    public int serialize(int n, byte[] byArray, EscherSerializationListener escherSerializationListener) {
        int n2;
        escherSerializationListener.beforeRecordSerialize(n, this.getRecordId(), this);
        if (this._remainingData == null) {
            this._remainingData = new byte[0];
        }
        LittleEndian.putShort(byArray, n, this.getOptions());
        LittleEndian.putShort(byArray, n + 2, this.getRecordId());
        if (this._remainingData == null) {
            this._remainingData = new byte[0];
        }
        int n3 = this.field_12_blipRecord == null ? 0 : this.field_12_blipRecord.getRecordSize();
        int n4 = this._remainingData.length + 36 + n3;
        LittleEndian.putInt(byArray, n + 4, n4);
        byArray[n + 8] = this.field_1_blipTypeWin32;
        byArray[n + 9] = this.field_2_blipTypeMacOS;
        for (n2 = 0; n2 < 16; ++n2) {
            byArray[n + 10 + n2] = this.field_3_uid[n2];
        }
        LittleEndian.putShort(byArray, n + 26, this.field_4_tag);
        LittleEndian.putInt(byArray, n + 28, this.field_5_size);
        LittleEndian.putInt(byArray, n + 32, this.field_6_ref);
        LittleEndian.putInt(byArray, n + 36, this.field_7_offset);
        byArray[n + 40] = this.field_8_usage;
        byArray[n + 41] = this.field_9_name;
        byArray[n + 42] = this.field_10_unused2;
        byArray[n + 43] = this.field_11_unused3;
        n2 = 0;
        if (this.field_12_blipRecord != null) {
            n2 = this.field_12_blipRecord.serialize(n + 44, byArray, new NullEscherSerializationListener());
        }
        if (this._remainingData == null) {
            this._remainingData = new byte[0];
        }
        System.arraycopy(this._remainingData, 0, byArray, n + 44 + n2, this._remainingData.length);
        int n5 = n + 8 + 36 + this._remainingData.length + n2;
        escherSerializationListener.afterRecordSerialize(n5, this.getRecordId(), n5 - n, this);
        return n5 - n;
    }

    public int getRecordSize() {
        int n = 0;
        if (this.field_12_blipRecord != null) {
            n = this.field_12_blipRecord.getRecordSize();
        }
        int n2 = 0;
        if (this._remainingData != null) {
            n2 = this._remainingData.length;
        }
        return 44 + n + n2;
    }

    public String getRecordName() {
        return "BSE";
    }

    public byte getBlipTypeWin32() {
        return this.field_1_blipTypeWin32;
    }

    public void setBlipTypeWin32(byte by) {
        this.field_1_blipTypeWin32 = by;
    }

    public byte getBlipTypeMacOS() {
        return this.field_2_blipTypeMacOS;
    }

    public void setBlipTypeMacOS(byte by) {
        this.field_2_blipTypeMacOS = by;
    }

    public byte[] getUid() {
        return this.field_3_uid;
    }

    public void setUid(byte[] byArray) {
        this.field_3_uid = byArray;
    }

    public short getTag() {
        return this.field_4_tag;
    }

    public void setTag(short s) {
        this.field_4_tag = s;
    }

    public int getSize() {
        return this.field_5_size;
    }

    public void setSize(int n) {
        this.field_5_size = n;
    }

    public int getRef() {
        return this.field_6_ref;
    }

    public void setRef(int n) {
        this.field_6_ref = n;
    }

    public int getOffset() {
        return this.field_7_offset;
    }

    public void setOffset(int n) {
        this.field_7_offset = n;
    }

    public byte getUsage() {
        return this.field_8_usage;
    }

    public void setUsage(byte by) {
        this.field_8_usage = by;
    }

    public byte getName() {
        return this.field_9_name;
    }

    public void setName(byte by) {
        this.field_9_name = by;
    }

    public byte getUnused2() {
        return this.field_10_unused2;
    }

    public void setUnused2(byte by) {
        this.field_10_unused2 = by;
    }

    public byte getUnused3() {
        return this.field_11_unused3;
    }

    public void setUnused3(byte by) {
        this.field_11_unused3 = by;
    }

    public EscherBlipRecord getBlipRecord() {
        return this.field_12_blipRecord;
    }

    public void setBlipRecord(EscherBlipRecord escherBlipRecord) {
        this.field_12_blipRecord = escherBlipRecord;
    }

    public byte[] getRemainingData() {
        return this._remainingData;
    }

    public void setRemainingData(byte[] byArray) {
        this._remainingData = byArray;
    }

    public String toString() {
        String string = this._remainingData == null ? null : HexDump.toHex(this._remainingData, 32);
        return this.getClass().getName() + ":" + '\n' + "  RecordId: 0x" + HexDump.toHex((short)-4089) + '\n' + "  Version: 0x" + HexDump.toHex(this.getVersion()) + '\n' + "  Instance: 0x" + HexDump.toHex(this.getInstance()) + '\n' + "  BlipTypeWin32: " + this.field_1_blipTypeWin32 + '\n' + "  BlipTypeMacOS: " + this.field_2_blipTypeMacOS + '\n' + "  SUID: " + (this.field_3_uid == null ? "" : HexDump.toHex(this.field_3_uid)) + '\n' + "  Tag: " + this.field_4_tag + '\n' + "  Size: " + this.field_5_size + '\n' + "  Ref: " + this.field_6_ref + '\n' + "  Offset: " + this.field_7_offset + '\n' + "  Usage: " + this.field_8_usage + '\n' + "  Name: " + this.field_9_name + '\n' + "  Unused2: " + this.field_10_unused2 + '\n' + "  Unused3: " + this.field_11_unused3 + '\n' + "  blipRecord: " + this.field_12_blipRecord + '\n' + "  Extra Data:" + '\n' + string;
    }

    public String toXml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.formatXmlRecordHeader(this.getClass().getSimpleName(), HexDump.toHex(this.getRecordId()), HexDump.toHex(this.getVersion()), HexDump.toHex(this.getInstance()))).append(string).append("\t").append("<BlipTypeWin32>").append(this.field_1_blipTypeWin32).append("</BlipTypeWin32>\n").append(string).append("\t").append("<BlipTypeMacOS>").append(this.field_2_blipTypeMacOS).append("</BlipTypeMacOS>\n").append(string).append("\t").append("<SUID>").append(this.field_3_uid == null ? "" : HexDump.toHex(this.field_3_uid)).append("</SUID>\n").append(string).append("\t").append("<Tag>").append(this.field_4_tag).append("</Tag>\n").append(string).append("\t").append("<Size>").append(this.field_5_size).append("</Size>\n").append(string).append("\t").append("<Ref>").append(this.field_6_ref).append("</Ref>\n").append(string).append("\t").append("<Offset>").append(this.field_7_offset).append("</Offset>\n").append(string).append("\t").append("<Usage>").append(this.field_8_usage).append("</Usage>\n").append(string).append("\t").append("<Name>").append(this.field_9_name).append("</Name>\n").append(string).append("\t").append("<Unused2>").append(this.field_10_unused2).append("</Unused2>\n").append(string).append("\t").append("<Unused3>").append(this.field_11_unused3).append("</Unused3>\n");
        stringBuilder.append(string).append("</").append(this.getClass().getSimpleName()).append(">\n");
        return stringBuilder.toString();
    }

    public static String getBlipType(byte by) {
        switch (by) {
            case 0: {
                return " ERROR";
            }
            case 1: {
                return " UNKNOWN";
            }
            case 2: {
                return " EMF";
            }
            case 3: {
                return " WMF";
            }
            case 4: {
                return " PICT";
            }
            case 5: {
                return " JPEG";
            }
            case 6: {
                return " PNG";
            }
            case 7: {
                return " DIB";
            }
        }
        if (by < 32) {
            return " NotKnown";
        }
        return " Client";
    }
}

