/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi;

import ai2.org.apache.poi.POIXMLDocument;
import ai2.org.apache.poi.POIXMLTextExtractor;
import ai2.org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import java.math.BigDecimal;
import java.util.Date;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperties;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperty;

public class POIXMLPropertiesTextExtractor
extends POIXMLTextExtractor {
    public POIXMLPropertiesTextExtractor(POIXMLDocument pOIXMLDocument) {
        super(pOIXMLDocument);
    }

    public POIXMLPropertiesTextExtractor(POIXMLTextExtractor pOIXMLTextExtractor) {
        super(pOIXMLTextExtractor.getDocument());
    }

    private void appendIfPresent(StringBuffer stringBuffer, String string, boolean bl) {
        this.appendIfPresent(stringBuffer, string, Boolean.toString(bl));
    }

    private void appendIfPresent(StringBuffer stringBuffer, String string, int n) {
        this.appendIfPresent(stringBuffer, string, Integer.toString(n));
    }

    private void appendIfPresent(StringBuffer stringBuffer, String string, Date date) {
        if (date == null) {
            return;
        }
        this.appendIfPresent(stringBuffer, string, date.toString());
    }

    private void appendIfPresent(StringBuffer stringBuffer, String string, String string2) {
        if (string2 == null) {
            return;
        }
        stringBuffer.append(string);
        stringBuffer.append(" = ");
        stringBuffer.append(string2);
        stringBuffer.append("\n");
    }

    public String getCorePropertiesText() {
        POIXMLDocument pOIXMLDocument = this.getDocument();
        if (pOIXMLDocument == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        PackagePropertiesPart packagePropertiesPart = pOIXMLDocument.getProperties().getCoreProperties().getUnderlyingProperties();
        this.appendIfPresent(stringBuffer, "Category", packagePropertiesPart.getCategoryProperty().getValue());
        this.appendIfPresent(stringBuffer, "Category", packagePropertiesPart.getCategoryProperty().getValue());
        this.appendIfPresent(stringBuffer, "ContentStatus", packagePropertiesPart.getContentStatusProperty().getValue());
        this.appendIfPresent(stringBuffer, "ContentType", packagePropertiesPart.getContentTypeProperty().getValue());
        this.appendIfPresent(stringBuffer, "Created", packagePropertiesPart.getCreatedProperty().getValue());
        this.appendIfPresent(stringBuffer, "CreatedString", packagePropertiesPart.getCreatedPropertyString());
        this.appendIfPresent(stringBuffer, "Creator", packagePropertiesPart.getCreatorProperty().getValue());
        this.appendIfPresent(stringBuffer, "Description", packagePropertiesPart.getDescriptionProperty().getValue());
        this.appendIfPresent(stringBuffer, "Identifier", packagePropertiesPart.getIdentifierProperty().getValue());
        this.appendIfPresent(stringBuffer, "Keywords", packagePropertiesPart.getKeywordsProperty().getValue());
        this.appendIfPresent(stringBuffer, "Language", packagePropertiesPart.getLanguageProperty().getValue());
        this.appendIfPresent(stringBuffer, "LastModifiedBy", packagePropertiesPart.getLastModifiedByProperty().getValue());
        this.appendIfPresent(stringBuffer, "LastPrinted", packagePropertiesPart.getLastPrintedProperty().getValue());
        this.appendIfPresent(stringBuffer, "LastPrintedString", packagePropertiesPart.getLastPrintedPropertyString());
        this.appendIfPresent(stringBuffer, "Modified", packagePropertiesPart.getModifiedProperty().getValue());
        this.appendIfPresent(stringBuffer, "ModifiedString", packagePropertiesPart.getModifiedPropertyString());
        this.appendIfPresent(stringBuffer, "Revision", packagePropertiesPart.getRevisionProperty().getValue());
        this.appendIfPresent(stringBuffer, "Subject", packagePropertiesPart.getSubjectProperty().getValue());
        this.appendIfPresent(stringBuffer, "Title", packagePropertiesPart.getTitleProperty().getValue());
        this.appendIfPresent(stringBuffer, "Version", packagePropertiesPart.getVersionProperty().getValue());
        return stringBuffer.toString();
    }

    public String getExtendedPropertiesText() {
        POIXMLDocument pOIXMLDocument = this.getDocument();
        if (pOIXMLDocument == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.CTProperties cTProperties = pOIXMLDocument.getProperties().getExtendedProperties().getUnderlyingProperties();
        this.appendIfPresent(stringBuffer, "Application", cTProperties.getApplication());
        this.appendIfPresent(stringBuffer, "AppVersion", cTProperties.getAppVersion());
        this.appendIfPresent(stringBuffer, "Characters", cTProperties.getCharacters());
        this.appendIfPresent(stringBuffer, "CharactersWithSpaces", cTProperties.getCharactersWithSpaces());
        this.appendIfPresent(stringBuffer, "Company", cTProperties.getCompany());
        this.appendIfPresent(stringBuffer, "HyperlinkBase", cTProperties.getHyperlinkBase());
        this.appendIfPresent(stringBuffer, "HyperlinksChanged", cTProperties.getHyperlinksChanged());
        this.appendIfPresent(stringBuffer, "Lines", cTProperties.getLines());
        this.appendIfPresent(stringBuffer, "LinksUpToDate", cTProperties.getLinksUpToDate());
        this.appendIfPresent(stringBuffer, "Manager", cTProperties.getManager());
        this.appendIfPresent(stringBuffer, "Pages", cTProperties.getPages());
        this.appendIfPresent(stringBuffer, "Paragraphs", cTProperties.getParagraphs());
        this.appendIfPresent(stringBuffer, "PresentationFormat", cTProperties.getPresentationFormat());
        this.appendIfPresent(stringBuffer, "Template", cTProperties.getTemplate());
        this.appendIfPresent(stringBuffer, "TotalTime", cTProperties.getTotalTime());
        return stringBuffer.toString();
    }

    public String getCustomPropertiesText() {
        POIXMLDocument pOIXMLDocument = this.getDocument();
        if (pOIXMLDocument == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        CTProperties cTProperties = pOIXMLDocument.getProperties().getCustomProperties().getUnderlyingProperties();
        for (CTProperty cTProperty : cTProperties.getPropertyArray()) {
            String string = "(not implemented!)";
            if (cTProperty.isSetLpwstr()) {
                string = cTProperty.getLpwstr();
            } else if (cTProperty.isSetLpstr()) {
                string = cTProperty.getLpstr();
            } else if (cTProperty.isSetDate()) {
                string = cTProperty.getDate().toString();
            } else if (cTProperty.isSetFiletime()) {
                string = cTProperty.getFiletime().toString();
            } else if (cTProperty.isSetBool()) {
                string = Boolean.toString(cTProperty.getBool());
            } else if (cTProperty.isSetI1()) {
                string = Integer.toString(cTProperty.getI1());
            } else if (cTProperty.isSetI2()) {
                string = Integer.toString(cTProperty.getI2());
            } else if (cTProperty.isSetI4()) {
                string = Integer.toString(cTProperty.getI4());
            } else if (cTProperty.isSetI8()) {
                string = Long.toString(cTProperty.getI8());
            } else if (cTProperty.isSetInt()) {
                string = Integer.toString(cTProperty.getInt());
            } else if (cTProperty.isSetUi1()) {
                string = Integer.toString(cTProperty.getUi1());
            } else if (cTProperty.isSetUi2()) {
                string = Integer.toString(cTProperty.getUi2());
            } else if (cTProperty.isSetUi4()) {
                string = Long.toString(cTProperty.getUi4());
            } else if (cTProperty.isSetUi8()) {
                string = cTProperty.getUi8().toString();
            } else if (cTProperty.isSetUint()) {
                string = Long.toString(cTProperty.getUint());
            } else if (cTProperty.isSetR4()) {
                string = Float.toString(cTProperty.getR4());
            } else if (cTProperty.isSetR8()) {
                string = Double.toString(cTProperty.getR8());
            } else if (cTProperty.isSetDecimal()) {
                BigDecimal bigDecimal = cTProperty.getDecimal();
                string = bigDecimal == null ? null : bigDecimal.toPlainString();
            } else if (cTProperty.isSetArray() || cTProperty.isSetVector() || cTProperty.isSetBlob() || cTProperty.isSetOblob() || cTProperty.isSetStream() || cTProperty.isSetOstream() || cTProperty.isSetVstream() || cTProperty.isSetStorage() || cTProperty.isSetOstorage()) {
                // empty if block
            }
            stringBuilder.append(cTProperty.getName() + " = " + string + "\n");
        }
        return stringBuilder.toString();
    }

    public String getText() {
        try {
            return this.getCorePropertiesText() + this.getExtendedPropertiesText() + this.getCustomPropertiesText();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public POIXMLPropertiesTextExtractor getMetadataTextExtractor() {
        throw new IllegalStateException("You already have the Metadata Text Extractor, not recursing!");
    }
}

