/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi;

import ai2.org.apache.poi.hpsf.DocumentSummaryInformation;
import ai2.org.apache.poi.hpsf.HPSFException;
import ai2.org.apache.poi.hpsf.MutablePropertySet;
import ai2.org.apache.poi.hpsf.PropertySet;
import ai2.org.apache.poi.hpsf.PropertySetFactory;
import ai2.org.apache.poi.hpsf.SummaryInformation;
import ai2.org.apache.poi.hpsf.WritingNotSupportedException;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class POIDocument {
    private SummaryInformation sInf;
    private DocumentSummaryInformation dsInf;
    protected DirectoryNode directory;
    private static final POILogger logger = POILogFactory.getLogger(POIDocument.class);
    private boolean initialized = false;

    protected POIDocument(DirectoryNode directoryNode) {
        this.directory = directoryNode;
    }

    protected POIDocument(OPOIFSFileSystem oPOIFSFileSystem) {
        this(oPOIFSFileSystem.getRoot());
    }

    protected POIDocument(NPOIFSFileSystem nPOIFSFileSystem) {
        this(nPOIFSFileSystem.getRoot());
    }

    protected POIDocument(POIFSFileSystem pOIFSFileSystem) {
        this(pOIFSFileSystem.getRoot());
    }

    public DocumentSummaryInformation getDocumentSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.dsInf;
    }

    public SummaryInformation getSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.sInf;
    }

    public void createInformationProperties() {
        if (!this.initialized) {
            this.readProperties();
        }
        if (this.sInf == null) {
            this.sInf = PropertySetFactory.newSummaryInformation();
        }
        if (this.dsInf == null) {
            this.dsInf = PropertySetFactory.newDocumentSummaryInformation();
        }
    }

    protected void readProperties() {
        PropertySet propertySet = this.getPropertySet("\u0005DocumentSummaryInformation");
        if (propertySet != null && propertySet instanceof DocumentSummaryInformation) {
            this.dsInf = (DocumentSummaryInformation)propertySet;
        } else if (propertySet != null) {
            logger.log(5, "DocumentSummaryInformation property set came back with wrong class - ", propertySet.getClass());
        }
        propertySet = this.getPropertySet("\u0005SummaryInformation");
        if (propertySet instanceof SummaryInformation) {
            this.sInf = (SummaryInformation)propertySet;
        } else if (propertySet != null) {
            logger.log(5, "SummaryInformation property set came back with wrong class - ", propertySet.getClass());
        }
        this.initialized = true;
    }

    protected PropertySet getPropertySet(String string) {
        return this.getPropertySet(string, null);
    }

    protected PropertySet getPropertySet(String string, EncryptionInfo encryptionInfo) {
        InputStream inputStream;
        DirectoryNode directoryNode = this.directory;
        NPOIFSFileSystem nPOIFSFileSystem = null;
        if (encryptionInfo != null) {
            try {
                inputStream = encryptionInfo.getDecryptor().getDataStream(this.directory);
                nPOIFSFileSystem = new NPOIFSFileSystem(inputStream);
                inputStream.close();
                directoryNode = nPOIFSFileSystem.getRoot();
            }
            catch (Exception exception) {
                logger.log(7, new Object[]{"Error getting encrypted property set with name " + string, exception});
                return null;
            }
        }
        if (directoryNode == null || !directoryNode.hasEntry(string)) {
            return null;
        }
        try {
            inputStream = directoryNode.createDocumentInputStream(directoryNode.getEntry(string));
        }
        catch (IOException iOException) {
            logger.log(5, new Object[]{"Error getting property set with name " + string + "\n" + iOException});
            return null;
        }
        try {
            PropertySet propertySet = PropertySetFactory.create(inputStream);
            if (nPOIFSFileSystem != null) {
                nPOIFSFileSystem.close();
            }
            return propertySet;
        }
        catch (IOException iOException) {
            logger.log(5, new Object[]{"Error creating property set with name " + string + "\n" + iOException});
        }
        catch (HPSFException hPSFException) {
            logger.log(5, new Object[]{"Error creating property set with name " + string + "\n" + hPSFException});
        }
        return null;
    }

    protected void writeProperties() throws IOException {
        throw new IllegalStateException("In-place write is not yet supported");
    }

    protected void writeProperties(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this.writeProperties(nPOIFSFileSystem, null);
    }

    protected void writeProperties(NPOIFSFileSystem nPOIFSFileSystem, List<String> list) throws IOException {
        DocumentSummaryInformation documentSummaryInformation;
        SummaryInformation summaryInformation = this.getSummaryInformation();
        if (summaryInformation != null) {
            this.writePropertySet("\u0005SummaryInformation", summaryInformation, nPOIFSFileSystem);
            if (list != null) {
                list.add("\u0005SummaryInformation");
            }
        }
        if ((documentSummaryInformation = this.getDocumentSummaryInformation()) != null) {
            this.writePropertySet("\u0005DocumentSummaryInformation", documentSummaryInformation, nPOIFSFileSystem);
            if (list != null) {
                list.add("\u0005DocumentSummaryInformation");
            }
        }
    }

    protected void writePropertySet(String string, PropertySet propertySet, NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        try {
            MutablePropertySet mutablePropertySet = new MutablePropertySet(propertySet);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mutablePropertySet.write(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            nPOIFSFileSystem.createDocument(byteArrayInputStream, string);
            logger.log(3, new Object[]{"Wrote property set " + string + " of size " + byArray.length});
        }
        catch (WritingNotSupportedException writingNotSupportedException) {
            logger.log(7, new Object[]{"Couldn't write property set with name " + string + " as not supported by HPSF yet"});
        }
    }

    public abstract void write(OutputStream var1) throws IOException;
}

