/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.manager;

import ai.com.lowagie.text.Document;
import ai.com.lowagie.text.pdf.PdfAction;
import ai.com.lowagie.text.pdf.PdfCopy;
import ai.com.lowagie.text.pdf.PdfReader;
import com.activeintra.manager.AICipherAES128;
import com.activeintra.manager.AIFunction;
import com.activeintra.manager.AIScriptManager;
import com.activeintra.manager.AIreqres;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Random;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.log4j.Logger;

public class AIPdfMerge {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PageContext pageContext;
    private JspWriter out;
    private Logger log;
    public AIreqres reqres = null;
    private String parameterTranferMethod;
    private String jspStr;
    private boolean printDialogFlag;
    private String pdfFileName;
    private String pdfSaveName;

    public AIPdfMerge(PageContext pageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Logger logger) {
        this.pageContext = pageContext;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.log = logger;
        this.printDialogFlag = false;
        this.pdfFileName = "";
        this.pdfSaveName = "";
    }

    public AIPdfMerge(PageContext pageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Logger logger, AIreqres aIreqres) {
        this.pageContext = pageContext;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.log = logger;
        this.printDialogFlag = false;
        this.pdfFileName = "";
        this.pdfSaveName = "";
        this.reqres = aIreqres;
    }

    public void runMerge(JspWriter object) {
        Object object2 = this.request.getParameter("nameTag");
        if (object2 == null) {
            this.out = object;
            this.printDialogFlag = true;
            String string = this.mergeOut();
            string = AICipherAES128.encrypt(string);
            object.println("[{\"targetURL\": \"" + string + "\"}]");
            return;
        }
        object2 = AICipherAES128.decrypt((String)object2);
        this.response.setContentType("application/pdf");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)this.response.getOutputStream());
        object = this.getPdfFile((String)object2);
        object2 = new byte[1024];
        int n2 = 0;
        while ((n2 = ((FilterInputStream)object).read((byte[])object2)) != -1) {
            bufferedOutputStream.write((byte[])object2, 0, n2);
        }
        bufferedOutputStream.close();
        ((BufferedInputStream)object).close();
    }

    public void runMerge() {
        Object object;
        Object object2 = this.request.getParameter("chainReportParams");
        if (object2 != null && ((String)object2).toLowerCase().indexOf("pdfserversave:true") != -1) {
            this.out = this.pageContext.getOut();
            object2 = this.mergeOut();
            this.out.println("[{\"targetURL\": \"" + (String)object2 + "\"}]");
            return;
        }
        object2 = this.getPdfFile(this.mergeOut());
        if (this.pdfSaveName.equals("")) {
            this.pdfSaveName = this.reqres.getParam("pdfSaveName");
        }
        if (this.pdfSaveName.equals("null")) {
            object = "attachment; filename=" + this.getFilename2();
        } else {
            object = this.reqres.getBrowser().indexOf("Firefox") != -1 ? "attachment; filename=" + new String(this.pdfSaveName.getBytes(), "latin1") : (this.reqres.getBrowser().indexOf("Safari") != -1 ? "attachment; filename=" + new String(this.pdfSaveName.getBytes(), "latin1") : "attachment; filename=" + URLEncoder.encode(this.pdfSaveName, "utf-8"));
            object = ((String)object).replaceAll("\\+", " ");
        }
        this.response.setHeader("Content-Disposition", (String)object);
        this.response.setContentType("application/pdf");
        object = "fileDownloadToken=success; Path=/";
        this.response.setHeader("Set-Cookie", (String)object);
        object = new BufferedOutputStream((OutputStream)this.response.getOutputStream());
        byte[] byArray = new byte[1024];
        int n2 = 0;
        while ((n2 = ((FilterInputStream)object2).read(byArray)) != -1) {
            ((BufferedOutputStream)object).write(byArray, 0, n2);
        }
        ((FilterOutputStream)object).close();
        ((BufferedInputStream)object2).close();
    }

    public void runMerge(String object) {
        BufferedInputStream bufferedInputStream = this.getPdfFile(this.mergeOut());
        if (((String)object).equals("null")) {
            object = "attachment; filename=" + this.getFilename2();
        } else {
            object = this.reqres.getBrowser().indexOf("Firefox") != -1 ? "attachment; filename=" + new String(((String)object).getBytes(), "latin1") : (this.reqres.getBrowser().indexOf("Safari") != -1 ? "attachment; filename=" + new String(((String)object).getBytes(), "latin1") : "attachment; filename=" + URLEncoder.encode((String)object, "utf-8"));
            object = ((String)object).replaceAll("\\+", " ");
        }
        this.response.setHeader("Content-Disposition", (String)object);
        this.response.setContentType("application/pdf");
        object = "fileDownloadToken=success; Path=/";
        this.response.setHeader("Set-Cookie", (String)object);
        object = new BufferedOutputStream((OutputStream)this.response.getOutputStream());
        byte[] byArray = new byte[1024];
        int n2 = 0;
        while ((n2 = bufferedInputStream.read(byArray)) != -1) {
            ((BufferedOutputStream)object).write(byArray, 0, n2);
        }
        ((FilterOutputStream)object).close();
        bufferedInputStream.close();
    }

    private String mergeOut() {
        String[] stringArray;
        this.jspStr = this.request.getParameter("key");
        if (this.jspStr == null) {
            this.jspStr = this.request.getParameter("jspURL");
            if (this.jspStr == null) {
                String string = "#1020 \uc5f0\uacb0\ucd9c\ub825 \ud574\ub2f9 \ubcf4\uace0\uc11c url\uc774 \uc5c6\uc2b5\ub2c8\ub2e4...";
                this.errorLogging(string);
                throw new Exception(string);
            }
        }
        if (!this.jspStr.toLowerCase().startsWith("http")) {
            this.jspStr = AICipherAES128.decrypt(this.jspStr);
            stringArray = this.jspStr.substring(this.jspStr.lastIndexOf("chainReportParams") + 18);
            this.jspStr = this.jspStr.substring(0, this.jspStr.lastIndexOf("chainReportParams") - 1);
        } else {
            stringArray = this.reqres.getParameterB("chainReportParams");
        }
        this.setParam((String)stringArray);
        this.parameterTranferMethod = this.reqres.getRequest().getMethod();
        if (this.parameterTranferMethod == null) {
            this.parameterTranferMethod = "GET";
        }
        this.parameterTranferMethod = this.parameterTranferMethod.toUpperCase();
        stringArray = this.jspStr.split("\\|");
        String string = AIScriptManager.aiProps.getProperties("domainName");
        Object object = AIScriptManager.aiProps.getProperties("ipAddress");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = stringArray[i2].replaceAll("!@", "&");
            if (string == null || object == null) continue;
            stringArray[i2] = stringArray[i2].replace(string, (CharSequence)object);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            Object object2;
            String string2 = "";
            if (stringArray[i3].indexOf("?") != -1) {
                string2 = stringArray[i3].substring(stringArray[i3].indexOf("?") + 1);
            }
            if (string2.indexOf("chainsavename") != -1) {
                object = object2 = string2.substring(13).split(",");
                int n2 = ((String[])object2).length;
                for (int i4 = 0; i4 < n2; ++i4) {
                    object2 = object[i4];
                    String[] stringArray2 = ((String)object2).split(":");
                    if (!stringArray2[0].toLowerCase().equals("chainsavename")) continue;
                    if (stringArray2[1].indexOf("&") != -1) {
                        this.pdfSaveName = stringArray2[1].substring(0, stringArray2[1].indexOf("&")) + ".pdf";
                        break;
                    }
                    this.pdfSaveName = stringArray2[1] + ".pdf";
                    break;
                }
            }
            if (this.parameterTranferMethod.toUpperCase().equals("POST")) {
                if (stringArray[i3].indexOf("?") != -1) {
                    string2 = stringArray[i3].substring(stringArray[i3].indexOf("?") + 1);
                    string2 = string2.indexOf("reportParams=pdfServerSave:true") != -1 ? string2 + "&reportMode=PDF&pdfEditable=true" : string2 + "&reportMode=PDF&reportParams=pdfServerSave:true,pdfEditable:true";
                    object = stringArray[i3].substring(0, stringArray[i3].indexOf("?"));
                } else {
                    string2 = "reportMode=PDF&reportParams=pdfServerSave:true,pdfEditable:true";
                    object = stringArray[i3];
                }
            } else {
                string2 = "";
                object = stringArray[i3].indexOf("?") == -1 ? stringArray[i3] + "?reportMode=PDF&reportParams=pdfServerSave:true,pdfEditable:true" : (stringArray[i3].indexOf("reportParams=pdfServerSave:true") == -1 ? stringArray[i3] + "&reportMode=PDF&reportParams=pdfServerSave:true,pdfEditable:true" : stringArray[i3] + "&reportMode=PDF&pdfEditable=true");
            }
            object2 = null;
            try {
                int n3;
                object2 = (HttpURLConnection)new URL((String)object).openConnection();
                if (!this.parameterTranferMethod.toUpperCase().equals("GET")) {
                    ((HttpURLConnection)object2).setRequestMethod("POST");
                } else {
                    ((HttpURLConnection)object2).setRequestMethod("GET");
                }
                ((URLConnection)object2).setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                ((URLConnection)object2).setRequestProperty("user-agent", this.request.getHeader("user-agent"));
                ((URLConnection)object2).setDoOutput(true);
                if (this.request.getCookies() != null) {
                    object = Arrays.asList(this.request.getCookies()).iterator();
                    StringBuffer stringBuffer = new StringBuffer();
                    while (object.hasNext()) {
                        Cookie cookie = (Cookie)object.next();
                        if (cookie.getValue().equals("")) continue;
                        stringBuffer.append(cookie.getName());
                        stringBuffer.append("=");
                        stringBuffer.append(cookie.getValue());
                        stringBuffer.append("; ");
                    }
                    ((URLConnection)object2).setRequestProperty("Cookie", stringBuffer.toString());
                }
                if (!this.parameterTranferMethod.toUpperCase().equals("GET") && !string2.equals("")) {
                    object = new PrintWriter(new OutputStreamWriter(((URLConnection)object2).getOutputStream(), "utf-8"));
                    ((PrintWriter)object).write(string2);
                    ((PrintWriter)object).flush();
                    ((PrintWriter)object).close();
                }
                if ((n3 = ((HttpURLConnection)object2).getResponseCode()) != 200) {
                    String string3 = "#1030 jsp call failed resultCode=" + n3;
                    this.errorLogging(string3);
                    throw new Exception(string3);
                }
            }
            catch (Exception exception) {
                this.errorLogging("#1040 " + exception);
                throw new Exception("#1040 " + exception);
            }
            object = new String(this.readStreamAll(((URLConnection)object2).getInputStream()), "utf-8");
            object = ((String)object).trim();
            arrayList.add(((String)object).substring(16, ((String)object).length() - 3));
        }
        Object object3 = !this.reqres.getParam("pdfsavename").equals("null") ? (((String)(object = this.reqres.getParam("pdfsavename"))).indexOf("/") != -1 ? object : AIScriptManager.aiURL.getPdfPath() + (String)object) : AIScriptManager.aiURL.getPdfPath() + this.getFilename();
        object = new File((String)object3);
        if (((File)object).exists()) {
            int n4 = 1;
            int n5 = ((String)object3).indexOf(".pdf");
            object = object3;
            while (true) {
                object3 = String.format("%s(%s)%s", ((String)object).substring(0, n5), n4, ((String)object).substring(n5));
                File file = new File((String)object3);
                if (n4 > 100) {
                    object3 = AIScriptManager.aiURL.getPdfPath() + this.getFilename();
                    break;
                }
                if (!file.exists()) break;
                ++n4;
            }
        }
        try {
            Document document = new Document();
            FileOutputStream fileOutputStream = new FileOutputStream((String)object3);
            object = new PdfCopy(document, (OutputStream)fileOutputStream);
            String string4 = this.reqres.getParam("userpassword");
            if (!string4.equals("")) {
                object.setEncryption(string4.getBytes("utf-8"), null, 2052, 2);
            } else if (!this.reqres.pdfEditable) {
                object.setEncryption(null, null, 2052, 2);
            }
            document.open();
            for (int i5 = 0; i5 < arrayList.size(); ++i5) {
                PdfReader pdfReader = new PdfReader((String)arrayList.get(i5));
                int n6 = pdfReader.getNumberOfPages();
                int n7 = 0;
                while (n7 < n6) {
                    object.addPage(object.getImportedPage(pdfReader, ++n7));
                }
            }
            if (this.printDialogFlag) {
                PdfAction pdfAction = new PdfAction(5);
                object.setOpenAction(pdfAction);
            }
            document.close();
        }
        catch (Exception exception) {
            this.errorLogging("#1050 " + exception);
            throw new Exception("#1050 " + exception);
        }
        return object3;
    }

    private void setParam(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        AIFunction.tokenizer(string, 0, string.length(), arrayList, ":,", "", "", "\"'", "", true);
        int n2 = arrayList.size();
        if (n2 % 2 == 0) {
            for (int i2 = 0; i2 < n2; i2 += 2) {
                String string2;
                String string3 = (String)arrayList.get(i2);
                if (this.reqres.setParam(string3, string2 = ((String)arrayList.get(i2 + 1)).replace("!@", ":"))) continue;
                this.errorLogging("#1230 " + string3 + " " + string2);
            }
        }
    }

    private BufferedInputStream getPdfFile(String string) {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        }
        catch (Exception exception) {
            this.errorLogging("#1060 " + exception);
            this.errorLogging("#1061 " + string);
            throw new Exception(exception);
        }
        return bufferedInputStream;
    }

    private String getFilename() {
        Random random = new Random();
        int n2 = random.nextInt();
        String string = "AItoPDF" + String.format("%d", n2) + "-" + this.SystemDate("yyMMddhhmmssSSS") + ".pdf";
        return string;
    }

    private String getFilename2() {
        Object object = new Random();
        ((Random)object).nextInt();
        object = !this.pdfFileName.equals("") ? this.pdfFileName + ".pdf" : "AItoPDF-" + this.SystemDate("yyyyMMddhhmm") + ".pdf";
        return object;
    }

    private byte[] readStreamAll(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[512];
        inputStream = new BufferedInputStream(inputStream, 512);
        try {
            int n2;
            while ((n2 = ((BufferedInputStream)inputStream).read(byArray, 0, 512)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            this.errorLogging("#9030 " + iOException);
            throw new Exception("#9030 " + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private String SystemDate(String object) {
        Calendar calendar = Calendar.getInstance();
        object = new SimpleDateFormat((String)object);
        return ((DateFormat)object).format(calendar.getTime());
    }

    private void debugLogging(Object object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("AIPdfMerge " + object));
        }
    }

    private void errorLogging(Object object) {
        this.log.error((Object)("AIPdfMerge " + object));
    }
}

