/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.manager;

import ai.org.apache.poi.hssf.usermodel.HSSFCell;
import ai.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import ai.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import ai.org.apache.poi.hssf.usermodel.HSSFDataFormat;
import ai.org.apache.poi.hssf.usermodel.HSSFFont;
import ai.org.apache.poi.hssf.usermodel.HSSFPalette;
import ai.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import ai.org.apache.poi.hssf.usermodel.HSSFPicture;
import ai.org.apache.poi.hssf.usermodel.HSSFPictureData;
import ai.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import ai.org.apache.poi.hssf.usermodel.HSSFRow;
import ai.org.apache.poi.hssf.usermodel.HSSFShape;
import ai.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai.org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import ai.org.apache.poi.hssf.usermodel.HSSFTextbox;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.hssf.util.HSSFColor;
import ai.org.apache.poi.ss.usermodel.Font;
import ai.org.apache.poi.ss.usermodel.RichTextString;
import ai.org.apache.poi.ss.usermodel.Workbook;
import ai.org.apache.poi.ss.util.CellRangeAddress;
import com.activeintra.manager.AICipherAES128;
import com.activeintra.manager.AIFunction;
import com.activeintra.manager.AIScriptManager;
import com.activeintra.manager.AIreqres;
import com.activeintra.manager.CellRangeAddressWrapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIExcelMerge {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PageContext pageContext;
    private JspWriter out;
    private Logger log;
    public AIreqres reqres = null;
    private String parameterTranferMethod;
    private String jspStr;
    private String excelFileName;
    private String excelSaveName;
    private static final short[] extraPalette = new short[]{27, 32, 33, 34, 35, 36, 37, 38, 39};
    private int curExtraPaletteIndex;
    private HSSFPalette palette;

    public AIExcelMerge(PageContext pageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Logger logger, AIreqres aIreqres) {
        this.pageContext = pageContext;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.log = logger;
        this.excelFileName = "";
        this.excelSaveName = "";
        this.reqres = aIreqres;
        this.curExtraPaletteIndex = 0;
    }

    public void runMerge(JspWriter jspWriter) {
        this.out = jspWriter;
        String string = this.mergeOut();
        jspWriter.println("[{\"targetURL\": \"" + string + "\"}]");
    }

    public void runMerge() {
        Object object;
        BufferedInputStream bufferedInputStream = this.getExcelFile(this.mergeOut());
        if (this.excelSaveName.equals("")) {
            this.excelSaveName = this.reqres.getParam("excelSaveName");
        }
        if (this.excelSaveName.equals("null")) {
            object = "attachment; filename=" + this.getFilename2();
        } else {
            object = this.reqres.getBrowser().indexOf("Firefox") != -1 ? "attachment; filename=" + new String(this.excelSaveName.getBytes(), "latin1") : (this.reqres.getBrowser().indexOf("Safari") != -1 ? "attachment; filename=" + new String(this.excelSaveName.getBytes(), "latin1") : "attachment; filename=" + URLEncoder.encode(this.excelSaveName, "utf-8"));
            object = ((String)object).replaceAll("\\+", " ");
        }
        this.response.setHeader("Content-Disposition", (String)object);
        this.response.setContentType("application/pdf");
        object = "fileDownloadToken=success; Path=/";
        this.response.setHeader("Set-Cookie", (String)object);
        object = new BufferedOutputStream((OutputStream)this.response.getOutputStream());
        byte[] byArray = new byte[1024];
        int n2 = 0;
        while ((n2 = bufferedInputStream.read(byArray)) != -1) {
            ((BufferedOutputStream)object).write(byArray, 0, n2);
        }
        ((FilterOutputStream)object).close();
        bufferedInputStream.close();
    }

    private String mergeOut() {
        Object object;
        String[] stringArray;
        this.jspStr = this.request.getParameter("key");
        if (this.jspStr == null) {
            this.jspStr = this.request.getParameter("jspURL");
            if (this.jspStr == null) {
                String string = "#1020 \uc5f0\uacb0\ucd9c\ub825 \ud574\ub2f9 \ubcf4\uace0\uc11c url\uc774 \uc5c6\uc2b5\ub2c8\ub2e4...";
                this.errorLogging(string);
                throw new Exception(string);
            }
        }
        if (!this.jspStr.toLowerCase().startsWith("http")) {
            this.jspStr = AICipherAES128.decrypt(this.jspStr);
            stringArray = this.jspStr.substring(this.jspStr.lastIndexOf("chainReportParams") + 18);
            this.jspStr = this.jspStr.substring(0, this.jspStr.lastIndexOf("chainReportParams") - 1);
        } else {
            stringArray = this.reqres.getParameterB("chainReportParams");
        }
        this.setParam((String)stringArray);
        this.parameterTranferMethod = this.reqres.getRequest().getMethod();
        if (this.parameterTranferMethod == null) {
            this.parameterTranferMethod = "GET";
        }
        this.parameterTranferMethod = this.parameterTranferMethod.toUpperCase();
        stringArray = this.jspStr.split("\\|");
        String string = AIScriptManager.aiProps.getProperties("domainName");
        Object object2 = AIScriptManager.aiProps.getProperties("ipAddress");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = stringArray[i2].replaceAll("!@", "&");
            if (string == null || object2 == null) continue;
            stringArray[i2] = stringArray[i2].replace(string, (CharSequence)object2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            String string2;
            if (this.parameterTranferMethod.toUpperCase().equals("POST")) {
                if (stringArray[i3].indexOf("?") != -1) {
                    string2 = stringArray[i3].substring(stringArray[i3].indexOf("?") + 1);
                    string2 = string2.indexOf("reportParams=pdfServerSave:true") != -1 ? string2 + "&reportMode=EXCEL" : string2 + "&reportMode=EXCEL&reportParams=excelServerSave:true";
                    object2 = stringArray[i3].substring(0, stringArray[i3].indexOf("?"));
                } else {
                    string2 = "reportMode=EXCEL&reportParams=excelServerSave:true";
                    object2 = stringArray[i3];
                }
            } else {
                string2 = "";
                object2 = stringArray[i3].indexOf("?") == -1 ? stringArray[i3] + "?reportMode=EXCEL&reportParams=excelServerSave:true" : (stringArray[i3].indexOf("reportParams=pdfServerSave:true") == -1 ? stringArray[i3] + "&reportMode=EXCEL&reportParams=excelServerSave:true" : stringArray[i3] + "&reportMode=EXCEL&reportParams=excelServerSave:true");
            }
            HttpURLConnection httpURLConnection = null;
            try {
                int n2;
                httpURLConnection = (HttpURLConnection)new URL((String)object2).openConnection();
                if (!this.parameterTranferMethod.toUpperCase().equals("GET")) {
                    httpURLConnection.setRequestMethod("POST");
                } else {
                    httpURLConnection.setRequestMethod("GET");
                }
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                httpURLConnection.setRequestProperty("user-agent", this.request.getHeader("user-agent"));
                httpURLConnection.setDoOutput(true);
                if (this.request.getCookies() != null) {
                    object2 = Arrays.asList(this.request.getCookies()).iterator();
                    object = new StringBuffer();
                    while (object2.hasNext()) {
                        Cookie cookie = object2.next();
                        if (cookie.getValue().equals("")) continue;
                        ((StringBuffer)object).append(cookie.getName());
                        ((StringBuffer)object).append("=");
                        ((StringBuffer)object).append(cookie.getValue());
                        ((StringBuffer)object).append("; ");
                    }
                    httpURLConnection.setRequestProperty("Cookie", ((StringBuffer)object).toString());
                }
                if (!this.parameterTranferMethod.toUpperCase().equals("GET") && !string2.equals("")) {
                    object2 = new PrintWriter(new OutputStreamWriter(httpURLConnection.getOutputStream(), "utf-8"));
                    ((PrintWriter)object2).write(string2);
                    ((PrintWriter)object2).flush();
                    ((PrintWriter)object2).close();
                }
                if ((n2 = httpURLConnection.getResponseCode()) != 200) {
                    object = "#1030 jsp call failed resultCode=" + n2;
                    this.errorLogging(object);
                    throw new Exception((String)object);
                }
            }
            catch (Exception exception) {
                this.errorLogging("#1040 " + exception);
                throw new Exception("#1040 " + exception);
            }
            object2 = new String(this.readStreamAll(httpURLConnection.getInputStream()), "utf-8");
            object2 = ((String)object2).trim();
            arrayList.add(((String)object2).substring(16, ((String)object2).length() - 3));
        }
        String string3 = AIScriptManager.aiURL.getPdfPath() + this.getFilename();
        object2 = new File(string3);
        if (((File)object2).exists()) {
            int n3 = 1;
            int n4 = string3.indexOf(".xls");
            object2 = string3;
            while (true) {
                string3 = String.format("%s(%s)%s", ((String)object2).substring(0, n4), n3, ((String)object2).substring(n4));
                object = new File(string3);
                if (n3 > 100) {
                    string3 = AIScriptManager.aiURL.getPdfPath() + this.getFilename();
                    break;
                }
                if (!((File)object).exists()) break;
                ++n3;
            }
        }
        try {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook();
            this.palette = hSSFWorkbook.getCustomPalette();
            this.mergeExcelFiles(hSSFWorkbook, arrayList);
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            try {
                hSSFWorkbook.write((OutputStream)fileOutputStream);
            }
            catch (IOException iOException) {
                fileOutputStream.close();
                this.errorLogging("#1049 " + iOException);
                throw new Exception(iOException);
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.errorLogging("#1050 " + exception);
            throw new Exception("#1050 " + exception);
        }
        return string3;
    }

    private HSSFWorkbook mergeExcelFiles(HSSFWorkbook hSSFWorkbook, ArrayList<String> object) {
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                string = new HSSFWorkbook((InputStream)fileInputStream);
                for (int i2 = 0; i2 < string.getNumberOfSheets(); ++i2) {
                    this.copySheets(hSSFWorkbook.createSheet(), string.getSheetAt(i2));
                }
                fileInputStream.close();
            }
            catch (Exception exception) {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                this.errorLogging("#1051 " + exception);
                throw new Exception("#1051 " + exception);
            }
        }
        return hSSFWorkbook;
    }

    private void copyObject(HSSFSheet hSSFSheet, HSSFSheet hSSFSheet2) {
        if (hSSFSheet2.getDrawingPatriarch() == null) {
            return;
        }
        List list = hSSFSheet2.getDrawingPatriarch().getChildren();
        if (list == null) {
            return;
        }
        HSSFPalette hSSFPalette = hSSFSheet2.getWorkbook().getCustomPalette();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            HSSFRichTextString hSSFRichTextString;
            HSSFPicture hSSFPicture;
            HSSFPatriarch hSSFPatriarch = hSSFSheet.createDrawingPatriarch();
            HSSFShape hSSFShape = (HSSFShape)list.get(i2);
            HSSFClientAnchor hSSFClientAnchor = (HSSFClientAnchor)hSSFShape.getAnchor();
            HSSFSimpleShape hSSFSimpleShape = (HSSFSimpleShape)hSSFShape;
            if (hSSFShape instanceof HSSFPicture) {
                hSSFPicture = (HSSFPicture)hSSFShape;
                hSSFRichTextString = (HSSFPictureData)hSSFSheet2.getWorkbook().getAllPictures().get(hSSFPicture.getPictureIndex() - 1);
                int n2 = hSSFSheet.getWorkbook().addPicture(hSSFRichTextString.getData(), hSSFRichTextString.getFormat());
                hSSFPatriarch.createPicture(hSSFClientAnchor, n2);
                continue;
            }
            if (hSSFShape instanceof HSSFTextbox) {
                hSSFPicture = hSSFPatriarch.createTextbox(hSSFClientAnchor);
                hSSFRichTextString = ((HSSFTextbox)hSSFShape).getString();
                HSSFRichTextString hSSFRichTextString2 = new HSSFRichTextString(hSSFRichTextString.toString());
                short s2 = 0;
                int n3 = 0;
                for (int i3 = 0; i3 < hSSFRichTextString2.length(); ++i3) {
                    short s3 = hSSFRichTextString.getFontAtIndex(i3);
                    if (s2 == 0) {
                        s2 = s3;
                    }
                    if (s2 == s3 && i3 != hSSFRichTextString2.length() - 1) continue;
                    HSSFFont hSSFFont = hSSFSheet2.getWorkbook().getFontAt(s2);
                    HSSFFont hSSFFont2 = hSSFSheet.getWorkbook().findFont(hSSFFont.getBoldweight(), hSSFFont.getColor(), hSSFFont.getFontHeight(), hSSFFont.getFontName(), hSSFFont.getItalic(), false, (short)0, hSSFFont.getUnderline());
                    if (hSSFFont2 == null) {
                        hSSFFont2 = hSSFSheet.getWorkbook().createFont();
                        hSSFFont2.setFontName(hSSFFont.getFontName());
                        HSSFColor hSSFColor = hSSFPalette.getColor(hSSFFont.getColor());
                        hSSFFont2.setColor(this.getColorIndex(hSSFColor.getTriplet()));
                        hSSFFont2.setFontHeight(hSSFFont.getFontHeight());
                        hSSFFont2.setBoldweight(hSSFFont.getBoldweight());
                        hSSFFont2.setItalic(hSSFFont.getItalic());
                        hSSFFont2.setUnderline(hSSFFont.getUnderline());
                    }
                    hSSFRichTextString2.applyFont(n3, i3 + 1, (Font)hSSFFont2);
                    n3 = i3;
                    s2 = s3;
                }
                hSSFPicture.setString((RichTextString)hSSFRichTextString2);
                hSSFPicture.setHorizontalAlignment(((HSSFTextbox)hSSFShape).getHorizontalAlignment());
                hSSFPicture.setVerticalAlignment(((HSSFTextbox)hSSFShape).getVerticalAlignment());
                hSSFPicture.setString((RichTextString)((HSSFSimpleShape)hSSFShape).getString());
                if (hSSFSimpleShape.getLineStyle() != -1) {
                    hSSFPicture.setLineStyle(hSSFSimpleShape.getLineStyle());
                } else {
                    hSSFPicture.setLineStyle(-1);
                }
                hSSFPicture.setMarginLeft(25400);
                hSSFPicture.setMarginTop(25400);
                hSSFPicture.setMarginRight(25400);
                hSSFPicture.setMarginBottom(25400);
                if (hSSFSimpleShape.isNoFill()) {
                    hSSFPicture.setNoFill(true);
                    continue;
                }
                hSSFPicture.setFillColor(hSSFSimpleShape.getFillColor());
                continue;
            }
            if (hSSFSimpleShape.getShapeType() == 20) {
                hSSFPicture = hSSFPatriarch.createSimpleShape(hSSFClientAnchor);
                hSSFPicture.setShapeType(20);
                hSSFPicture.setLineStyleColor(hSSFSimpleShape.getLineStyleColor());
                hSSFPicture.setLineWidth(hSSFSimpleShape.getLineWidth());
                if (hSSFSimpleShape.getLineStyle() == -1) continue;
                hSSFPicture.setLineStyle(hSSFSimpleShape.getLineStyle());
                continue;
            }
            if (hSSFSimpleShape.getShapeType() == 1) {
                hSSFPicture = hSSFPatriarch.createSimpleShape(hSSFClientAnchor);
                hSSFPicture.setShapeType(1);
                hSSFPicture.setLineStyleColor(hSSFSimpleShape.getLineStyleColor());
                hSSFPicture.setLineWidth(hSSFSimpleShape.getLineWidth());
                if (hSSFSimpleShape.getLineStyle() != -1) {
                    hSSFPicture.setLineStyle(hSSFSimpleShape.getLineStyle());
                }
                if (hSSFSimpleShape.isNoFill()) {
                    hSSFPicture.setNoFill(true);
                    continue;
                }
                hSSFPicture.setFillColor(hSSFSimpleShape.getFillColor());
                continue;
            }
            if (hSSFSimpleShape.getShapeType() == 2) {
                hSSFPicture = hSSFPatriarch.createSimpleShape(hSSFClientAnchor);
                hSSFPicture.setShapeType(2);
                hSSFPicture.setLineStyleColor(hSSFSimpleShape.getLineStyleColor());
                hSSFPicture.setLineWidth(hSSFSimpleShape.getLineWidth());
                if (hSSFSimpleShape.getLineStyle() != -1) {
                    hSSFPicture.setLineStyle(hSSFSimpleShape.getLineStyle());
                }
                if (hSSFSimpleShape.isNoFill()) {
                    hSSFPicture.setNoFill(true);
                    continue;
                }
                hSSFPicture.setFillColor(hSSFSimpleShape.getFillColor());
                continue;
            }
            if (hSSFSimpleShape.getShapeType() != 3) continue;
            hSSFPicture = hSSFPatriarch.createSimpleShape(hSSFClientAnchor);
            hSSFPicture.setShapeType(3);
            hSSFPicture.setLineStyleColor(hSSFSimpleShape.getLineStyleColor());
            hSSFPicture.setLineWidth(hSSFSimpleShape.getLineWidth());
            if (hSSFSimpleShape.getLineStyle() != -1) {
                hSSFPicture.setLineStyle(hSSFSimpleShape.getLineStyle());
            }
            if (hSSFSimpleShape.isNoFill()) {
                hSSFPicture.setNoFill(true);
                continue;
            }
            hSSFPicture.setFillColor(hSSFSimpleShape.getFillColor());
        }
    }

    private void copySheets(HSSFSheet hSSFSheet, HSSFSheet hSSFSheet2) {
        this.copySheets(hSSFSheet, hSSFSheet2, true);
        this.copyObject(hSSFSheet, hSSFSheet2);
    }

    private void copySheets(HSSFSheet hSSFSheet, HSSFSheet hSSFSheet2, boolean bl) {
        int n2;
        int n3 = 0;
        HashMap<Integer, HSSFCellStyle> hashMap = bl ? new HashMap<Integer, HSSFCellStyle>() : null;
        for (n2 = hSSFSheet2.getFirstRowNum(); n2 <= hSSFSheet2.getLastRowNum(); ++n2) {
            HSSFRow hSSFRow = hSSFSheet2.getRow(n2);
            HSSFRow hSSFRow2 = hSSFSheet.createRow(n2);
            if (hSSFRow == null) continue;
            this.copyRow(hSSFSheet2, hSSFSheet, hSSFRow, hSSFRow2, hashMap);
            if (hSSFRow.getLastCellNum() <= n3) continue;
            n3 = hSSFRow.getLastCellNum();
        }
        for (n2 = 0; n2 <= n3; ++n2) {
            hSSFSheet.setColumnWidth(n2, hSSFSheet2.getColumnWidth(n2));
        }
    }

    private void copyRow(HSSFSheet hSSFSheet, HSSFSheet hSSFSheet2, HSSFRow hSSFRow, HSSFRow hSSFRow2, Map<Integer, HSSFCellStyle> map) {
        TreeSet<CellRangeAddressWrapper> treeSet = new TreeSet<CellRangeAddressWrapper>();
        hSSFRow2.setHeight(hSSFRow.getHeight());
        int n2 = hSSFRow2.getRowNum() - hSSFRow.getRowNum();
        for (int i2 = hSSFRow.getFirstCellNum(); i2 <= hSSFRow.getLastCellNum(); ++i2) {
            Object object = hSSFRow.getCell(i2);
            HSSFCell hSSFCell = hSSFRow2.getCell(i2);
            if (object == null) continue;
            if (hSSFCell == null) {
                hSSFCell = hSSFRow2.createCell(i2);
            }
            this.copyCell((HSSFCell)object, hSSFCell, map);
            object = this.getMergedRegion(hSSFSheet, hSSFRow.getRowNum(), (short)object.getColumnIndex());
            if (object == null) continue;
            object = new CellRangeAddress(object.getFirstRow() + n2, object.getLastRow() + n2, object.getFirstColumn(), object.getLastColumn());
            if (!this.isNewMergedRegion((CellRangeAddressWrapper)(object = new CellRangeAddressWrapper((CellRangeAddress)object)), treeSet)) continue;
            treeSet.add((CellRangeAddressWrapper)object);
            hSSFSheet2.addMergedRegion(object.range);
        }
    }

    private void copyCell(HSSFCell hSSFCell, HSSFCell hSSFCell2, Map<Integer, HSSFCellStyle> hSSFFont) {
        HSSFRichTextString hSSFRichTextString;
        HSSFPalette hSSFPalette = hSSFCell.getSheet().getWorkbook().getCustomPalette();
        if (hSSFFont != null) {
            if (hSSFCell.getSheet().getWorkbook() == hSSFCell2.getSheet().getWorkbook()) {
                hSSFCell2.setCellStyle(hSSFCell.getCellStyle());
            } else {
                int n2 = hSSFCell.getCellStyle().hashCode();
                hSSFRichTextString = hSSFFont.get(n2);
                HSSFCellStyle hSSFCellStyle = hSSFCell.getCellStyle();
                if (hSSFRichTextString == null) {
                    HSSFDataFormat hSSFDataFormat;
                    hSSFRichTextString = hSSFCell2.getSheet().getWorkbook().createCellStyle();
                    hSSFRichTextString.setWrapText(hSSFCellStyle.getWrapText());
                    HSSFColor hSSFColor = hSSFPalette.getColor(hSSFCellStyle.getFillForegroundColor());
                    hSSFRichTextString.setFillForegroundColor(this.getColorIndex(hSSFColor.getTriplet()));
                    hSSFRichTextString.setFillPattern(hSSFCellStyle.getFillPattern());
                    hSSFRichTextString.setAlignment(hSSFCellStyle.getAlignment());
                    hSSFRichTextString.setVerticalAlignment(hSSFCellStyle.getVerticalAlignment());
                    if (hSSFCellStyle.getDataFormat() != 0) {
                        hSSFDataFormat = hSSFCell2.getSheet().getWorkbook().createDataFormat();
                        hSSFRichTextString.setDataFormat(hSSFDataFormat.getFormat(hSSFCellStyle.getDataFormatString()));
                    }
                    hSSFRichTextString.setBorderLeft(hSSFCellStyle.getBorderLeft());
                    hSSFColor = hSSFPalette.getColor(hSSFCellStyle.getLeftBorderColor());
                    hSSFRichTextString.setLeftBorderColor(this.getColorIndex(hSSFColor.getTriplet()));
                    hSSFRichTextString.setBorderTop(hSSFCellStyle.getBorderTop());
                    hSSFColor = hSSFPalette.getColor(hSSFCellStyle.getTopBorderColor());
                    hSSFRichTextString.setTopBorderColor(this.getColorIndex(hSSFColor.getTriplet()));
                    hSSFRichTextString.setBorderRight(hSSFCellStyle.getBorderRight());
                    hSSFColor = hSSFPalette.getColor(hSSFCellStyle.getRightBorderColor());
                    hSSFRichTextString.setRightBorderColor(this.getColorIndex(hSSFColor.getTriplet()));
                    hSSFRichTextString.setBorderBottom(hSSFCellStyle.getBorderBottom());
                    hSSFColor = hSSFPalette.getColor(hSSFCellStyle.getBottomBorderColor());
                    hSSFRichTextString.setBottomBorderColor(this.getColorIndex(hSSFColor.getTriplet()));
                    hSSFDataFormat = hSSFCellStyle.getFont((Workbook)hSSFCell.getSheet().getWorkbook());
                    HSSFFont hSSFFont2 = hSSFCell2.getSheet().getWorkbook().findFont(hSSFDataFormat.getBoldweight(), hSSFDataFormat.getColor(), hSSFDataFormat.getFontHeight(), hSSFDataFormat.getFontName(), hSSFDataFormat.getItalic(), false, (short)0, hSSFDataFormat.getUnderline());
                    if (hSSFFont2 == null) {
                        hSSFFont2 = hSSFCell2.getSheet().getWorkbook().createFont();
                        hSSFFont2.setFontName(hSSFDataFormat.getFontName());
                        hSSFColor = hSSFPalette.getColor(hSSFDataFormat.getColor());
                        hSSFFont2.setColor(this.getColorIndex(hSSFColor.getTriplet()));
                        hSSFFont2.setFontHeight(hSSFDataFormat.getFontHeight());
                        hSSFFont2.setBoldweight(hSSFDataFormat.getBoldweight());
                        hSSFFont2.setItalic(hSSFDataFormat.getItalic());
                        hSSFFont2.setUnderline(hSSFDataFormat.getUnderline());
                    }
                    hSSFRichTextString.setFont(hSSFFont2);
                    hSSFFont.put(n2, hSSFRichTextString);
                }
                hSSFCell2.setCellStyle((HSSFCellStyle)hSSFRichTextString);
            }
        }
        switch (hSSFCell.getCellType()) {
            case 1: {
                HSSFRichTextString hSSFRichTextString2 = hSSFCell.getRichStringCellValue();
                hSSFRichTextString = new HSSFRichTextString(hSSFRichTextString2.toString());
                short s2 = 0;
                int n3 = 0;
                for (int i2 = 0; i2 < hSSFRichTextString.length(); ++i2) {
                    short s3 = hSSFRichTextString2.getFontAtIndex(i2);
                    if (s2 == 0) {
                        s2 = s3;
                    }
                    if (s2 == s3 && i2 != hSSFRichTextString.length() - 1) continue;
                    hSSFFont = hSSFCell.getSheet().getWorkbook().getFontAt(s2);
                    HSSFFont hSSFFont3 = hSSFCell2.getSheet().getWorkbook().findFont(hSSFFont.getBoldweight(), hSSFFont.getColor(), hSSFFont.getFontHeight(), hSSFFont.getFontName(), hSSFFont.getItalic(), false, (short)0, hSSFFont.getUnderline());
                    if (hSSFFont3 == null) {
                        hSSFFont3 = hSSFCell2.getSheet().getWorkbook().createFont();
                        hSSFFont3.setFontName(hSSFFont.getFontName());
                        HSSFColor hSSFColor = hSSFPalette.getColor(hSSFFont.getColor());
                        hSSFFont3.setColor(this.getColorIndex(hSSFColor.getTriplet()));
                        hSSFFont3.setFontHeight(hSSFFont.getFontHeight());
                        hSSFFont3.setBoldweight(hSSFFont.getBoldweight());
                        hSSFFont3.setItalic(hSSFFont.getItalic());
                        hSSFFont3.setUnderline(hSSFFont.getUnderline());
                    }
                    hSSFRichTextString.applyFont(n3, i2 + 1, (Font)hSSFFont3);
                    n3 = i2;
                    s2 = s3;
                }
                hSSFCell2.setCellValue((RichTextString)hSSFRichTextString);
                return;
            }
            case 0: {
                hSSFCell2.setCellValue(hSSFCell.getNumericCellValue());
                return;
            }
            case 3: {
                hSSFCell2.setCellType(3);
                return;
            }
            case 4: {
                hSSFCell2.setCellValue(hSSFCell.getBooleanCellValue());
                return;
            }
            case 5: {
                hSSFCell2.setCellErrorValue(hSSFCell.getErrorCellValue());
                return;
            }
            case 2: {
                hSSFCell2.setCellFormula(hSSFCell.getCellFormula());
            }
        }
    }

    private CellRangeAddress getMergedRegion(HSSFSheet hSSFSheet, int n2, short s2) {
        for (int i2 = 0; i2 < hSSFSheet.getNumMergedRegions(); ++i2) {
            CellRangeAddress cellRangeAddress = hSSFSheet.getMergedRegion(i2);
            if (!cellRangeAddress.isInRange(n2, (int)s2)) continue;
            return cellRangeAddress;
        }
        return null;
    }

    private boolean isNewMergedRegion(CellRangeAddressWrapper cellRangeAddressWrapper, Set<CellRangeAddressWrapper> set) {
        return !set.contains(cellRangeAddressWrapper);
    }

    private short getColorIndex(short[] sArray) {
        HSSFColor hSSFColor;
        byte by = (byte)sArray[0];
        byte by2 = (byte)sArray[1];
        byte by3 = (byte)sArray[2];
        if (this.curExtraPaletteIndex < 9) {
            hSSFColor = this.palette.findColor(by, by2, by3);
            if (hSSFColor == null) {
                this.palette.setColorAtIndex(extraPalette[this.curExtraPaletteIndex], by, by2, by3);
                hSSFColor = this.palette.getColor(extraPalette[this.curExtraPaletteIndex]);
                ++this.curExtraPaletteIndex;
            }
        } else {
            hSSFColor = this.palette.findSimilarColor(by, by2, by3);
        }
        return hSSFColor.getIndex();
    }

    private void setParam(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        AIFunction.tokenizer(string, 0, string.length(), arrayList, ":,", "", "", "\"'", "", true);
        int n2 = arrayList.size();
        if (n2 % 2 == 0) {
            for (int i2 = 0; i2 < n2; i2 += 2) {
                String string2;
                String string3 = (String)arrayList.get(i2);
                if (this.reqres.setParam(string3, string2 = ((String)arrayList.get(i2 + 1)).replace("!@", ":"))) continue;
                this.errorLogging("#1230 " + string3 + " " + string2);
            }
        }
    }

    private BufferedInputStream getExcelFile(String string) {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        }
        catch (Exception exception) {
            this.errorLogging("#1060 " + exception);
            this.errorLogging("#1061 " + string);
            throw new Exception(exception);
        }
        return bufferedInputStream;
    }

    private String getFilename() {
        Random random = new Random();
        int n2 = random.nextInt();
        String string = !this.excelFileName.equals("") ? this.excelFileName : "AItoExcel" + String.format("%d", n2) + "-" + this.SystemDate("yyMMddhhmmssSSS") + ".xls";
        return string;
    }

    private String getFilename2() {
        Object object = new Random();
        ((Random)object).nextInt();
        object = !this.excelFileName.equals("") ? this.excelFileName + ".xls" : "AItoExcel-" + this.SystemDate("yyyyMMddhhmm") + ".xls";
        return object;
    }

    private byte[] readStreamAll(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[512];
        inputStream = new BufferedInputStream(inputStream, 512);
        try {
            int n2;
            while ((n2 = ((BufferedInputStream)inputStream).read(byArray, 0, 512)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            this.errorLogging("#9030 " + iOException);
            throw new Exception("#9030 " + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private String SystemDate(String object) {
        Calendar calendar = Calendar.getInstance();
        object = new SimpleDateFormat((String)object);
        return ((DateFormat)object).format(calendar.getTime());
    }

    private void debugLogging(Object object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("AIExcelMerge " + object));
        }
    }

    private void errorLogging(Object object) {
        this.log.error((Object)("AIExcelMerge " + object));
    }
}

