/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.tools;

public class MimeTypes {
    public static final String MIME_SVG = "image/svg+xml";
    public static final String MIME_EPS = "image/x-eps";
    public static final String MIME_TIFF = "image/tiff";
    public static final String MIME_JPEG = "image/jpeg";
    public static final String MIME_PNG = "image/x-png";
    public static final String MIME_GIF = "image/gif";
    public static final String MIME_BMP = "image/bmp";
    private static final String[][] FORMAT_MAPPINGS = new String[][]{{"svg", "image/svg+xml"}, {"eps", "image/x-eps"}, {"image/eps", "image/x-eps"}, {"tif", "image/tiff"}, {"tiff", "image/tiff"}, {"jpg", "image/jpeg"}, {"jpeg", "image/jpeg"}, {"png", "image/x-png"}, {"image/png", "image/x-png"}, {"gif", "image/gif"}, {"image/x-bmp", "image/bmp"}, {"bmp", "image/bmp"}};

    protected MimeTypes() {
        throw new UnsupportedOperationException();
    }

    public static String expandFormat(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (int i = 0; i < FORMAT_MAPPINGS.length; ++i) {
            if (!string.equalsIgnoreCase(FORMAT_MAPPINGS[i][0]) && !string.equals(FORMAT_MAPPINGS[i][1])) continue;
            return FORMAT_MAPPINGS[i][1];
        }
        return string.toLowerCase();
    }

    public static boolean isBitmapFormat(String string) {
        String string2 = MimeTypes.expandFormat(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals(MIME_JPEG) || string2.equals(MIME_TIFF) || string2.equals(MIME_PNG) || string2.equals(MIME_GIF) || string2.equals(MIME_BMP);
    }
}

