/*
 * Decompiled with CFR 0.152.
 */
package ai.org.krysalis.barcode4j.tools;

import ai.org.krysalis.barcode4j.tools.UnitConv;

public class Length {
    public static final String INCH = "in";
    public static final String POINT = "pt";
    public static final String CM = "cm";
    public static final String MM = "mm";
    private double value;
    private String unit;

    public Length(double d, String string) {
        this.value = d;
        this.unit = string.toLowerCase();
    }

    public Length(String string, String string2) {
        this.parse(string, string2);
    }

    public Length(String string) {
        this(string, null);
    }

    protected void parse(String string, String string2) {
        String string3 = string.trim();
        if (string3.length() == 0) {
            throw new IllegalArgumentException("Length is empty");
        }
        StringBuffer stringBuffer = new StringBuffer(string3.length());
        int n = 0;
        int n2 = 0;
        while (n2 < string3.length()) {
            char c = string3.charAt(n2);
            if (n == 0) {
                if (Character.isDigit(c) || c == '.' || c == ',') {
                    if (c == ',') {
                        c = '.';
                    }
                    stringBuffer.append(c);
                    ++n2;
                    continue;
                }
                this.value = Double.parseDouble(stringBuffer.toString());
                stringBuffer.setLength(0);
                n = 1;
                continue;
            }
            if (n == 1) {
                if (Character.isWhitespace(c)) {
                    ++n2;
                    continue;
                }
                n = 2;
                continue;
            }
            if (n != 2) continue;
            if (Character.isWhitespace(c)) break;
            stringBuffer.append(c);
            ++n2;
        }
        if (n == 0) {
            this.value = Double.parseDouble(stringBuffer.toString());
            n = 1;
        }
        if (n != 2) {
            if (n > 0 && string2 != null) {
                this.unit = string2.toLowerCase();
                return;
            }
            throw new IllegalArgumentException("Invalid length specified. Expected '<value> <unit>' (ex. 1.7mm) but got: " + string);
        }
        this.unit = stringBuffer.toString().toLowerCase();
    }

    public String getUnit() {
        return this.unit;
    }

    public double getValue() {
        return this.value;
    }

    public double getValueAsMillimeter() {
        if (this.unit.equals(MM)) {
            return this.value;
        }
        if (this.unit.equals(CM)) {
            return this.value * 10.0;
        }
        if (this.unit.equals(POINT)) {
            return UnitConv.pt2mm(this.value);
        }
        if (this.unit.equals(INCH)) {
            return UnitConv.in2mm(this.value);
        }
        throw new IllegalStateException("Don't know how to convert " + this.unit + " to mm");
    }

    public String toString() {
        return this.getValue() + this.getUnit();
    }
}

